/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.api;

import com.intellij.station.comms.common.api.Codec;
import com.intellij.station.comms.common.api.ServiceMetaInfoKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

public final class KotlinCodec<Request, Response>
implements Codec<Request, Response> {
    @NotNull
    private final KSerializer<Request> requestSerializer;
    @NotNull
    private final KSerializer<Response> responseSerializer;
    @NotNull
    private final SerialFormat format;
    @NotNull
    private final String contentType;
    @NotNull
    private final BinaryFormat binaryFormat;

    public KotlinCodec(@NotNull KSerializer<Request> requestSerializer, @NotNull KSerializer<Response> responseSerializer, @NotNull SerialFormat format) {
        BinaryFormat binaryFormat2;
        Intrinsics.checkNotNullParameter(requestSerializer, (String)"requestSerializer");
        Intrinsics.checkNotNullParameter(responseSerializer, (String)"responseSerializer");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.requestSerializer = requestSerializer;
        this.responseSerializer = responseSerializer;
        this.format = format;
        this.contentType = this.format instanceof Json ? "application/json" : "application/octet-stream";
        SerialFormat serialFormat = this.format;
        if (serialFormat instanceof BinaryFormat) {
            binaryFormat2 = (BinaryFormat)this.format;
        } else if (serialFormat instanceof StringFormat) {
            binaryFormat2 = new BinaryFormat(this){
                final /* synthetic */ KotlinCodec<Request, Response> this$0;
                {
                    this.this$0 = $receiver;
                }

                public SerializersModule getSerializersModule() {
                    return KotlinCodec.access$getFormat$p(this.this$0).getSerializersModule();
                }

                public <T> byte[] encodeToByteArray(SerializationStrategy<? super T> serializer2, T value2) {
                    Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
                    return StringsKt.encodeToByteArray((String)((StringFormat)KotlinCodec.access$getFormat$p(this.this$0)).encodeToString(serializer2, value2));
                }

                public <T> T decodeFromByteArray(DeserializationStrategy<? extends T> deserializer, byte[] bytes2) {
                    Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
                    Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
                    return (T)((StringFormat)KotlinCodec.access$getFormat$p(this.this$0)).decodeFromString(deserializer, StringsKt.decodeToString((byte[])bytes2));
                }
            };
        } else {
            throw new UnsupportedOperationException("Unknown serialization format " + this.format);
        }
        this.binaryFormat = binaryFormat2;
    }

    public /* synthetic */ KotlinCodec(KSerializer kSerializer, KSerializer kSerializer2, SerialFormat serialFormat, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            serialFormat = (SerialFormat)ServiceMetaInfoKt.access$getDefaultJsonConfig$p();
        }
        this(kSerializer, kSerializer2, serialFormat);
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public byte[] encodeRequest(@NotNull Request data2) {
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        return this.binaryFormat.encodeToByteArray((SerializationStrategy)this.requestSerializer, data2);
    }

    @Override
    @NotNull
    public Request decodeRequest(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (Request)this.binaryFormat.decodeFromByteArray((DeserializationStrategy)this.requestSerializer, data2);
    }

    @Override
    @NotNull
    public byte[] encodeResponse(@NotNull Response data2) {
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        return this.binaryFormat.encodeToByteArray((SerializationStrategy)this.responseSerializer, data2);
    }

    @Override
    @NotNull
    public Response decodeResponse(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (Response)this.binaryFormat.decodeFromByteArray((DeserializationStrategy)this.responseSerializer, data2);
    }

    public static final /* synthetic */ SerialFormat access$getFormat$p(KotlinCodec $this) {
        return $this.format;
    }
}

