/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.codeStyle.AsciiUtils;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.NameUtilCore;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MinusculeMatcherImpl
extends MinusculeMatcher {
    private final char[] myPattern;
    private final String myHardSeparators;
    private final NameUtil.MatchingCaseSensitivity myOptions;
    private final boolean myHasHumps;
    private final boolean myHasSeparators;
    private final boolean myHasDots;
    private final boolean[] isLowerCase;
    private final boolean[] isUpperCase;
    private final boolean[] isWordSeparator;
    private final char[] toUpperCase;
    private final char[] toLowerCase;
    private final char[] myMeaningfulCharacters;
    private final int myMinNameLength;

    MinusculeMatcherImpl(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, @NotNull String hardSeparators) {
        if (pattern == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(0);
        }
        if (options == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(1);
        }
        if (hardSeparators == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(2);
        }
        this.myOptions = options;
        this.myPattern = Strings.trimEnd(pattern, "* ").toCharArray();
        this.myHardSeparators = hardSeparators;
        this.isLowerCase = new boolean[this.myPattern.length];
        this.isUpperCase = new boolean[this.myPattern.length];
        this.isWordSeparator = new boolean[this.myPattern.length];
        this.toUpperCase = new char[this.myPattern.length];
        this.toLowerCase = new char[this.myPattern.length];
        StringBuilder meaningful = new StringBuilder();
        for (int k = 0; k < this.myPattern.length; ++k) {
            char c = this.myPattern[k];
            this.isLowerCase[k] = Character.isLowerCase(c);
            this.isUpperCase[k] = Character.isUpperCase(c);
            this.isWordSeparator[k] = MinusculeMatcherImpl.isWordSeparator(c);
            this.toUpperCase[k] = Strings.toUpperCase(c);
            this.toLowerCase[k] = Strings.toLowerCase(c);
            if (this.isWildcard(k)) continue;
            meaningful.append(this.toLowerCase[k]);
            meaningful.append(this.toUpperCase[k]);
        }
        int i2 = 0;
        while (this.isWildcard(i2)) {
            ++i2;
        }
        this.myHasHumps = this.hasFlag(i2 + 1, this.isUpperCase) && this.hasFlag(i2, this.isLowerCase);
        this.myHasSeparators = this.hasFlag(i2, this.isWordSeparator);
        this.myHasDots = this.hasDots(i2);
        this.myMeaningfulCharacters = meaningful.toString().toCharArray();
        this.myMinNameLength = this.myMeaningfulCharacters.length / 2;
    }

    private static boolean isWordSeparator(char c) {
        return Character.isWhitespace(c) || c == '_' || c == '-' || c == ':' || c == '+' || c == '.';
    }

    private static int nextWord(@NotNull String name2, int start2) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(3);
        }
        if (start2 < name2.length() && Character.isDigit(name2.charAt(start2))) {
            return start2 + 1;
        }
        return NameUtilCore.nextWord(name2, start2);
    }

    private boolean hasFlag(int start2, boolean[] flags) {
        for (int i2 = start2; i2 < this.myPattern.length; ++i2) {
            if (!flags[i2]) continue;
            return true;
        }
        return false;
    }

    private boolean hasDots(int start2) {
        for (int i2 = start2; i2 < this.myPattern.length; ++i2) {
            if (this.myPattern[i2] != '.') continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static FList<TextRange> prependRange(@NotNull FList<TextRange> ranges, int from, int length) {
        TextRange head;
        if (ranges == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(4);
        }
        if ((head = ranges.getHead()) != null && head.getStartOffset() == from + length) {
            FList<TextRange> fList = ranges.getTail().prepend(new TextRange(from, head.getEndOffset()));
            if (fList == null) {
                MinusculeMatcherImpl.$$$reportNull$$$0(5);
            }
            return fList;
        }
        FList<TextRange> fList = ranges.prepend(TextRange.from(from, length));
        if (fList == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(6);
        }
        return fList;
    }

    @Override
    public int matchingDegree(@NotNull String name2, boolean valueStartCaseMatch, @Nullable FList<? extends TextRange> fragments) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(7);
        }
        if (fragments == null) {
            return Integer.MIN_VALUE;
        }
        if (fragments.isEmpty()) {
            return 0;
        }
        TextRange first = fragments.getHead();
        boolean startMatch = first.getStartOffset() == 0;
        boolean valuedStartMatch = startMatch && valueStartCaseMatch;
        int matchingCase = 0;
        int p = -1;
        int skippedHumps = 0;
        int nextHumpStart = 0;
        boolean humpStartMatchedUpperCase = false;
        block0: for (TextRange textRange : fragments) {
            for (int i2 = textRange.getStartOffset(); i2 < textRange.getEndOffset(); ++i2) {
                boolean afterGap = i2 == textRange.getStartOffset() && first != textRange;
                boolean isHumpStart = false;
                while (nextHumpStart <= i2) {
                    if (nextHumpStart == i2) {
                        isHumpStart = true;
                    } else if (afterGap) {
                        ++skippedHumps;
                    }
                    nextHumpStart = MinusculeMatcherImpl.nextWord(name2, nextHumpStart);
                }
                char c = name2.charAt(i2);
                p = Strings.indexOf(this.myPattern, c, p + 1, this.myPattern.length, false);
                if (p < 0) continue block0;
                if (isHumpStart) {
                    humpStartMatchedUpperCase = c == this.myPattern[p] && this.isUpperCase[p];
                }
                matchingCase += this.evaluateCaseMatching(valuedStartMatch, p, humpStartMatchedUpperCase, i2, afterGap, isHumpStart, c);
            }
        }
        int startIndex = first.getStartOffset();
        boolean bl = Strings.indexOfAny(name2, this.myHardSeparators, 0, startIndex) >= 0;
        boolean wordStart = startIndex == 0 || NameUtilCore.isWordStart(name2, startIndex) && !NameUtilCore.isWordStart(name2, startIndex - 1);
        boolean finalMatch = fragments.get(fragments.size() - 1).getEndOffset() == name2.length();
        return (wordStart ? 1000 : 0) + matchingCase - fragments.size() + -skippedHumps * 10 + (bl ? 0 : 2) + (startMatch ? 1 : 0) + (finalMatch ? 1 : 0);
    }

    private int evaluateCaseMatching(boolean valuedStartMatch, int patternIndex, boolean humpStartMatchedUpperCase, int nameIndex, boolean afterGap, boolean isHumpStart, char nameChar) {
        if (afterGap && isHumpStart && this.isLowerCase[patternIndex]) {
            return -10;
        }
        if (nameChar == this.myPattern[patternIndex]) {
            if (this.isUpperCase[patternIndex]) {
                return 50;
            }
            if (nameIndex == 0 && valuedStartMatch) {
                return 150;
            }
            if (isHumpStart) {
                return 1;
            }
        } else {
            if (isHumpStart) {
                return -1;
            }
            if (this.isLowerCase[patternIndex] && humpStartMatchedUpperCase) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public String getPattern() {
        return new String(this.myPattern);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name2) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(8);
        }
        if (name2.length() < this.myMinNameLength) {
            return null;
        }
        if (this.myPattern.length > 100) {
            return this.matchBySubstring(name2);
        }
        int length = name2.length();
        int patternIndex = 0;
        for (int i2 = 0; i2 < length && patternIndex < this.myMeaningfulCharacters.length; ++i2) {
            char c = name2.charAt(i2);
            if (c != this.myMeaningfulCharacters[patternIndex] && c != this.myMeaningfulCharacters[patternIndex + 1]) continue;
            patternIndex += 2;
        }
        if (patternIndex < this.myMinNameLength * 2) {
            return null;
        }
        boolean isAscii = AsciiUtils.isAscii(name2);
        return this.matchWildcards(name2, 0, 0, isAscii);
    }

    @Nullable
    private FList<TextRange> matchBySubstring(@NotNull String name2) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(9);
        }
        boolean infix = this.isPatternChar(0, '*');
        char[] patternWithoutWildChar = MinusculeMatcherImpl.filterWildcard(this.myPattern);
        if (name2.length() < patternWithoutWildChar.length) {
            return null;
        }
        if (infix) {
            int index = Strings.indexOfIgnoreCase((CharSequence)name2, new CharArrayCharSequence(patternWithoutWildChar, 0, patternWithoutWildChar.length), 0);
            if (index >= 0) {
                return FList.singleton(TextRange.from(index, patternWithoutWildChar.length - 1));
            }
            return null;
        }
        if (CharArrayUtil.regionMatches(patternWithoutWildChar, 0, patternWithoutWildChar.length, name2)) {
            return FList.singleton(new TextRange(0, patternWithoutWildChar.length));
        }
        return null;
    }

    private static char[] filterWildcard(char[] source) {
        char[] buffer = new char[source.length];
        int i2 = 0;
        for (char c : source) {
            if (c == '*') continue;
            buffer[i2++] = c;
        }
        return Arrays.copyOf(buffer, i2);
    }

    @Nullable
    private FList<TextRange> matchWildcards(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(10);
        }
        if (nameIndex < 0) {
            return null;
        }
        if (!this.isWildcard(patternIndex)) {
            if (patternIndex == this.myPattern.length) {
                return FList.emptyList();
            }
            return this.matchFragment(name2, patternIndex, nameIndex, isAsciiName);
        }
        while (this.isWildcard(++patternIndex)) {
        }
        if (patternIndex == this.myPattern.length) {
            if (this.isTrailingSpacePattern() && nameIndex != name2.length() && (patternIndex < 2 || !MinusculeMatcherImpl.isUpperCaseOrDigit(this.myPattern[patternIndex - 2]))) {
                int spaceIndex = name2.indexOf(32, nameIndex);
                if (spaceIndex >= 0) {
                    return FList.singleton(TextRange.from(spaceIndex, 1));
                }
                return null;
            }
            return FList.emptyList();
        }
        return this.matchSkippingWords(name2, patternIndex, this.findNextPatternCharOccurrence(name2, nameIndex, patternIndex, isAsciiName), true, isAsciiName);
    }

    private boolean isTrailingSpacePattern() {
        return this.isPatternChar(this.myPattern.length - 1, ' ');
    }

    private static boolean isUpperCaseOrDigit(char p) {
        return Character.isUpperCase(p) || Character.isDigit(p);
    }

    @Nullable
    private FList<TextRange> matchSkippingWords(@NotNull String name2, int patternIndex, int nameIndex, boolean allowSpecialChars, boolean isAsciiName) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(11);
        }
        int maxFoundLength = 0;
        while (nameIndex >= 0) {
            int fragmentLength;
            int n = fragmentLength = this.seemsLikeFragmentStart(name2, patternIndex, nameIndex) ? this.maxMatchingFragment(name2, patternIndex, nameIndex) : 0;
            if (fragmentLength > maxFoundLength || nameIndex + fragmentLength == name2.length() && this.isTrailingSpacePattern()) {
                FList<TextRange> ranges;
                if (!this.isMiddleMatch(name2, patternIndex, nameIndex)) {
                    maxFoundLength = fragmentLength;
                }
                if ((ranges = this.matchInsideFragment(name2, patternIndex, nameIndex, isAsciiName, fragmentLength)) != null) {
                    return ranges;
                }
            }
            int next2 = this.findNextPatternCharOccurrence(name2, nameIndex + 1, patternIndex, isAsciiName);
            nameIndex = allowSpecialChars ? next2 : this.checkForSpecialChars(name2, nameIndex + 1, next2, patternIndex);
        }
        return null;
    }

    private int findNextPatternCharOccurrence(@NotNull String name2, int startAt, int patternIndex, boolean isAsciiName) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(12);
        }
        return !this.isPatternChar(patternIndex - 1, '*') && !this.isWordSeparator[patternIndex] ? this.indexOfWordStart(name2, patternIndex, startAt, isAsciiName) : this.indexOfIgnoreCase(name2, startAt, this.myPattern[patternIndex], patternIndex, isAsciiName);
    }

    private int checkForSpecialChars(String name2, int start2, int end, int patternIndex) {
        if (end < 0) {
            return -1;
        }
        if (!this.myHasSeparators && !this.myHasHumps && Strings.containsAnyChar(name2, this.myHardSeparators, start2, end)) {
            return -1;
        }
        if (this.myHasDots && !this.isPatternChar(patternIndex - 1, '.') && Strings.contains(name2, start2, end, '.')) {
            return -1;
        }
        return end;
    }

    private boolean seemsLikeFragmentStart(@NotNull String name2, int patternIndex, int nextOccurrence) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(13);
        }
        return !this.isUpperCase[patternIndex] || Character.isUpperCase(name2.charAt(nextOccurrence)) || NameUtilCore.isWordStart(name2, nextOccurrence) || !this.myHasHumps && this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
    }

    private boolean charEquals(char patternChar, int patternIndex, char c, boolean isIgnoreCase) {
        return patternChar == c || isIgnoreCase && (this.toLowerCase[patternIndex] == c || this.toUpperCase[patternIndex] == c);
    }

    @Nullable
    private FList<TextRange> matchFragment(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName) {
        int fragmentLength;
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(14);
        }
        return (fragmentLength = this.maxMatchingFragment(name2, patternIndex, nameIndex)) == 0 ? null : this.matchInsideFragment(name2, patternIndex, nameIndex, isAsciiName, fragmentLength);
    }

    private int maxMatchingFragment(@NotNull String name2, int patternIndex, int nameIndex) {
        boolean ignoreCase;
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(15);
        }
        if (!this.isFirstCharMatching(name2, nameIndex, patternIndex)) {
            return 0;
        }
        int i2 = 1;
        boolean bl = ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        while (nameIndex + i2 < name2.length() && patternIndex + i2 < this.myPattern.length) {
            char nameChar = name2.charAt(nameIndex + i2);
            if (!this.charEquals(this.myPattern[patternIndex + i2], patternIndex + i2, nameChar, ignoreCase)) {
                if (!this.isSkippingDigitBetweenPatternDigits(patternIndex + i2, nameChar)) break;
                return 0;
            }
            ++i2;
        }
        return i2;
    }

    private boolean isSkippingDigitBetweenPatternDigits(int patternIndex, char nameChar) {
        return Character.isDigit(this.myPattern[patternIndex]) && Character.isDigit(this.myPattern[patternIndex - 1]) && Character.isDigit(nameChar);
    }

    @Nullable
    private FList<TextRange> matchInsideFragment(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName, int fragmentLength) {
        int minFragment;
        FList<TextRange> camelHumpRanges;
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(16);
        }
        if ((camelHumpRanges = this.improveCamelHumps(name2, patternIndex, nameIndex, isAsciiName, fragmentLength, minFragment = this.isMiddleMatch(name2, patternIndex, nameIndex) ? 3 : 1)) != null) {
            return camelHumpRanges;
        }
        return this.findLongestMatchingPrefix(name2, patternIndex, nameIndex, isAsciiName, fragmentLength, minFragment);
    }

    private boolean isMiddleMatch(@NotNull String name2, int patternIndex, int nameIndex) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(17);
        }
        return this.isPatternChar(patternIndex - 1, '*') && !this.isWildcard(patternIndex + 1) && Character.isLetterOrDigit(name2.charAt(nameIndex)) && !NameUtilCore.isWordStart(name2, nameIndex);
    }

    @Nullable
    private FList<TextRange> findLongestMatchingPrefix(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName, int fragmentLength, int minFragment) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(18);
        }
        if (patternIndex + fragmentLength >= this.myPattern.length) {
            return FList.singleton(TextRange.from(nameIndex, fragmentLength));
        }
        for (int i2 = fragmentLength; i2 >= minFragment || i2 > 0 && this.isWildcard(patternIndex + i2); --i2) {
            FList<TextRange> ranges;
            if (this.isWildcard(patternIndex + i2)) {
                ranges = this.matchWildcards(name2, patternIndex + i2, nameIndex + i2, isAsciiName);
            } else {
                int nextOccurrence = this.findNextPatternCharOccurrence(name2, nameIndex + i2 + 1, patternIndex + i2, isAsciiName);
                ranges = (nextOccurrence = this.checkForSpecialChars(name2, nameIndex + i2, nextOccurrence, patternIndex + i2)) >= 0 ? this.matchSkippingWords(name2, patternIndex + i2, nextOccurrence, false, isAsciiName) : null;
            }
            if (ranges == null) continue;
            return MinusculeMatcherImpl.prependRange(ranges, nameIndex, i2);
        }
        return null;
    }

    private FList<TextRange> improveCamelHumps(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName, int maxFragment, int minFragment) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(19);
        }
        for (int i2 = minFragment; i2 < maxFragment; ++i2) {
            FList<TextRange> ranges;
            if (!this.isUppercasePatternVsLowercaseNameChar(name2, patternIndex + i2, nameIndex + i2) || (ranges = this.findUppercaseMatchFurther(name2, patternIndex + i2, nameIndex + i2, isAsciiName)) == null) continue;
            return MinusculeMatcherImpl.prependRange(ranges, nameIndex, i2);
        }
        return null;
    }

    private boolean isUppercasePatternVsLowercaseNameChar(String name2, int patternIndex, int nameIndex) {
        return this.isUpperCase[patternIndex] && this.myPattern[patternIndex] != name2.charAt(nameIndex);
    }

    private FList<TextRange> findUppercaseMatchFurther(String name2, int patternIndex, int nameIndex, boolean isAsciiName) {
        int nextWordStart = this.indexOfWordStart(name2, patternIndex, nameIndex, isAsciiName);
        return this.matchWildcards(name2, patternIndex, nextWordStart, isAsciiName);
    }

    private boolean isFirstCharMatching(@NotNull String name2, int nameIndex, int patternIndex) {
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(20);
        }
        if (nameIndex >= name2.length()) {
            return false;
        }
        boolean ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        char patternChar = this.myPattern[patternIndex];
        if (!this.charEquals(patternChar, patternIndex, name2.charAt(nameIndex), ignoreCase)) {
            return false;
        }
        return this.myOptions != NameUtil.MatchingCaseSensitivity.FIRST_LETTER || patternIndex != 0 && (patternIndex != 1 || !this.isWildcard(0)) || !MinusculeMatcherImpl.hasCase(patternChar) || Character.isUpperCase(patternChar) == Character.isUpperCase(name2.charAt(0));
    }

    private static boolean hasCase(char patternChar) {
        return Character.isUpperCase(patternChar) || Character.isLowerCase(patternChar);
    }

    private boolean isWildcard(int patternIndex) {
        if (patternIndex >= 0 && patternIndex < this.myPattern.length) {
            char pc = this.myPattern[patternIndex];
            return pc == ' ' || pc == '*';
        }
        return false;
    }

    private boolean isPatternChar(int patternIndex, char c) {
        return patternIndex >= 0 && patternIndex < this.myPattern.length && this.myPattern[patternIndex] == c;
    }

    private int indexOfWordStart(@NotNull String name2, int patternIndex, int startFrom, boolean isAsciiName) {
        boolean isSpecialSymbol;
        if (name2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(21);
        }
        char p = this.myPattern[patternIndex];
        if (startFrom >= name2.length() || this.myHasHumps && this.isLowerCase[patternIndex] && (patternIndex <= 0 || !this.isWordSeparator[patternIndex - 1])) {
            return -1;
        }
        int i2 = startFrom;
        boolean bl = isSpecialSymbol = !Character.isLetterOrDigit(p);
        while ((i2 = this.indexOfIgnoreCase(name2, i2, p, patternIndex, isAsciiName)) >= 0) {
            if (isSpecialSymbol || NameUtilCore.isWordStart(name2, i2)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private int indexOfIgnoreCase(String name2, int fromIndex, char p, int patternIndex, boolean isAsciiName) {
        if (isAsciiName && Strings.isAscii(p)) {
            char pUpper = this.toUpperCase[patternIndex];
            char pLower = this.toLowerCase[patternIndex];
            for (int i2 = fromIndex; i2 < name2.length(); ++i2) {
                char c = name2.charAt(i2);
                if (c != pUpper && c != pLower) continue;
                return i2;
            }
            return -1;
        }
        return Strings.indexOfIgnoreCase(name2, p, fromIndex);
    }

    @NonNls
    public String toString() {
        return "MinusculeMatcherImpl{myPattern=" + new String(this.myPattern) + ", myOptions=" + String.valueOf((Object)this.myOptions) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardSeparators";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/MinusculeMatcherImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/MinusculeMatcherImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prependRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prependRange";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchingDegree";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchingFragments";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchBySubstring";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchWildcards";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchSkippingWords";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNextPatternCharOccurrence";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "seemsLikeFragmentStart";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchFragment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "maxMatchingFragment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "matchInsideFragment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isMiddleMatch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findLongestMatchingPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "improveCamelHumps";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isFirstCharMatching";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "indexOfWordStart";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

