/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.psi.codeStyle.MatcherWithFallback;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcherImpl;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.matching.KeyboardLayoutUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixingLayoutMatcher
extends MatcherWithFallback {
    public FixingLayoutMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        if (pattern == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(0);
        }
        if (options == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(1);
        }
        super(new MinusculeMatcherImpl(pattern, options, hardSeparators), FixingLayoutMatcher.withFixedLayout(pattern, options, hardSeparators));
    }

    @Nullable
    public static String fixLayout(String pattern) {
        boolean hasLetters = false;
        boolean onlyWrongLetters = true;
        for (int i2 = 0; i2 < pattern.length(); ++i2) {
            char c = pattern.charAt(i2);
            if (!Character.isLetter(c)) continue;
            hasLetters = true;
            if (c > '\u007f') continue;
            onlyWrongLetters = false;
            break;
        }
        if (hasLetters && onlyWrongLetters) {
            char[] alternatePattern = new char[pattern.length()];
            for (int i3 = 0; i3 < pattern.length(); ++i3) {
                char c = pattern.charAt(i3);
                Character newC = KeyboardLayoutUtil.getAsciiForChar(c);
                alternatePattern[i3] = newC == null ? c : newC.charValue();
            }
            return new String(alternatePattern);
        }
        return null;
    }

    @Nullable
    private static MinusculeMatcher withFixedLayout(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        String s;
        if (pattern == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(2);
        }
        if (options == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(3);
        }
        if ((s = FixingLayoutMatcher.fixLayout(pattern)) != null && !s.equals(pattern)) {
            return new MinusculeMatcherImpl(s, options, hardSeparators);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/FixingLayoutMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withFixedLayout";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

