/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NullAppendable;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileUtilRt {
    @Deprecated
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, Math.max(FileUtilRt.getUserFileSizeLimit(), FileUtilRt.getUserContentLoadLimit()));
    @Deprecated
    public static final int LARGE_FILE_PREVIEW_SIZE = Math.min(FileUtilRt.getLargeFilePreviewSize(), LARGE_FOR_CONTENT_LOADING);
    private static final boolean TRY_GC_IF_FILE_DELETE_FAILS = "true".equals(System.getProperty("idea.fs.try-gc-if-file-delete-fails", "true"));
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    private static final Random RANDOM = new Random();

    @Contract(value="null, _, _ -> null; !null,_,_->!null")
    public static String toCanonicalPath(@Nullable String path2, char separatorChar, boolean removeLastSlash) {
        return FileUtilRt.toCanonicalPath(path2, separatorChar, removeLastSlash, null);
    }

    @Contract(value="null, _, _, _ -> null; !null,_,_,_->!null")
    @ApiStatus.Internal
    public static String toCanonicalPath(@Nullable String path2, char separatorChar, boolean removeLastSlash, @Nullable SymlinkResolver resolver) {
        char next2;
        if (path2 == null || path2.isEmpty()) {
            return path2;
        }
        if (path2.charAt(0) == '.') {
            if (path2.length() == 1) {
                return "";
            }
            char c = path2.charAt(1);
            if (c == '/' || c == separatorChar) {
                path2 = path2.substring(2);
            }
        }
        if (separatorChar != '/') {
            path2 = path2.replace(separatorChar, '/');
        }
        int index = -1;
        do {
            char c = next2 = (index = path2.indexOf(47, index + 1)) == path2.length() - 1 ? (char)'\u0000' : path2.charAt(index + 1);
        } while (next2 != '.' && next2 != '/' && index != -1);
        if (index == -1) {
            if (removeLastSlash) {
                int start2 = FileUtilRt.processRoot(path2, NullAppendable.INSTANCE);
                int slashIndex = path2.lastIndexOf(47);
                return slashIndex != -1 && slashIndex > start2 && slashIndex == path2.length() - 1 ? path2.substring(0, path2.length() - 1) : path2;
            }
            return path2;
        }
        StringBuilder result2 = new StringBuilder(path2.length());
        int start3 = FileUtilRt.processRoot(path2, result2);
        int dots = 0;
        boolean separator = true;
        for (int i2 = start3; i2 < path2.length(); ++i2) {
            char c = path2.charAt(i2);
            if (c == '/') {
                if (!separator) {
                    if (!FileUtilRt.processDots(result2, dots, start3, resolver)) {
                        return resolver.resolveSymlinksAndCanonicalize(path2, separatorChar, removeLastSlash);
                    }
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result2.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result2.append('.');
                --dots;
            }
            result2.append(c);
            separator = false;
        }
        if (dots > 0 && !FileUtilRt.processDots(result2, dots, start3, resolver)) {
            return resolver.resolveSymlinksAndCanonicalize(path2, separatorChar, removeLastSlash);
        }
        int lastChar = result2.length() - 1;
        if (removeLastSlash && lastChar >= 0 && result2.charAt(lastChar) == '/' && lastChar > start3) {
            result2.deleteCharAt(lastChar);
        }
        return result2.toString();
    }

    private static int processRoot(@NotNull String path2, @NotNull Appendable result2) {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            FileUtilRt.$$$reportNull$$$0(6);
        }
        try {
            if (SystemInfoRt.isWindows && path2.length() > 1 && path2.charAt(0) == '/' && path2.charAt(1) == '/') {
                int shareStart;
                int hostStart;
                result2.append("//");
                for (hostStart = 2; hostStart < path2.length() && path2.charAt(hostStart) == '/'; ++hostStart) {
                }
                if (hostStart == path2.length()) {
                    return hostStart;
                }
                int hostEnd = path2.indexOf(47, hostStart);
                if (hostEnd < 0) {
                    hostEnd = path2.length();
                }
                result2.append(path2, hostStart, hostEnd);
                result2.append('/');
                for (shareStart = hostEnd; shareStart < path2.length() && path2.charAt(shareStart) == '/'; ++shareStart) {
                }
                if (shareStart == path2.length()) {
                    return shareStart;
                }
                int shareEnd = path2.indexOf(47, shareStart);
                if (shareEnd < 0) {
                    shareEnd = path2.length();
                }
                result2.append(path2, shareStart, shareEnd);
                result2.append('/');
                return shareEnd;
            }
            if (!path2.isEmpty() && path2.charAt(0) == '/') {
                result2.append('/');
                return 1;
            }
            if (path2.length() > 2 && path2.charAt(1) == ':' && path2.charAt(2) == '/') {
                result2.append(path2, 0, 3);
                return 3;
            }
            return 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Contract(value="_, _, _, null -> true")
    private static boolean processDots(@NotNull StringBuilder result2, int dots, int start2, @Nullable SymlinkResolver symlinkResolver) {
        if (result2 == null) {
            FileUtilRt.$$$reportNull$$$0(7);
        }
        if (dots == 2) {
            int pos = -1;
            if (!StringUtilRt.endsWith(result2, "/../") && !"../".contentEquals(result2)) {
                pos = StringUtilRt.lastIndexOf(result2, '/', start2, result2.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start2 > 0) {
                    pos = start2;
                } else if (result2.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                if (symlinkResolver != null && symlinkResolver.isSymlink(result2)) {
                    return false;
                }
                result2.delete(pos, result2.length());
            } else {
                result2.append("../");
            }
        } else if (dots != 1) {
            for (int i2 = 0; i2 < dots; ++i2) {
                result2.append('.');
            }
            result2.append('/');
        }
        return true;
    }

    public static int getUserFileSizeLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.intellisense.filesize", 2560000);
    }

    public static int getUserContentLoadLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.filesize", 0x1400000);
    }

    private static int getLargeFilePreviewSize() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.large.preview.size", 2560000);
    }

    private static int parseKilobyteProperty(String key2, int defaultValue) {
        try {
            long i2 = Integer.parseInt(System.getProperty(key2, String.valueOf(defaultValue / 1024)));
            if (i2 < 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)Math.min(i2 * 1024L, Integer.MAX_VALUE);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int pathHashCode(@Nullable String path2) {
        if (path2 == null || path2.isEmpty()) {
            return 0;
        }
        path2 = FileUtilRt.toCanonicalPath(path2, File.separatorChar, true);
        return SystemInfoRt.isFileSystemCaseSensitive ? path2.hashCode() : StringUtilRt.stringHashCodeInsensitive(path2);
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtilRt.toCanonicalPath(path1, File.separatorChar, true);
        path2 = FileUtilRt.toCanonicalPath(path2, File.separatorChar, true);
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return path1.equals(path2);
        }
        return path1.equalsIgnoreCase(path2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 19: 
            case 20: 
            case 22: 
            case 80: 
            case 81: 
            case 92: 
            case 93: 
            case 94: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileUtilRt";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 16: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedName";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 36: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 54: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temp";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempPath";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 75: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioTask";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileUtilRt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemIndependentName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureEnds";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "calcName";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeFile";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCanonicalTempPath";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 71: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 82: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLines";
                break;
            }
            case 86: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isJarOrZip";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFilePathAcceptable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDots";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extensionEquals";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fileNameEquals";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "toSystemIndependentName";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureEnds";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "doCreateTempFile";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "calcName";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "normalizeFile";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "resetCanonicalTempPathCache";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "generateRandomTemporaryPath";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "loadLines";
                break;
            }
            case 85: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "directoryNotEmptyExceptionWithMoreDiagnostic";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "doIOOperation";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanCreateFile";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "createIfNotExists";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirs";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "fileToUri";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static interface SymlinkResolver {
        @NotNull
        public String resolveSymlinksAndCanonicalize(@NotNull String var1, char var2, boolean var3);

        public boolean isSymlink(@NotNull CharSequence var1);
    }
}

