/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Segment;
import java.io.Serializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TextRange
implements Segment,
Serializable {
    public static final TextRange EMPTY_RANGE = new TextRange(0, 0);
    public static final TextRange[] EMPTY_ARRAY = new TextRange[0];
    private final int myStartOffset;
    private final int myEndOffset;

    @Contract(pure=true)
    public TextRange(int startOffset, int endOffset) {
        this(startOffset, endOffset, true);
    }

    protected TextRange(int startOffset, int endOffset, boolean checkForProperTextRange) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        if (checkForProperTextRange) {
            TextRange.assertProperRange(this);
        }
    }

    @Override
    public final int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.myEndOffset;
    }

    public final int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange range = (TextRange)obj;
        return this.myStartOffset == range.myStartOffset && this.myEndOffset == range.myEndOffset;
    }

    public int hashCode() {
        return this.myStartOffset + this.myEndOffset;
    }

    public String toString() {
        return "(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }

    @Contract(pure=true)
    @NotNull
    public TextRange shiftRight(int delta) {
        if (delta == 0) {
            TextRange textRange = this;
            if (textRange == null) {
                TextRange.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        return new TextRange(this.myStartOffset + delta, this.myEndOffset + delta);
    }

    @Contract(pure=true)
    @NotNull
    public static TextRange from(int offset, int length) {
        return TextRange.create(offset, offset + length);
    }

    @Contract(pure=true)
    @NotNull
    public static TextRange create(int startOffset, int endOffset) {
        return new TextRange(startOffset, endOffset);
    }

    @Contract(pure=true)
    @NotNull
    public String replace(@NotNull String original, @NotNull String replacement) {
        if (original == null) {
            TextRange.$$$reportNull$$$0(15);
        }
        if (replacement == null) {
            TextRange.$$$reportNull$$$0(16);
        }
        String beginning = original.substring(0, this.getStartOffset());
        String ending = original.substring(this.getEndOffset());
        String string = beginning + replacement + ending;
        if (string == null) {
            TextRange.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static void assertProperRange(@NotNull Segment range) throws AssertionError {
        if (range == null) {
            TextRange.$$$reportNull$$$0(25);
        }
        TextRange.assertProperRange(range, "");
    }

    public static void assertProperRange(@NotNull Segment range, @NotNull Object message2) throws AssertionError {
        if (range == null) {
            TextRange.$$$reportNull$$$0(26);
        }
        if (message2 == null) {
            TextRange.$$$reportNull$$$0(27);
        }
        TextRange.assertProperRange(range.getStartOffset(), range.getEndOffset(), message2);
    }

    public static void assertProperRange(int startOffset, int endOffset, @NotNull Object message2) {
        if (message2 == null) {
            TextRange.$$$reportNull$$$0(28);
        }
        if (!TextRange.isProperRange(startOffset, endOffset)) {
            throw new IllegalArgumentException("Invalid range specified: (" + startOffset + ", " + endOffset + "); " + message2);
        }
    }

    public static boolean isProperRange(int startOffset, int endOffset) {
        return startOffset <= endOffset && startOffset >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inner";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/TextRange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subRange";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/TextRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "substring";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftRight";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftLeft";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "grown";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substring";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "subSequence";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cutOut";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "areSegmentsEqual";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "intersectsStrict";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "allOf";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "assertProperRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

