/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.util.ArrayUtilRt;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Logger {
    private static Factory ourFactory = new DefaultFactory();
    static final Function<Attachment, String> ATTACHMENT_TO_STRING = attachment -> attachment.getPath() + "\n" + attachment.getDisplayText();
    private static final boolean ourRethrowCE = "true".equals(System.getProperty("idea.log.rethrow.ce", "true"));

    @NotNull
    public static Logger getInstance(@NotNull String category) {
        if (category == null) {
            Logger.$$$reportNull$$$0(2);
        }
        Logger logger = ourFactory.getLoggerInstance(category);
        if (logger == null) {
            Logger.$$$reportNull$$$0(3);
        }
        return logger;
    }

    @NotNull
    public static Logger getInstance(@NotNull Class<?> cl) {
        if (cl == null) {
            Logger.$$$reportNull$$$0(4);
        }
        Logger logger = ourFactory.getLoggerInstance("#" + cl.getName());
        if (logger == null) {
            Logger.$$$reportNull$$$0(5);
        }
        return logger;
    }

    public void error(String message2, @Nullable Throwable t2) {
        this.error(message2, t2, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void error(@NotNull Throwable t2) {
        if (t2 == null) {
            Logger.$$$reportNull$$$0(21);
        }
        this.error(t2.getMessage(), t2, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public abstract void error(String var1, @Nullable Throwable var2, String ... var3);

    public static boolean shouldRethrow(@NotNull Throwable t2) {
        if (t2 == null) {
            Logger.$$$reportNull$$$0(24);
        }
        return t2 instanceof ControlFlowException || t2 instanceof CancellationException && ourRethrowCE;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    protected static Throwable ensureNotControlFlow(@Nullable Throwable t2) {
        return t2 != null && Logger.shouldRethrow(t2) ? new Throwable("Control-flow exceptions (e.g. this " + t2.getClass() + ") should never be logged. Instead, these should have been rethrown if caught.", t2) : t2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/Logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/Logger";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFactory";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "debugValues";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "infoWithDebug";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "warnWithDebug";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "shouldRethrow";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "warnInProduction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Factory {
        @NotNull
        public Logger getLoggerInstance(@NotNull String var1);
    }

    private static final class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        @NotNull
        public Logger getLoggerInstance(@NotNull String category) {
            if (category == null) {
                DefaultFactory.$$$reportNull$$$0(0);
            }
            return new DefaultLogger(category);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/diagnostic/Logger$DefaultFactory", "getLoggerInstance"));
        }
    }
}

