/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLogger
extends Logger {
    private static boolean mirrorToStderr = true;
    private final String category;
    private LogLevel level = LogLevel.WARNING;

    public DefaultLogger(String category) {
        this.category = category;
    }

    @Override
    public void error(String message2, @Nullable Throwable t2, String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(0);
        }
        t2 = DefaultLogger.ensureNotControlFlow(t2);
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message2 + DefaultLogger.detailsToString(details) + DefaultLogger.attachmentsToString(t2));
            if (t2 != null) {
                t2.printStackTrace(System.err);
            }
        }
        throw new AssertionError(message2, t2);
    }

    @NotNull
    public static String detailsToString(String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(2);
        }
        return details.length > 0 ? "\nDetails:\n" + String.join((CharSequence)"\n", details) : "";
    }

    @NotNull
    public static String attachmentsToString(@Nullable Throwable t2) {
        if (t2 != null) {
            String prefix = "\n\nAttachments:\n";
            String attachments = ExceptionUtil.causeAndSuppressed(t2, ExceptionWithAttachments.class).flatMap(e -> Stream.of(e.getAttachments())).map(ATTACHMENT_TO_STRING).collect(Collectors.joining("\n----\n", prefix, ""));
            if (!attachments.equals(prefix)) {
                String string = attachments;
                if (string == null) {
                    DefaultLogger.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        return "";
    }

    public static boolean shouldDumpExceptionToStderr() {
        return mirrorToStderr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "attachmentsToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detailsToString";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "disableStderrDumping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

