/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.rules.beans.DataValidationRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRevision;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRulesFactory;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import com.jetbrains.fus.reporting.model.metadata.RangeRevision;
import com.jetbrains.fus.reporting.model.metadata.RecorderValidationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRecorderDataValidationRulesFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecorderDataValidationRulesFactory.kt\ncom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidationRulesFactory\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n125#2:151\n152#2,3:152\n1549#3:155\n1620#3,3:156\n*S KotlinDebug\n*F\n+ 1 RecorderDataValidationRulesFactory.kt\ncom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidationRulesFactory\n*L\n35#1:151\n35#1:152,3\n40#1:155\n40#1:156,3\n*E\n"})
public final class RecorderDataValidationRulesFactory {
    @NotNull
    public static final RecorderDataValidationRulesFactory INSTANCE = new RecorderDataValidationRulesFactory();

    private RecorderDataValidationRulesFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RecorderDataValidationRule create(@NotNull ValidationSimpleRuleFactory validationSimpleRuleFactory, @Nullable List<RecorderValidationData> recorderValidationData, @Nullable EventGroupRemoteDescriptors.GroupRemoteRule globalRules) {
        void $this$mapTo$iv$iv;
        Object key2;
        void $this$mapTo$iv$iv2;
        Map revision22;
        Intrinsics.checkNotNullParameter((Object)validationSimpleRuleFactory, (String)"validationSimpleRuleFactory");
        if (recorderValidationData == null) {
            return new RecorderDataValidationRule(null);
        }
        Map dataRevisions = new LinkedHashMap();
        for (RecorderValidationData recorderValidationData2 : recorderValidationData) {
            for (Map revision22 : recorderValidationData2.getRevisions()) {
                ValidationRule existed = (ValidationRule)dataRevisions.get(revision22);
                if (existed == null) {
                    Set set2;
                    if (revision22.getRequired()) {
                        Object[] objectArray = new String[]{recorderValidationData2.getPath()};
                        set2 = SetsKt.hashSetOf((Object[])objectArray);
                    } else {
                        set2 = new LinkedHashSet();
                    }
                    Set requiredKeys = set2;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)recorderValidationData2.getPath(), (Object)CollectionsKt.toSet((Iterable)revision22.getValues()))};
                    HashMap rules = MapsKt.hashMapOf((Pair[])pairArray);
                    dataRevisions.put(revision22, new ValidationRule(rules, requiredKeys));
                    continue;
                }
                if (revision22.getRequired()) {
                    existed.getRequiredKeys().add(recorderValidationData2.getPath());
                }
                existed.getRules().put(recorderValidationData2.getPath(), CollectionsKt.toHashSet((Iterable)revision22.getValues()));
                dataRevisions.put(revision22, existed);
            }
        }
        Map map2 = dataRevisions;
        Object object = this;
        boolean $i$f$map = false;
        revision22 = map2;
        Collection destination$iv$iv = new ArrayList(map2.size());
        boolean $i$f$mapTo232 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            Map.Entry entry = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            key2 = (RangeRevision)entry.getKey();
            ValidationRule value2 = (ValidationRule)entry.getValue();
            collection.add(new Revision(key2.getFrom(), key2.getTo(), value2.getRules(), value2.getRequiredKeys()));
        }
        List<Revision> splitRevisions = ((RecorderDataValidationRulesFactory)object).splitIntervals((List)destination$iv$iv);
        GlobalRulesHolder globalRulesHolder = new GlobalRulesHolder(globalRules);
        Iterable $this$map$iv2 = splitRevisions;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo232 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            key2 = (Revision)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            int n = it.getFrom();
            Integer n2 = it.getTo();
            DataValidationRules dataValidationRules = DataValidationRules.create(it.getRules(), globalRulesHolder, validationSimpleRuleFactory, CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)dataValidationRules, (String)"create(\n                \u2026yList()\n                )");
            object.add(new RecorderDataValidationRevision(n, n2, dataValidationRules, it.getRequiredKeys()));
        }
        List revisions = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        return new RecorderDataValidationRule(revisions);
    }

    @NotNull
    public final List<Revision> splitIntervals(@NotNull List<Revision> revisions) {
        Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
        if (revisions.isEmpty()) {
            return revisions;
        }
        List points = new ArrayList();
        for (Revision interval : revisions) {
            points.add(new Point(interval.getFrom(), true, interval.getRules(), interval.getRequiredKeys()));
            points.add(new Point(interval.getTo(), false, interval.getRules(), interval.getRequiredKeys()));
        }
        Function1[] function1Array = new Function1[]{splitIntervals.1.INSTANCE, splitIntervals.2.INSTANCE};
        CollectionsKt.sortWith((List)points, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        List result2 = new ArrayList();
        int count = 0;
        Point start2 = (Point)CollectionsKt.first((List)points);
        Map currentRules = start2.getRules();
        Set currentRequiredKeys = start2.getRequiredKeys();
        for (Point point : points) {
            if (count == 0) {
                start2 = point;
                currentRules = start2.getRules();
                currentRequiredKeys = start2.getRequiredKeys();
                ++count;
                continue;
            }
            if (point.isStart()) {
                this.addIfNotEqual(result2, point, start2, currentRules, currentRequiredKeys);
                start2 = point;
                currentRules = MapsKt.plus(currentRules, point.getRules());
                currentRequiredKeys = SetsKt.plus(currentRequiredKeys, (Iterable)point.getRequiredKeys());
                ++count;
                continue;
            }
            this.addIfNotEqual(result2, point, start2, currentRules, currentRequiredKeys);
            start2 = point;
            currentRules = MapsKt.minus((Map)currentRules, (Iterable)point.getRules().keySet());
            currentRequiredKeys = SetsKt.minus((Set)currentRequiredKeys, (Iterable)point.getRequiredKeys());
            --count;
        }
        return result2;
    }

    private final void addIfNotEqual(List<Revision> result2, Point point, Point start2, Map<String, ? extends Set<String>> currentRules, Set<String> currentRequiredKeys) {
        if (!Intrinsics.areEqual((Object)start2.getValue(), (Object)point.getValue())) {
            Integer n = start2.getValue();
            Intrinsics.checkNotNull((Object)n);
            result2.add(new Revision(n, point.getValue(), currentRules, currentRequiredKeys));
        }
    }

    private static final class Point {
        @Nullable
        private final Integer value;
        private final boolean isStart;
        @NotNull
        private final Map<String, Set<String>> rules;
        @NotNull
        private final Set<String> requiredKeys;

        public Point(@Nullable Integer value2, boolean isStart, @NotNull Map<String, ? extends Set<String>> rules, @NotNull Set<String> requiredKeys) {
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Intrinsics.checkNotNullParameter(requiredKeys, (String)"requiredKeys");
            this.value = value2;
            this.isStart = isStart;
            this.rules = rules;
            this.requiredKeys = requiredKeys;
        }

        @Nullable
        public final Integer getValue() {
            return this.value;
        }

        public final boolean isStart() {
            return this.isStart;
        }

        @NotNull
        public final Map<String, Set<String>> getRules() {
            return this.rules;
        }

        @NotNull
        public final Set<String> getRequiredKeys() {
            return this.requiredKeys;
        }

        @NotNull
        public String toString() {
            return "Point(value=" + this.value + ", isStart=" + this.isStart + ", rules=" + this.rules + ", requiredKeys=" + this.requiredKeys + ')';
        }

        public int hashCode() {
            int result2 = this.value == null ? 0 : ((Object)this.value).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isStart);
            result2 = result2 * 31 + ((Object)this.rules).hashCode();
            result2 = result2 * 31 + ((Object)this.requiredKeys).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Point)) {
                return false;
            }
            Point point = (Point)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)point.value)) {
                return false;
            }
            if (this.isStart != point.isStart) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rules, point.rules)) {
                return false;
            }
            return Intrinsics.areEqual(this.requiredKeys, point.requiredKeys);
        }
    }

    public static final class Revision {
        private final int from;
        @Nullable
        private final Integer to;
        @NotNull
        private final Map<String, Set<String>> rules;
        @NotNull
        private final Set<String> requiredKeys;

        public Revision(int from, @Nullable Integer to, @NotNull Map<String, ? extends Set<String>> rules, @NotNull Set<String> requiredKeys) {
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Intrinsics.checkNotNullParameter(requiredKeys, (String)"requiredKeys");
            this.from = from;
            this.to = to;
            this.rules = rules;
            this.requiredKeys = requiredKeys;
        }

        public final int getFrom() {
            return this.from;
        }

        @Nullable
        public final Integer getTo() {
            return this.to;
        }

        @NotNull
        public final Map<String, Set<String>> getRules() {
            return this.rules;
        }

        @NotNull
        public final Set<String> getRequiredKeys() {
            return this.requiredKeys;
        }

        @NotNull
        public String toString() {
            return "Revision(from=" + this.from + ", to=" + this.to + ", rules=" + this.rules + ", requiredKeys=" + this.requiredKeys + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.from);
            result2 = result2 * 31 + (this.to == null ? 0 : ((Object)this.to).hashCode());
            result2 = result2 * 31 + ((Object)this.rules).hashCode();
            result2 = result2 * 31 + ((Object)this.requiredKeys).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Revision)) {
                return false;
            }
            Revision revision = (Revision)other;
            if (this.from != revision.from) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.to, (Object)revision.to)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rules, revision.rules)) {
                return false;
            }
            return Intrinsics.areEqual(this.requiredKeys, revision.requiredKeys);
        }
    }

    private static final class ValidationRule {
        @NotNull
        private final Map<String, Set<String>> rules;
        @NotNull
        private final Set<String> requiredKeys;

        public ValidationRule(@NotNull Map<String, Set<String>> rules, @NotNull Set<String> requiredKeys) {
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Intrinsics.checkNotNullParameter(requiredKeys, (String)"requiredKeys");
            this.rules = rules;
            this.requiredKeys = requiredKeys;
        }

        public /* synthetic */ ValidationRule(Map map2, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = new LinkedHashMap();
            }
            if ((n & 2) != 0) {
                set2 = new LinkedHashSet();
            }
            this(map2, set2);
        }

        @NotNull
        public final Map<String, Set<String>> getRules() {
            return this.rules;
        }

        @NotNull
        public final Set<String> getRequiredKeys() {
            return this.requiredKeys;
        }

        public ValidationRule() {
            this(null, null, 3, null);
        }
    }
}

