/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import org.jetbrains.annotations.NotNull;

public class ExpressionValidationRule
extends PerformanceCareRule {
    @NotNull
    private final FUSRule myRule;
    @NotNull
    private final String myPrefix;
    @NotNull
    private final String mySuffix;

    public ExpressionValidationRule(@NotNull FUSRule rule, @NotNull String prefix, @NotNull String suffix) {
        this.myRule = rule;
        this.myPrefix = prefix;
        this.mySuffix = suffix;
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
        String legacyData;
        String escaped = StatisticsEventEscaper.escapeEventIdOrFieldValue(data2);
        ValidationResultType result2 = this.validateEscaped(escaped, context2);
        if (result2 != ValidationResultType.ACCEPTED && (legacyData = StatisticsEventEscaper.cleanupForLegacyRulesIfNeeded(escaped)) != null) {
            return this.validateEscaped(legacyData, context2);
        }
        return result2;
    }

    @NotNull
    private ValidationResultType validateEscaped(@NotNull String escapedData, @NotNull EventContext context2) {
        if (this.acceptPrefix(escapedData) && this.acceptSuffix(escapedData)) {
            return this.myRule.validate(escapedData.substring(this.myPrefix.length(), escapedData.length() - this.mySuffix.length()), context2);
        }
        return ValidationResultType.REJECTED;
    }

    private boolean acceptPrefix(@NotNull String data2) {
        return this.myPrefix.isEmpty() || data2.startsWith(this.myPrefix);
    }

    private boolean acceptSuffix(@NotNull String data2) {
        return this.mySuffix.isEmpty() || data2.endsWith(this.mySuffix);
    }

    public String toString() {
        return "UtilExpressionValidationRule: myPrefix=" + this.myPrefix + ",mySuffix=" + this.mySuffix + ",myRule=" + this.myRule;
    }
}

