/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.DataValidationRules;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventGroupRules
extends DataValidationRules {
    public static final EventGroupRules EMPTY = new EventGroupRules(Collections.emptySet(), Collections.emptyMap(), EventGroupContextData.EMPTY, new ValidationSimpleRuleFactory(ValidationSimpleRuleFactory.REJECTING_UTIL_URL_PRODUCER), Collections.emptyList());
    private static final Set<String> VALIDATION_TYPES = Arrays.stream(ValidationResultType.values()).map(ValidationResultType::getDescription).collect(Collectors.toSet());
    private final FUSRule[] eventIdRules;

    private EventGroupRules(@Nullable Set<String> eventIdRules, Map<String, ? extends Set<String>> eventDataRules, @NotNull EventGroupContextData contextData, @NotNull ValidationSimpleRuleFactory factory2, @NotNull List<String> excludedFields) {
        super(factory2, eventDataRules, contextData, excludedFields);
        this.eventIdRules = factory2.getRules(eventIdRules, contextData);
    }

    public boolean areEventIdRulesDefined() {
        return this.eventIdRules.length > 0;
    }

    public ValidationResultType validateEventId(@NotNull EventContext context2) {
        ValidationResultType prevResult = null;
        if (VALIDATION_TYPES.contains(context2.eventId)) {
            return ValidationResultType.ACCEPTED;
        }
        for (FUSRule rule : this.eventIdRules) {
            ValidationResultType resultType = rule.validate(context2.eventId, context2);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    @NotNull
    public static EventGroupRules create(@NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group, @NotNull GlobalRulesHolder globalRulesHolder, @NotNull ValidationSimpleRuleFactory factory2, @NotNull List<String> excludedFields) {
        EventGroupRemoteDescriptors.GroupRemoteRule rules = group.rules;
        return rules == null ? EMPTY : new EventGroupRules(rules.event_id, rules.event_data, new EventGroupContextData(rules.enums, rules.regexps, globalRulesHolder), factory2, excludedFields);
    }
}

