/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.EventLogSystemEvents;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.EventDataValidationError;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.beans.EventDataField;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataValidationRules {
    public static final DataValidationRules EMPTY = new DataValidationRules(new ValidationSimpleRuleFactory(ValidationSimpleRuleFactory.REJECTING_UTIL_URL_PRODUCER), Collections.emptyMap(), EventGroupContextData.EMPTY, Collections.emptyList());
    protected final Map<String, FUSRule[]> eventDataRules;
    protected final List<String> myExcludedFields;
    private static final FUSRule[] ALWAYS_TRUE_RULES = new FUSRule[]{FUSRule.TRUE};

    protected DataValidationRules(@NotNull ValidationSimpleRuleFactory factory2, Map<String, ? extends Set<String>> eventDataRules, @NotNull EventGroupContextData contextData, @NotNull List<String> excludedFields) {
        this.myExcludedFields = excludedFields;
        if (eventDataRules != null && !eventDataRules.isEmpty()) {
            HashMap<String, FUSRule[]> rules = new HashMap<String, FUSRule[]>();
            for (Map.Entry<String, ? extends Set<String>> entry : eventDataRules.entrySet()) {
                if (this.myExcludedFields.contains(entry.getKey())) {
                    rules.put(entry.getKey(), ALWAYS_TRUE_RULES);
                    continue;
                }
                rules.put(entry.getKey(), factory2.getRules(entry.getValue(), contextData));
            }
            this.eventDataRules = rules.size() == 1 ? DataValidationRules.toSingletonMap(rules) : Collections.unmodifiableMap(rules);
        } else {
            this.eventDataRules = Collections.emptyMap();
        }
    }

    @NotNull
    public static DataValidationRules create(@Nullable Map<String, Set<String>> eventDataRules, @NotNull GlobalRulesHolder globalRulesHolder, @NotNull ValidationSimpleRuleFactory factory2, @NotNull List<String> excludedFields) {
        return eventDataRules == null ? EMPTY : new DataValidationRules(factory2, eventDataRules, new EventGroupContextData(Collections.emptyMap(), Collections.emptyMap(), globalRulesHolder), excludedFields);
    }

    @NotNull
    private static Map<String, FUSRule[]> toSingletonMap(Map<String, FUSRule[]> rules) {
        Map.Entry<String, FUSRule[]> entry = rules.entrySet().iterator().next();
        return Collections.singletonMap(entry.getKey(), entry.getValue());
    }

    private static Object validateEventDataValue(@NotNull Object data2, EventContext context2, FUSRule @NotNull [] rules, @NotNull String jsonPath) {
        String value2 = data2.toString();
        ValidationResultType resultType = DataValidationRules.acceptRule(value2, context2, rules);
        if (resultType == ValidationResultType.ACCEPTED) {
            return data2;
        }
        context2.addError(new EventDataValidationError(resultType, jsonPath, value2));
        return resultType.getDescription();
    }

    private static ValidationResultType acceptRule(@NotNull String ruleData, EventContext context2, FUSRule ... rules) {
        if (rules == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        ValidationResultType prevResult = null;
        for (FUSRule rule : rules) {
            ValidationResultType resultType = rule.validate(ruleData, context2);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    public EventDataField validateEventData(@NotNull String key2, @Nullable Object data2, @NotNull EventContext context2) {
        return this.validateData(key2, data2, context2, "event.data");
    }

    public EventDataField validateData(@NotNull String key2, @Nullable Object data2, @NotNull EventContext context2, @NotNull String jsonPath) {
        return this.validateEventData(key2, data2, context2, key2, jsonPath + "." + key2);
    }

    private EventDataField validateEventData(@NotNull String key2, @Nullable Object data2, EventContext context2, @NotNull String fieldName, @NotNull String jsonPath) {
        if (data2 == null) {
            context2.addError(new EventDataValidationError(ValidationResultType.REJECTED, jsonPath, "Data is null"));
            return new EventDataField(fieldName, ValidationResultType.REJECTED.getDescription());
        }
        if (data2 instanceof String && (ValidationResultType.VALIDATION_TYPES.contains(data2) || EventLogSystemEvents.SYSTEM_EVENTS.contains(data2))) {
            return new EventDataField(fieldName, data2);
        }
        if (this.myExcludedFields.contains(key2)) {
            return new EventDataField(fieldName, data2);
        }
        if (data2 instanceof Map) {
            HashMap<String, Object> validatedData = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)data2).entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey instanceof String) {
                    EventDataField field = this.validateEventData(key2 + "." + entryKey, entry.getValue(), context2, (String)entryKey, jsonPath + "." + entryKey);
                    validatedData.put(field.getName(), field.getValue());
                    continue;
                }
                context2.addError(new EventDataValidationError(ValidationResultType.REJECTED, jsonPath + "." + entryKey.toString(), "Entry key should be String, actual=" + entryKey));
                validatedData.put((String)entryKey, ValidationResultType.REJECTED.getDescription());
            }
            String validatedFieldName = fieldName;
            if (!validatedData.isEmpty() && validatedData.keySet().stream().allMatch(value2 -> value2 instanceof String && ValidationResultType.UNDEFINED_RULE.getDescription().equals(value2))) {
                validatedFieldName = ValidationResultType.UNDEFINED_RULE.getDescription();
            }
            return new EventDataField(validatedFieldName, validatedData);
        }
        if (data2 instanceof List) {
            ArrayList<Object> validatedData = new ArrayList<Object>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            List objects = (List)data2;
            for (int i2 = 0; i2 < objects.size(); ++i2) {
                Object value3 = objects.get(i2);
                EventDataField validatedField = this.validateEventData(key2, value3, context2, fieldName, jsonPath + "[" + i2 + "]");
                validatedData.add(validatedField.getValue());
                fieldNames.add(validatedField.getName());
            }
            String validatedFieldName = fieldName;
            if (!validatedData.isEmpty() && fieldNames.stream().allMatch(value2 -> ValidationResultType.UNDEFINED_RULE.getDescription().equals(value2))) {
                validatedFieldName = ValidationResultType.UNDEFINED_RULE.getDescription();
            }
            return new EventDataField(validatedFieldName, validatedData);
        }
        FUSRule[] rules = this.eventDataRules.get(key2);
        if (rules == null || rules.length == 0) {
            context2.addError(new EventDataValidationError(ValidationResultType.UNDEFINED_RULE, jsonPath, "Undefined rule"));
            return new EventDataField(ValidationResultType.UNDEFINED_RULE.getDescription(), ValidationResultType.UNDEFINED_RULE.getDescription());
        }
        return new EventDataField(fieldName, DataValidationRules.validateEventDataValue(data2, context2, rules, jsonPath));
    }
}

