/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.EventLogSystemEvents;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.validator.GroupValidators;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.ValidationRuleStorage;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.EventIdValidationError;
import com.intellij.internal.statistic.eventLog.validator.rules.GroupValidationError;
import com.intellij.internal.statistic.eventLog.validator.rules.StorageError;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidator;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.beans.EventDataField;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import java.util.HashMap;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSensitiveDataValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SensitiveDataValidator.kt\ncom/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1603#2,9:216\n1855#2:225\n1603#2,9:226\n1855#2:235\n1856#2:237\n1612#2:238\n1856#2:240\n1612#2:241\n1603#2,9:242\n1855#2:251\n1603#2,9:252\n1855#2:261\n1856#2:263\n1612#2:264\n1856#2:266\n1612#2:267\n1603#2,9:268\n1855#2:277\n1856#2:279\n1612#2:280\n1#3:236\n1#3:239\n1#3:262\n1#3:265\n1#3:278\n*S KotlinDebug\n*F\n+ 1 SensitiveDataValidator.kt\ncom/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator\n*L\n122#1:216,9\n122#1:225\n123#1:226,9\n123#1:235\n123#1:237\n123#1:238\n122#1:240\n122#1:241\n131#1:242,9\n131#1:251\n132#1:252,9\n132#1:261\n132#1:263\n132#1:264\n131#1:266\n131#1:267\n144#1:268,9\n144#1:277\n144#1:279\n144#1:280\n123#1:236\n122#1:239\n132#1:262\n131#1:265\n144#1:278\n*E\n"})
public class SensitiveDataValidator<S extends ValidationRuleStorage<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final S validationRulesStorage;
    @NotNull
    private final RecorderDataValidator recorderDataValidator;

    public SensitiveDataValidator(@NotNull S validationRulesStorage) {
        Intrinsics.checkNotNullParameter(validationRulesStorage, (String)"validationRulesStorage");
        this.validationRulesStorage = validationRulesStorage;
        this.recorderDataValidator = new RecorderDataValidator((ValidationRuleStorage<?>)this.validationRulesStorage);
    }

    @Nullable
    public final LogEvent validateEvent(@NotNull LogEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LogEventAction logEventAction = event.getEvent();
        String string = event.getGroup().getId();
        String string2 = event.getGroup().getVersion();
        String string3 = event.getBuild();
        String string4 = logEventAction.getId();
        Map map2 = logEventAction.getData();
        EventContext eventContext = EventContext.create(logEventAction.getId(), logEventAction.getData());
        Intrinsics.checkNotNullExpressionValue((Object)eventContext, (String)"create(logEventAction.id, logEventAction.data)");
        ValidatedEvent validatedEvent = this.validate(string, string2, string3, string4, map2, eventContext);
        if (validatedEvent == null) {
            return null;
        }
        ValidatedEvent validatedEvent2 = validatedEvent;
        String validatedEventId = validatedEvent2.component1();
        Map<String, Object> validatedEventData = validatedEvent2.component2();
        LogEventAction validatedEvent3 = new LogEventAction(validatedEventId, logEventAction.getState(), validatedEventData, logEventAction.getCount());
        return new LogEvent(event.getSession(), event.getBuild(), event.getBucket(), event.getTime(), new LogEventGroup(event.getGroup().getId(), event.getGroup().getVersion()), event.getRecorderVersion(), validatedEvent3);
    }

    @Nullable
    public final ValidatedEvent validate(@NotNull String groupId, @NotNull String groupVersion, @NotNull String build2, @NotNull String eventId, @NotNull Map<String, ? extends Object> data2, @NotNull EventContext context2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)groupVersion, (String)"groupVersion");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        GroupValidators groupValidators = this.validationRulesStorage.getGroupValidators(groupId);
        EventGroupRules groupRules = groupValidators.component1();
        EventGroupsFilterRules versionFilter = groupValidators.component2();
        if (versionFilter != null && !versionFilter.accepts(groupId, groupVersion, build2)) {
            if (groupRules == null) {
                context2.addError(new GroupValidationError(ValidationResultType.UNDEFINED_RULE, "Invalid group: groupId = " + groupId));
            } else {
                context2.addError(new GroupValidationError(ValidationResultType.REJECTED, "Invalid group or build version: groupId = " + groupId));
            }
            return null;
        }
        String validatedEventId = this.guaranteeCorrectEventId(context2, groupRules);
        Map<String, Object> validatedEventData = this.guaranteeCorrectEventData(context2, groupRules);
        return new ValidatedEvent(validatedEventId, (Map<String, Object>)new HashMap<String, Object>(validatedEventData));
    }

    @NotNull
    protected String guaranteeCorrectEventId(@NotNull EventContext context2, @Nullable EventGroupRules groupRules) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.validationRulesStorage.isUnreachable()) {
            context2.addError(new StorageError(ValidationResultType.UNREACHABLE_METADATA, "Unreachable metadata"));
            String string2 = ValidationResultType.UNREACHABLE_METADATA.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UNREACHABLE_METADATA.description");
            return string2;
        }
        if (EventLogSystemEvents.SYSTEM_EVENTS.contains(context2.eventId) || ValidationResultType.VALIDATION_TYPES.contains(context2.eventId)) {
            String string3 = context2.eventId;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.eventId");
            return string3;
        }
        ValidationResultType validationResultType = Companion.validateEvent(context2, groupRules);
        if (validationResultType == ValidationResultType.ACCEPTED) {
            String string4 = context2.eventId;
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.eventId");
        } else {
            String string5 = context2.eventId;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"context.eventId");
            context2.addError(new EventIdValidationError(validationResultType, string5));
            String string6 = validationResultType.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"{\n            context.ad\u2026ype.description\n        }");
            string = string6;
        }
        return string;
    }

    @NotNull
    protected Map<String, Object> guaranteeCorrectEventData(@NotNull EventContext context2, @Nullable EventGroupRules groupRules) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.validationRulesStorage.isUnreachable()) {
            context2.addError(new StorageError(ValidationResultType.UNREACHABLE_METADATA, "Unreachable metadata"));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ValidationResultType.UNREACHABLE_METADATA.getDescription(), (Object)ValidationResultType.UNREACHABLE_METADATA.getDescription())};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
        if (groupRules == null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ValidationResultType.UNDEFINED_RULE.getDescription(), (Object)ValidationResultType.UNDEFINED_RULE.getDescription())};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
        Map validatedData = new HashMap();
        Map<String, Object> map2 = context2.eventData;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"context.eventData");
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            String key2 = entry.getKey();
            Object entryValue = entry.getValue();
            EventDataField eventDataField = groupRules.validateEventData(key2, entryValue, context2);
            String validatedFieldName = eventDataField.component1();
            Object validateEventData = eventDataField.component2();
            validatedData.put(validatedFieldName, validateEventData);
        }
        return validatedData;
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ValidationResultType validateEvent(@NotNull EventContext context2, @Nullable EventGroupRules groupRules) {
            ValidationResultType validationResultType;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (groupRules == null || !groupRules.areEventIdRulesDefined()) {
                validationResultType = ValidationResultType.UNDEFINED_RULE;
            } else {
                ValidationResultType validationResultType2 = groupRules.validateEventId(context2);
                validationResultType = validationResultType2;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)validationResultType2), (String)"groupRules.validateEventId(context)");
            }
            return validationResultType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class ValidatedEvent {
        @NotNull
        private final String eventId;
        @NotNull
        private final Map<String, Object> eventData;

        public ValidatedEvent(@NotNull String eventId, @NotNull Map<String, Object> eventData) {
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter(eventData, (String)"eventData");
            this.eventId = eventId;
            this.eventData = eventData;
        }

        @NotNull
        public final String component1() {
            return this.eventId;
        }

        @NotNull
        public final Map<String, Object> component2() {
            return this.eventData;
        }

        @NotNull
        public String toString() {
            return "ValidatedEvent(eventId=" + this.eventId + ", eventData=" + this.eventData + ')';
        }

        public int hashCode() {
            int result2 = this.eventId.hashCode();
            result2 = result2 * 31 + ((Object)this.eventData).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedEvent)) {
                return false;
            }
            ValidatedEvent validatedEvent = (ValidatedEvent)other;
            if (!Intrinsics.areEqual((Object)this.eventId, (Object)validatedEvent.eventId)) {
                return false;
            }
            return Intrinsics.areEqual(this.eventData, validatedEvent.eventData);
        }
    }
}

