/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.ChildHandle;
import kotlinx.coroutines.ChildJob;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.selects.SelectClause0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RecursiveJob
implements Job {
    @NotNull
    private final Job originalJob;

    public RecursiveJob(@NotNull Job originalJob) {
        Intrinsics.checkNotNullParameter((Object)originalJob, (String)"originalJob");
        this.originalJob = originalJob;
    }

    @NotNull
    public String toString() {
        return "CIRCULAR REFERENCE: " + this.originalJob;
    }

    @InternalCoroutinesApi
    @NotNull
    public CancellationException getCancellationException() {
        return this.originalJob.getCancellationException();
    }

    public boolean start() {
        return this.originalJob.start();
    }

    public void cancel(@Nullable CancellationException cause) {
        this.originalJob.cancel(cause);
    }

    @Deprecated(message="Since 1.2.0, binary compatibility with versions <= 1.1.x", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ void cancel() {
        this.originalJob.cancel();
    }

    @Deprecated(message="Since 1.2.0, binary compatibility with versions <= 1.1.x", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ boolean cancel(Throwable cause) {
        return this.originalJob.cancel(cause);
    }

    @InternalCoroutinesApi
    @NotNull
    public ChildHandle attachChild(@NotNull ChildJob child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child");
        return this.originalJob.attachChild(child2);
    }

    @Nullable
    public Object join(@NotNull Continuation<? super Unit> $completion) {
        return this.originalJob.join($completion);
    }

    @NotNull
    public DisposableHandle invokeOnCompletion(@NotNull Function1<? super Throwable, Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        return this.originalJob.invokeOnCompletion(handler2);
    }

    @InternalCoroutinesApi
    @NotNull
    public DisposableHandle invokeOnCompletion(boolean onCancelling, boolean invokeImmediately, @NotNull Function1<? super Throwable, Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        return this.originalJob.invokeOnCompletion(onCancelling, invokeImmediately, handler2);
    }

    @Deprecated(message="Operator '+' on two Job objects is meaningless. Job is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The job to the right of `+` just replaces the job the left of `+`.", level=DeprecationLevel.ERROR)
    @NotNull
    public Job plus(@NotNull Job other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.originalJob.plus(other);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.originalJob.plus(context2);
    }

    @Nullable
    public Job getParent() {
        return this.originalJob.getParent();
    }

    public boolean isActive() {
        return this.originalJob.isActive();
    }

    public boolean isCompleted() {
        return this.originalJob.isCompleted();
    }

    public boolean isCancelled() {
        return this.originalJob.isCancelled();
    }

    @NotNull
    public Sequence<Job> getChildren() {
        return this.originalJob.getChildren();
    }

    @NotNull
    public SelectClause0 getOnJoin() {
        return this.originalJob.getOnJoin();
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key2) {
        Intrinsics.checkNotNullParameter(key2, (String)"key");
        return (E)this.originalJob.get(key2);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        return (R)this.originalJob.fold(initial, operation);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key2) {
        Intrinsics.checkNotNullParameter(key2, (String)"key");
        return this.originalJob.minusKey(key2);
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return this.originalJob.getKey();
    }
}

