/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ExtensionSchema;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.MapFieldSchema;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.UnknownFieldSetLiteSchema;
import com.google.protobuf.UnsafeUtil;
import java.lang.reflect.Field;

final class SchemaUtil {
    private static final Class<?> GENERATED_MESSAGE_CLASS = SchemaUtil.getGeneratedMessageClass();
    private static final UnknownFieldSchema<?, ?> UNKNOWN_FIELD_SET_FULL_SCHEMA = SchemaUtil.getUnknownFieldSetSchema();
    private static final UnknownFieldSchema<?, ?> UNKNOWN_FIELD_SET_LITE_SCHEMA = new UnknownFieldSetLiteSchema();

    public static void requireGeneratedMessage(Class<?> messageType) {
        if (!GeneratedMessageLite.class.isAssignableFrom(messageType) && GENERATED_MESSAGE_CLASS != null && !GENERATED_MESSAGE_CLASS.isAssignableFrom(messageType)) {
            throw new IllegalArgumentException("Message classes must extend GeneratedMessageV3 or GeneratedMessageLite");
        }
    }

    public static UnknownFieldSchema<?, ?> unknownFieldSetFullSchema() {
        return UNKNOWN_FIELD_SET_FULL_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> unknownFieldSetLiteSchema() {
        return UNKNOWN_FIELD_SET_LITE_SCHEMA;
    }

    private static UnknownFieldSchema<?, ?> getUnknownFieldSetSchema() {
        try {
            Class<?> clz = SchemaUtil.getUnknownFieldSetSchemaClass();
            if (clz == null) {
                return null;
            }
            return (UnknownFieldSchema)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t2) {
            return null;
        }
    }

    private static Class<?> getGeneratedMessageClass() {
        try {
            return Class.forName("com.google.protobuf.GeneratedMessageV3");
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Class<?> getUnknownFieldSetSchemaClass() {
        try {
            return Class.forName("com.google.protobuf.UnknownFieldSetSchema");
        }
        catch (Throwable e) {
            return null;
        }
    }

    static Object getMapDefaultEntry(Class<?> clazz, String name2) {
        try {
            Class<?> holder = Class.forName(clazz.getName() + "$" + SchemaUtil.toCamelCase(name2, true) + "DefaultEntryHolder");
            Field[] fields2 = holder.getDeclaredFields();
            if (fields2.length != 1) {
                throw new IllegalStateException("Unable to look up map field default entry holder class for " + name2 + " in " + clazz.getName());
            }
            return UnsafeUtil.getStaticObject(fields2[0]);
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
    }

    static String toCamelCase(String name2, boolean capNext) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < name2.length(); ++i2) {
            char c = name2.charAt(i2);
            if ('a' <= c && c <= 'z') {
                if (capNext) {
                    sb.append((char)(c + -32));
                } else {
                    sb.append(c);
                }
                capNext = false;
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                if (i2 == 0 && !capNext) {
                    sb.append((char)(c - -32));
                } else {
                    sb.append(c);
                }
                capNext = false;
                continue;
            }
            if ('0' <= c && c <= '9') {
                sb.append(c);
                capNext = true;
                continue;
            }
            capNext = true;
        }
        return sb.toString();
    }

    static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    static <T> void mergeMap(MapFieldSchema mapFieldSchema, T message2, T o, long offset) {
        Object merged = mapFieldSchema.mergeFrom(UnsafeUtil.getObject(message2, offset), UnsafeUtil.getObject(o, offset));
        UnsafeUtil.putObject(message2, offset, merged);
    }

    static <T, FT extends FieldSet.FieldDescriptorLite<FT>> void mergeExtensions(ExtensionSchema<FT> schema, T message2, T other) {
        FieldSet<FT> otherExtensions = schema.getExtensions(other);
        if (!otherExtensions.isEmpty()) {
            FieldSet<FT> messageExtensions = schema.getMutableExtensions(message2);
            messageExtensions.mergeFrom(otherExtensions);
        }
    }

    static <T, UT, UB> void mergeUnknownFields(UnknownFieldSchema<UT, UB> schema, T message2, T other) {
        UT messageUnknowns = schema.getFromMessage(message2);
        UT otherUnknowns = schema.getFromMessage(other);
        UT merged = schema.merge(messageUnknowns, otherUnknowns);
        schema.setToMessage(message2, merged);
    }
}

