/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ExtensionSchema;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Schema;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.UnknownFieldSchema;

final class MessageSetSchema<T>
implements Schema<T> {
    private final MessageLite defaultInstance;
    private final UnknownFieldSchema<?, ?> unknownFieldSchema;
    private final boolean hasExtensions;
    private final ExtensionSchema<?> extensionSchema;

    private MessageSetSchema(UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MessageLite defaultInstance) {
        this.unknownFieldSchema = unknownFieldSchema;
        this.hasExtensions = extensionSchema.hasExtensions(defaultInstance);
        this.extensionSchema = extensionSchema;
        this.defaultInstance = defaultInstance;
    }

    static <T> MessageSetSchema<T> newSchema(UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MessageLite defaultInstance) {
        return new MessageSetSchema<T>(unknownFieldSchema, extensionSchema, defaultInstance);
    }

    @Override
    public T newInstance() {
        if (this.defaultInstance instanceof GeneratedMessageLite) {
            return (T)((GeneratedMessageLite)this.defaultInstance).newMutableInstance();
        }
        return (T)this.defaultInstance.newBuilderForType().buildPartial();
    }

    @Override
    public boolean equals(T message2, T other) {
        Object otherUnknown;
        Object messageUnknown = this.unknownFieldSchema.getFromMessage(message2);
        if (!messageUnknown.equals(otherUnknown = this.unknownFieldSchema.getFromMessage(other))) {
            return false;
        }
        if (this.hasExtensions) {
            FieldSet<?> messageExtensions = this.extensionSchema.getExtensions(message2);
            FieldSet<?> otherExtensions = this.extensionSchema.getExtensions(other);
            return messageExtensions.equals(otherExtensions);
        }
        return true;
    }

    @Override
    public int hashCode(T message2) {
        int hashCode = this.unknownFieldSchema.getFromMessage(message2).hashCode();
        if (this.hasExtensions) {
            FieldSet<?> extensions = this.extensionSchema.getExtensions(message2);
            hashCode = hashCode * 53 + extensions.hashCode();
        }
        return hashCode;
    }

    @Override
    public void mergeFrom(T message2, T other) {
        SchemaUtil.mergeUnknownFields(this.unknownFieldSchema, message2, other);
        if (this.hasExtensions) {
            SchemaUtil.mergeExtensions(this.extensionSchema, message2, other);
        }
    }

    @Override
    public void makeImmutable(T message2) {
        this.unknownFieldSchema.makeImmutable(message2);
        this.extensionSchema.makeImmutable(message2);
    }
}

