/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MapEntryLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class MapEntry<K, V>
extends AbstractMessage {
    private final K key;
    private final V value;
    private final Metadata<K, V> metadata;
    private volatile int cachedSerializedSize = -1;

    private MapEntry(Metadata metadata, K key2, V value2) {
        this.key = key2;
        this.value = value2;
        this.metadata = metadata;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public int getSerializedSize() {
        int size;
        if (this.cachedSerializedSize != -1) {
            return this.cachedSerializedSize;
        }
        this.cachedSerializedSize = size = MapEntryLite.computeSerializedSize(this.metadata, this.key, this.value);
        return size;
    }

    @Override
    public void writeTo(CodedOutputStream output2) throws IOException {
        MapEntryLite.writeTo(output2, this.metadata, this.key, this.value);
    }

    @Override
    public boolean isInitialized() {
        return MapEntry.isInitialized(this.metadata, this.value);
    }

    public Parser<MapEntry<K, V>> getParserForType() {
        return this.metadata.parser;
    }

    @Override
    public Builder<K, V> newBuilderForType() {
        return new Builder(this.metadata);
    }

    @Override
    public Builder<K, V> toBuilder() {
        return new Builder(this.metadata, this.key, this.value, true, true);
    }

    @Override
    public MapEntry<K, V> getDefaultInstanceForType() {
        return new MapEntry<Object, Object>(this.metadata, this.metadata.defaultKey, this.metadata.defaultValue);
    }

    @Override
    public Descriptors.Descriptor getDescriptorForType() {
        return this.metadata.descriptor;
    }

    @Override
    public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
        TreeMap<Descriptors.FieldDescriptor, Object> result2 = new TreeMap<Descriptors.FieldDescriptor, Object>();
        for (Descriptors.FieldDescriptor field : this.metadata.descriptor.getFields()) {
            if (!this.hasField(field)) continue;
            result2.put(field, this.getField(field));
        }
        return Collections.unmodifiableMap(result2);
    }

    private void checkFieldDescriptor(Descriptors.FieldDescriptor field) {
        if (field.getContainingType() != this.metadata.descriptor) {
            throw new RuntimeException("Wrong FieldDescriptor \"" + field.getFullName() + "\" used in message \"" + this.metadata.descriptor.getFullName());
        }
    }

    @Override
    public boolean hasField(Descriptors.FieldDescriptor field) {
        this.checkFieldDescriptor(field);
        return true;
    }

    @Override
    public Object getField(Descriptors.FieldDescriptor field) {
        Object result2;
        this.checkFieldDescriptor(field);
        Object object = result2 = field.getNumber() == 1 ? this.getKey() : this.getValue();
        if (field.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            result2 = field.getEnumType().findValueByNumberCreatingIfUnknown((Integer)result2);
        }
        return result2;
    }

    @Override
    public UnknownFieldSet getUnknownFields() {
        return UnknownFieldSet.getDefaultInstance();
    }

    private static <V> boolean isInitialized(Metadata metadata, V value2) {
        if (metadata.valueType.getJavaType() == WireFormat.JavaType.MESSAGE) {
            return ((MessageLite)value2).isInitialized();
        }
        return true;
    }

    public static class Builder<K, V>
    extends AbstractMessage.Builder<Builder<K, V>> {
        private final Metadata<K, V> metadata;
        private K key;
        private V value;
        private boolean hasKey;
        private boolean hasValue;

        private Builder(Metadata<K, V> metadata) {
            this(metadata, metadata.defaultKey, metadata.defaultValue, false, false);
        }

        private Builder(Metadata<K, V> metadata, K key2, V value2, boolean hasKey, boolean hasValue) {
            this.metadata = metadata;
            this.key = key2;
            this.value = value2;
            this.hasKey = hasKey;
            this.hasValue = hasValue;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public Builder<K, V> setKey(K key2) {
            this.key = key2;
            this.hasKey = true;
            return this;
        }

        public Builder<K, V> setValue(V value2) {
            this.value = value2;
            this.hasValue = true;
            return this;
        }

        @Override
        public MapEntry<K, V> build() {
            Message result2 = this.buildPartial();
            if (!((MapEntry)result2).isInitialized()) {
                throw Builder.newUninitializedMessageException(result2);
            }
            return result2;
        }

        @Override
        public MapEntry<K, V> buildPartial() {
            return new MapEntry(this.metadata, this.key, this.value);
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return this.metadata.descriptor;
        }

        private void checkFieldDescriptor(Descriptors.FieldDescriptor field) {
            if (field.getContainingType() != this.metadata.descriptor) {
                throw new RuntimeException("Wrong FieldDescriptor \"" + field.getFullName() + "\" used in message \"" + this.metadata.descriptor.getFullName());
            }
        }

        @Override
        public Message.Builder newBuilderForField(Descriptors.FieldDescriptor field) {
            this.checkFieldDescriptor(field);
            if (field.getNumber() != 2 || field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new RuntimeException("\"" + field.getFullName() + "\" is not a message value field.");
            }
            return ((Message)this.value).newBuilderForType();
        }

        @Override
        public Builder<K, V> setField(Descriptors.FieldDescriptor field, Object value2) {
            this.checkFieldDescriptor(field);
            if (value2 == null) {
                throw new NullPointerException(field.getFullName() + " is null");
            }
            if (field.getNumber() == 1) {
                this.setKey(value2);
            } else {
                if (field.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                    value2 = ((Descriptors.EnumValueDescriptor)value2).getNumber();
                } else if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !this.metadata.defaultValue.getClass().isInstance(value2)) {
                    value2 = ((Message)this.metadata.defaultValue).toBuilder().mergeFrom((Message)value2).build();
                }
                this.setValue(value2);
            }
            return this;
        }

        @Override
        public Builder<K, V> addRepeatedField(Descriptors.FieldDescriptor field, Object value2) {
            throw new RuntimeException("There is no repeated field in a map entry message.");
        }

        @Override
        public Builder<K, V> setUnknownFields(UnknownFieldSet unknownFields) {
            return this;
        }

        @Override
        public MapEntry<K, V> getDefaultInstanceForType() {
            return new MapEntry(this.metadata, this.metadata.defaultKey, this.metadata.defaultValue);
        }

        @Override
        public boolean isInitialized() {
            return MapEntry.isInitialized(this.metadata, this.value);
        }

        @Override
        public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
            TreeMap<Descriptors.FieldDescriptor, Object> result2 = new TreeMap<Descriptors.FieldDescriptor, Object>();
            for (Descriptors.FieldDescriptor field : this.metadata.descriptor.getFields()) {
                if (!this.hasField(field)) continue;
                result2.put(field, this.getField(field));
            }
            return Collections.unmodifiableMap(result2);
        }

        @Override
        public boolean hasField(Descriptors.FieldDescriptor field) {
            this.checkFieldDescriptor(field);
            return field.getNumber() == 1 ? this.hasKey : this.hasValue;
        }

        @Override
        public Object getField(Descriptors.FieldDescriptor field) {
            Object result2;
            this.checkFieldDescriptor(field);
            Object object = result2 = field.getNumber() == 1 ? this.getKey() : this.getValue();
            if (field.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                result2 = field.getEnumType().findValueByNumberCreatingIfUnknown((Integer)result2);
            }
            return result2;
        }

        @Override
        public UnknownFieldSet getUnknownFields() {
            return UnknownFieldSet.getDefaultInstance();
        }

        @Override
        public Builder<K, V> clone() {
            return new Builder<K, V>(this.metadata, this.key, this.value, this.hasKey, this.hasValue);
        }
    }

    private static final class Metadata<K, V>
    extends MapEntryLite.Metadata<K, V> {
        public final Descriptors.Descriptor descriptor;
        public final Parser<MapEntry<K, V>> parser;
    }
}

