/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapFieldLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageReflection;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractMessage
extends AbstractMessageLite
implements Message {
    protected int memoizedSize = -1;

    @Override
    public boolean isInitialized() {
        return MessageReflection.isInitialized(this);
    }

    protected Message.Builder newBuilderForType(BuilderParent parent) {
        throw new UnsupportedOperationException("Nested builder is not supported for this type.");
    }

    public boolean hasOneof(Descriptors.OneofDescriptor oneof) {
        throw new UnsupportedOperationException("hasOneof() is not implemented.");
    }

    public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneof) {
        throw new UnsupportedOperationException("getOneofFieldDescriptor() is not implemented.");
    }

    public final String toString() {
        return TextFormat.printer().printToString(this);
    }

    @Override
    public void writeTo(CodedOutputStream output2) throws IOException {
        MessageReflection.writeMessageTo(this, this.getAllFields(), output2, false);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        this.memoizedSize = MessageReflection.getSerializedSize(this, this.getAllFields());
        return this.memoizedSize;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message otherMessage = (Message)other;
        if (this.getDescriptorForType() != otherMessage.getDescriptorForType()) {
            return false;
        }
        return AbstractMessage.compareFields(this.getAllFields(), otherMessage.getAllFields()) && this.getUnknownFields().equals(otherMessage.getUnknownFields());
    }

    public int hashCode() {
        int hash = this.memoizedHashCode;
        if (hash == 0) {
            hash = 41;
            hash = 19 * hash + this.getDescriptorForType().hashCode();
            hash = AbstractMessage.hashFields(hash, this.getAllFields());
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        }
        return hash;
    }

    private static ByteString toByteString(Object value2) {
        if (value2 instanceof byte[]) {
            return ByteString.copyFrom((byte[])value2);
        }
        return (ByteString)value2;
    }

    private static boolean compareBytes(Object a, Object b) {
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        return AbstractMessage.toByteString(a).equals(AbstractMessage.toByteString(b));
    }

    private static Map convertMapEntryListToMap(List list2) {
        if (list2.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> result2 = new HashMap<Object, Object>();
        Iterator iterator2 = list2.iterator();
        Message entry = (Message)iterator2.next();
        Descriptors.Descriptor descriptor = entry.getDescriptorForType();
        Descriptors.FieldDescriptor key2 = descriptor.findFieldByName("key");
        Descriptors.FieldDescriptor value2 = descriptor.findFieldByName("value");
        Object fieldValue = entry.getField(value2);
        if (fieldValue instanceof Descriptors.EnumValueDescriptor) {
            fieldValue = ((Descriptors.EnumValueDescriptor)fieldValue).getNumber();
        }
        result2.put(entry.getField(key2), fieldValue);
        while (iterator2.hasNext()) {
            entry = (Message)iterator2.next();
            fieldValue = entry.getField(value2);
            if (fieldValue instanceof Descriptors.EnumValueDescriptor) {
                fieldValue = ((Descriptors.EnumValueDescriptor)fieldValue).getNumber();
            }
            result2.put(entry.getField(key2), fieldValue);
        }
        return result2;
    }

    private static boolean compareMapField(Object a, Object b) {
        Map ma = AbstractMessage.convertMapEntryListToMap((List)a);
        Map mb = AbstractMessage.convertMapEntryListToMap((List)b);
        return MapFieldLite.equals(ma, mb);
    }

    static boolean compareFields(Map<Descriptors.FieldDescriptor, Object> a, Map<Descriptors.FieldDescriptor, Object> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Descriptors.FieldDescriptor descriptor : a.keySet()) {
            if (!b.containsKey(descriptor)) {
                return false;
            }
            Object value1 = a.get(descriptor);
            Object value2 = b.get(descriptor);
            if (descriptor.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                if (descriptor.isRepeated()) {
                    List list1 = (List)value1;
                    List list2 = (List)value2;
                    if (list1.size() != list2.size()) {
                        return false;
                    }
                    for (int i2 = 0; i2 < list1.size(); ++i2) {
                        if (AbstractMessage.compareBytes(list1.get(i2), list2.get(i2))) continue;
                        return false;
                    }
                    continue;
                }
                if (AbstractMessage.compareBytes(value1, value2)) continue;
                return false;
            }
            if (!(descriptor.isMapField() ? !AbstractMessage.compareMapField(value1, value2) : !value1.equals(value2))) continue;
            return false;
        }
        return true;
    }

    private static int hashMapField(Object value2) {
        return MapFieldLite.calculateHashCodeForMap(AbstractMessage.convertMapEntryListToMap((List)value2));
    }

    protected static int hashFields(int hash, Map<Descriptors.FieldDescriptor, Object> map2) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : map2.entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value2 = entry.getValue();
            hash = 37 * hash + field.getNumber();
            if (field.isMapField()) {
                hash = 53 * hash + AbstractMessage.hashMapField(value2);
                continue;
            }
            if (field.getType() != Descriptors.FieldDescriptor.Type.ENUM) {
                hash = 53 * hash + value2.hashCode();
                continue;
            }
            if (field.isRepeated()) {
                List list2 = (List)value2;
                hash = 53 * hash + Internal.hashEnumList(list2);
                continue;
            }
            hash = 53 * hash + Internal.hashEnum((Internal.EnumLite)value2);
        }
        return hash;
    }

    @Override
    UninitializedMessageException newUninitializedMessageException() {
        return Builder.newUninitializedMessageException(this);
    }

    public static abstract class Builder<BuilderType extends Builder<BuilderType>>
    extends AbstractMessageLite.Builder
    implements Message.Builder {
        @Override
        public BuilderType clone() {
            throw new UnsupportedOperationException("clone() should be implemented in subclasses.");
        }

        public boolean hasOneof(Descriptors.OneofDescriptor oneof) {
            throw new UnsupportedOperationException("hasOneof() is not implemented.");
        }

        public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneof) {
            throw new UnsupportedOperationException("getOneofFieldDescriptor() is not implemented.");
        }

        public BuilderType mergeFrom(Message other) {
            return this.mergeFrom(other, other.getAllFields());
        }

        BuilderType mergeFrom(Message other, Map<Descriptors.FieldDescriptor, Object> allFields) {
            if (other.getDescriptorForType() != this.getDescriptorForType()) {
                throw new IllegalArgumentException("mergeFrom(Message) can only merge messages of the same type.");
            }
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : allFields.entrySet()) {
                Descriptors.FieldDescriptor field = entry.getKey();
                if (field.isRepeated()) {
                    for (Object element : (List)entry.getValue()) {
                        this.addRepeatedField(field, element);
                    }
                    continue;
                }
                if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    Message existingValue = (Message)this.getField(field);
                    if (existingValue == existingValue.getDefaultInstanceForType()) {
                        this.setField(field, entry.getValue());
                        continue;
                    }
                    this.setField(field, existingValue.newBuilderForType().mergeFrom(existingValue).mergeFrom((Message)entry.getValue()).build());
                    continue;
                }
                this.setField(field, entry.getValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            return (BuilderType)this;
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream input) throws IOException {
            return (BuilderType)this.mergeFrom(input, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            boolean discardUnknown = input.shouldDiscardUnknownFields();
            UnknownFieldSet.Builder unknownFields = discardUnknown ? null : this.getUnknownFieldSetBuilder();
            MessageReflection.mergeMessageFrom(this, unknownFields, input, extensionRegistry);
            if (unknownFields != null) {
                this.setUnknownFieldSetBuilder(unknownFields);
            }
            return (BuilderType)this;
        }

        protected UnknownFieldSet.Builder getUnknownFieldSetBuilder() {
            return UnknownFieldSet.newBuilder(this.getUnknownFields());
        }

        protected void setUnknownFieldSetBuilder(UnknownFieldSet.Builder builder) {
            this.setUnknownFields(builder.build());
        }

        public BuilderType mergeUnknownFields(UnknownFieldSet unknownFields) {
            this.setUnknownFields(UnknownFieldSet.newBuilder(this.getUnknownFields()).mergeFrom(unknownFields).build());
            return (BuilderType)this;
        }

        @Override
        public Message.Builder getFieldBuilder(Descriptors.FieldDescriptor field) {
            throw new UnsupportedOperationException("getFieldBuilder() called on an unsupported message type.");
        }

        public String toString() {
            return TextFormat.printer().printToString(this);
        }

        protected static UninitializedMessageException newUninitializedMessageException(Message message2) {
            return new UninitializedMessageException(MessageReflection.findMissingFields(message2));
        }

        void markClean() {
            throw new IllegalStateException("Should be overridden by subclasses.");
        }

        @Override
        public BuilderType mergeFrom(ByteString data2) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data2));
        }

        @Override
        public BuilderType mergeFrom(ByteString data2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data2, extensionRegistry));
        }
    }

    protected static interface BuilderParent {
        public void markDirty();
    }
}

