/*
 * Decompiled with CFR 0.152.
 */
package com.canonical;

import com.canonical.Event;
import com.canonical.IDBusMenu;
import com.canonical.MenuItem;
import com.canonical.Pair;
import com.canonical.UpdatedProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.freedesktop.StatusNotifierItem;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;

public class DBusMenu
implements IDBusMenu {
    public static final String MENU_OBJECTPATH = "/MenuBar";
    private final List<StatusNotifierItem.MenuItem> menuItems;
    private int myRevision = 2;
    private final String serviceName;

    public DBusMenu(String serviceName, List<StatusNotifierItem.MenuItem> menuItems2) throws DBusException {
        this.serviceName = serviceName;
        this.menuItems = menuItems2;
        DBusConnection connection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        connection.changeThreadCount((byte)1);
        connection.requestBusName(serviceName);
        connection.exportObject(MENU_OBJECTPATH, (DBusInterface)this);
    }

    public void unregister() throws DBusException {
        DBusConnection connection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        connection.unExportObject(MENU_OBJECTPATH);
        connection.releaseBusName(this.serviceName);
    }

    @Override
    public Pair<UInt32, MenuItem> GetLayout(int parentId, int recursionDepth, List<String> propertyNames) {
        ArrayList<MenuItem> childNodes = new ArrayList<MenuItem>();
        for (int i2 = 0; i2 < this.menuItems.size(); ++i2) {
            int id = i2 + 1;
            HashMap childProps = new HashMap();
            childProps.put("label", new Variant((Object)this.menuItems.get(i2).getText()));
            childNodes.add(new MenuItem(id, childProps));
        }
        HashMap props = new HashMap();
        props.put("children-display", new Variant((Object)"submenu"));
        MenuItem rootNode = new MenuItem(0, props, childNodes);
        return new Pair<UInt32, MenuItem>(new UInt32((long)this.myRevision++), rootNode);
    }

    @Override
    public List<UpdatedProperties> GetGroupProperties(List<Integer> ids, List<String> propertyNames) {
        ArrayList<UpdatedProperties> result2 = new ArrayList<UpdatedProperties>();
        int i2 = 1;
        for (StatusNotifierItem.MenuItem menuItem : this.menuItems) {
            HashMap item2 = new HashMap();
            item2.put("label", new Variant((Object)menuItem.getText()));
            result2.add(new UpdatedProperties(i2, item2));
            ++i2;
        }
        return result2;
    }

    @Override
    public Variant<?> GetProperty(int id, String name2) {
        return null;
    }

    @Override
    public void Event(int id, String eventId, Variant<?> data2, UInt32 timestamp2) {
        int idx = id - 1;
        if (0 <= idx && idx < this.menuItems.size()) {
            this.menuItems.get(idx).getListener().onActivated();
        }
    }

    @Override
    public List<Integer> EventGroup(List<Event> events) {
        return null;
    }

    @Override
    public boolean AboutToShow(int id) {
        return false;
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return MENU_OBJECTPATH;
    }

    @Override
    public Pair<List<Integer>, List<Integer>> AboutToShowGroup(List<Integer> ids) {
        return null;
    }
}

