/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nLayoutConfiguration.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutConfiguration.desktop.kt\nandroidx/compose/ui/window/LayoutConfiguration_desktopKt\n+ 2 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,92:1\n33#2:93\n53#3,3:94\n*S KotlinDebug\n*F\n+ 1 LayoutConfiguration.desktop.kt\nandroidx/compose/ui/window/LayoutConfiguration_desktopKt\n*L\n50#1:93\n50#1:94,3\n*E\n"})
public final class LayoutConfiguration_desktopKt {
    @NotNull
    public static final Density getGlobalDensity() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getDefaultConfiguration(...)");
        return LayoutConfiguration_desktopKt.getDensity(graphicsConfiguration);
    }

    @NotNull
    public static final Density getDensity(@NotNull Component $this$density) {
        Intrinsics.checkNotNullParameter((Object)$this$density, (String)"<this>");
        GraphicsConfiguration graphicsConfiguration = $this$density.getGraphicsConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
        return LayoutConfiguration_desktopKt.getDensity(graphicsConfiguration);
    }

    /*
     * WARNING - void declaration
     */
    public static final long getSizeInPx(@NotNull Component $this$sizeInPx) {
        void width$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sizeInPx, (String)"<this>");
        float scale2 = LayoutConfiguration_desktopKt.getDensity($this$sizeInPx).getDensity();
        float f = (float)$this$sizeInPx.getWidth() * scale2;
        float height$iv = (float)$this$sizeInPx.getHeight() * scale2;
        boolean $i$f$Size = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
        long v2$iv$iv = Float.floatToRawIntBits(height$iv);
        return Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    private static final Density getDensity(GraphicsConfiguration $this$density) {
        return DensityKt.Density((float)$this$density.getDefaultTransform().getScaleX(), 1.0f);
    }

    @NotNull
    public static final LayoutDirection getGlobalLayoutDirection() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        return LayoutConfiguration_desktopKt.getLayoutDirection(locale);
    }

    @NotNull
    public static final LayoutDirection getLayoutDirection(@NotNull Locale $this$layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$layoutDirection, (String)"<this>");
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation($this$layoutDirection);
        Intrinsics.checkNotNullExpressionValue((Object)componentOrientation, (String)"getOrientation(...)");
        return LayoutConfiguration_desktopKt.getLayoutDirection(componentOrientation);
    }

    @NotNull
    public static final LayoutDirection getLayoutDirection(@NotNull ComponentOrientation $this$layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$layoutDirection, (String)"<this>");
        return $this$layoutDirection.isLeftToRight() ? LayoutDirection.Ltr : ($this$layoutDirection.isHorizontal() ? LayoutDirection.Rtl : LayoutDirection.Ltr);
    }

    @NotNull
    public static final ComponentOrientation getComponentOrientation(@NotNull LayoutDirection $this$componentOrientation) {
        ComponentOrientation componentOrientation;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$componentOrientation), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$componentOrientation.ordinal()]) {
            case 1: {
                ComponentOrientation componentOrientation2 = ComponentOrientation.LEFT_TO_RIGHT;
                componentOrientation = componentOrientation2;
                Intrinsics.checkNotNullExpressionValue((Object)componentOrientation2, (String)"LEFT_TO_RIGHT");
                break;
            }
            case 2: {
                ComponentOrientation componentOrientation3 = ComponentOrientation.RIGHT_TO_LEFT;
                componentOrientation = componentOrientation3;
                Intrinsics.checkNotNullExpressionValue((Object)componentOrientation3, (String)"RIGHT_TO_LEFT");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return componentOrientation;
    }

    @NotNull
    public static final LayoutDirection layoutDirectionFor(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ComponentOrientation orientation = component.getComponentOrientation();
        if (Intrinsics.areEqual((Object)orientation, (Object)ComponentOrientation.UNKNOWN)) {
            Locale locale = component.getLocale();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
            return LayoutConfiguration_desktopKt.getLayoutDirection(locale);
        }
        Intrinsics.checkNotNull((Object)orientation);
        return LayoutConfiguration_desktopKt.getLayoutDirection(orientation);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LayoutDirection.values().length];
            try {
                nArray[LayoutDirection.Ltr.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LayoutDirection.Rtl.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

