/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MoveCursorCommand
implements EditCommand {
    private final int amount;

    @Override
    public void applyTo(@NotNull EditingBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.getCursor$ui_text() == -1) {
            buffer.setCursor$ui_text(buffer.getSelectionStart$ui_text());
        }
        int newCursor = buffer.getSelectionStart$ui_text();
        String bufferText = buffer.toString();
        if (this.amount > 0) {
            int next2;
            int n = this.amount;
            for (int i2 = 0; i2 < n && (next2 = CharHelpers_skikoKt.findFollowingBreak(bufferText, newCursor)) != -1; ++i2) {
                newCursor = next2;
            }
        } else {
            int prev;
            int n = -this.amount;
            for (int i3 = 0; i3 < n && (prev = CharHelpers_skikoKt.findPrecedingBreak(bufferText, newCursor)) != -1; ++i3) {
                newCursor = prev;
            }
        }
        buffer.setCursor$ui_text(newCursor);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MoveCursorCommand)) {
            return false;
        }
        return this.amount == ((MoveCursorCommand)other).amount;
    }

    public int hashCode() {
        return this.amount;
    }

    @NotNull
    public String toString() {
        return "MoveCursorCommand(amount=" + this.amount + ")";
    }
}

