/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.GapBufferKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/ui/text/input/GapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1#2:319\n*E\n"})
final class GapBuffer {
    private int capacity;
    @NotNull
    private char[] buffer;
    private int gapStart;
    private int gapEnd;

    public GapBuffer(@NotNull char[] initBuffer, int initGapStart, int initGapEnd) {
        Intrinsics.checkNotNullParameter((Object)initBuffer, (String)"initBuffer");
        this.capacity = initBuffer.length;
        this.buffer = initBuffer;
        this.gapStart = initGapStart;
        this.gapEnd = initGapEnd;
    }

    private final int gapLength() {
        return this.gapEnd - this.gapStart;
    }

    public final char get(int index) {
        if (index < this.gapStart) {
            return this.buffer[index];
        }
        return this.buffer[index - this.gapStart + this.gapEnd];
    }

    private final void makeSureAvailableSpace(int requestSize) {
        if (requestSize <= this.gapLength()) {
            return;
        }
        int necessarySpace = requestSize - this.gapLength();
        int newCapacity = this.capacity * 2;
        while (newCapacity - this.capacity < necessarySpace) {
            newCapacity *= 2;
        }
        char[] newBuffer = new char[newCapacity];
        ArraysKt.copyInto((char[])this.buffer, (char[])newBuffer, (int)0, (int)0, (int)this.gapStart);
        int tailLength = this.capacity - this.gapEnd;
        int newEnd = newCapacity - tailLength;
        ArraysKt.copyInto((char[])this.buffer, (char[])newBuffer, (int)newEnd, (int)this.gapEnd, (int)(this.gapEnd + tailLength));
        this.buffer = newBuffer;
        this.capacity = newCapacity;
        this.gapEnd = newEnd;
    }

    private final void delete(int start2, int end) {
        if (start2 < this.gapStart && end <= this.gapStart) {
            int copyLen = this.gapStart - end;
            ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)(this.gapEnd - copyLen), (int)end, (int)this.gapStart);
            this.gapStart = start2;
            this.gapEnd -= copyLen;
        } else if (start2 < this.gapStart && end >= this.gapStart) {
            this.gapEnd = end + this.gapLength();
            this.gapStart = start2;
        } else {
            int startInBuffer = start2 + this.gapLength();
            int endInBuffer = end + this.gapLength();
            int copyLen = startInBuffer - this.gapEnd;
            ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)this.gapStart, (int)this.gapEnd, (int)startInBuffer);
            this.gapStart += copyLen;
            this.gapEnd = endInBuffer;
        }
    }

    public final void replace(int start2, int end, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.makeSureAvailableSpace(text2.length() - (end - start2));
        this.delete(start2, end);
        GapBufferKt.access$toCharArray(text2, this.buffer, this.gapStart);
        this.gapStart += text2.length();
    }

    public final void append(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        StringBuilder stringBuilder = builder;
        char[] cArray = this.buffer;
        int n = 0;
        int n2 = this.gapStart;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(cArray, n, n2 - n), (String)"append(...)");
        stringBuilder = builder;
        cArray = this.buffer;
        n = this.gapEnd;
        n2 = this.capacity;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(cArray, n, n2 - n), (String)"append(...)");
    }

    public final int length() {
        return this.capacity - this.gapLength();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append((CharSequence)$this$toString_u24lambda_u240);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

