/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.EditingBufferKt;
import androidx.compose.ui.text.input.PartialGapBuffer;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nEditingBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditingBuffer.kt\nandroidx/compose/ui/text/input/EditingBuffer\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,382:1\n118#2,4:383\n118#2,4:387\n*S KotlinDebug\n*F\n+ 1 EditingBuffer.kt\nandroidx/compose/ui/text/input/EditingBuffer\n*L\n50#1:383,4\n59#1:387,4\n*E\n"})
public final class EditingBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PartialGapBuffer gapBuffer;
    private int selectionStart;
    private int selectionEnd;
    private int compositionStart;
    private int compositionEnd;
    public static final int $stable = 8;

    private EditingBuffer(AnnotatedString text2, long selection) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.gapBuffer = new PartialGapBuffer(text2.getText());
        this.selectionStart = TextRange.getMin-impl(selection);
        this.selectionEnd = TextRange.getMax-impl(selection);
        this.compositionStart = -1;
        this.compositionEnd = -1;
        int start2 = TextRange.getMin-impl(selection);
        int end = TextRange.getMax-impl(selection);
        if (start2 < 0 || start2 > text2.length()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + text2.length());
        }
        if (end < 0 || end > text2.length()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + text2.length());
        }
        if (start2 > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start2 + " > " + end);
        }
    }

    public final int getSelectionStart$ui_text() {
        return this.selectionStart;
    }

    private final void setSelectionStart(int value2) {
        boolean value$iv = value2 >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Cannot set selectionStart to a negative value: " + value2);
        }
        this.selectionStart = value2;
    }

    public final int getSelectionEnd$ui_text() {
        return this.selectionEnd;
    }

    private final void setSelectionEnd(int value2) {
        boolean value$iv = value2 >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Cannot set selectionEnd to a negative value: " + value2);
        }
        this.selectionEnd = value2;
    }

    public final int getCompositionStart$ui_text() {
        return this.compositionStart;
    }

    public final int getCompositionEnd$ui_text() {
        return this.compositionEnd;
    }

    public final boolean hasComposition$ui_text() {
        return this.compositionStart != -1;
    }

    @Nullable
    public final TextRange getComposition-MzsxiRA$ui_text() {
        return this.hasComposition$ui_text() ? TextRange.box-impl(TextRangeKt.TextRange(this.compositionStart, this.compositionEnd)) : null;
    }

    public final long getSelection-d9O1mEE$ui_text() {
        return TextRangeKt.TextRange(this.selectionStart, this.selectionEnd);
    }

    public final int getCursor$ui_text() {
        return this.selectionStart == this.selectionEnd ? this.selectionEnd : -1;
    }

    public final void setCursor$ui_text(int cursor2) {
        this.setSelection$ui_text(cursor2, cursor2);
    }

    public final char get$ui_text(int index) {
        return this.gapBuffer.get(index);
    }

    public final int getLength$ui_text() {
        return this.gapBuffer.getLength();
    }

    public final void replace$ui_text(int start2, int end, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (start2 < 0 || start2 > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start2 > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start2 + " > " + end);
        }
        this.gapBuffer.replace(start2, end, text2);
        this.setSelectionStart(start2 + text2.length());
        this.setSelectionEnd(start2 + text2.length());
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void delete$ui_text(int start2, int end) {
        long deleteRange = TextRangeKt.TextRange(start2, end);
        this.gapBuffer.replace(start2, end, "");
        long newSelection = EditingBufferKt.updateRangeAfterDelete-pWDy79M(TextRangeKt.TextRange(this.selectionStart, this.selectionEnd), deleteRange);
        this.setSelectionStart(TextRange.getMin-impl(newSelection));
        this.setSelectionEnd(TextRange.getMax-impl(newSelection));
        if (this.hasComposition$ui_text()) {
            long compositionRange = TextRangeKt.TextRange(this.compositionStart, this.compositionEnd);
            long newComposition = EditingBufferKt.updateRangeAfterDelete-pWDy79M(compositionRange, deleteRange);
            if (TextRange.getCollapsed-impl(newComposition)) {
                this.commitComposition$ui_text();
            } else {
                this.compositionStart = TextRange.getMin-impl(newComposition);
                this.compositionEnd = TextRange.getMax-impl(newComposition);
            }
        }
    }

    public final void setSelection$ui_text(int start2, int end) {
        if (start2 < 0 || start2 > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start2 > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start2 + " > " + end);
        }
        this.setSelectionStart(start2);
        this.setSelectionEnd(end);
    }

    public final void setComposition$ui_text(int start2, int end) {
        if (start2 < 0 || start2 > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start2 >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start2 + " > " + end);
        }
        this.compositionStart = start2;
        this.compositionEnd = end;
    }

    public final void commitComposition$ui_text() {
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    @NotNull
    public String toString() {
        return this.gapBuffer.toString();
    }

    @NotNull
    public final AnnotatedString toAnnotatedString$ui_text() {
        return new AnnotatedString(this.toString(), null, 2, null);
    }

    public /* synthetic */ EditingBuffer(AnnotatedString text2, long selection, DefaultConstructorMarker $constructor_marker) {
        this(text2, selection);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

