/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditCommandKt;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,558:1\n118#2,4:559\n*S KotlinDebug\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand\n*L\n309#1:559,4\n*E\n"})
public final class DeleteSurroundingTextInCodePointsCommand
implements EditCommand {
    private final int lengthBeforeCursor;
    private final int lengthAfterCursor;

    public DeleteSurroundingTextInCodePointsCommand(int lengthBeforeCursor, int lengthAfterCursor) {
        this.lengthBeforeCursor = lengthBeforeCursor;
        this.lengthAfterCursor = lengthAfterCursor;
        boolean value$iv = this.lengthBeforeCursor >= 0 && this.lengthAfterCursor >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + this.lengthBeforeCursor + " and " + this.lengthAfterCursor + " respectively.");
        }
    }

    @Override
    public void applyTo(@NotNull EditingBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int beforeLenInChars = 0;
        int n = this.lengthBeforeCursor;
        for (int i2 = 0; i2 < n; ++i2) {
            if (buffer.getSelectionStart$ui_text() > ++beforeLenInChars) {
                char trail;
                char lead = buffer.get$ui_text(buffer.getSelectionStart$ui_text() - beforeLenInChars - 1);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail = buffer.get$ui_text(buffer.getSelectionStart$ui_text() - beforeLenInChars))) continue;
                ++beforeLenInChars;
                continue;
            }
            beforeLenInChars = buffer.getSelectionStart$ui_text();
            break;
        }
        int afterLenInChars = 0;
        int n2 = this.lengthAfterCursor;
        for (int i3 = 0; i3 < n2; ++i3) {
            if (buffer.getSelectionEnd$ui_text() + ++afterLenInChars < buffer.getLength$ui_text()) {
                char trail;
                char lead = buffer.get$ui_text(buffer.getSelectionEnd$ui_text() + afterLenInChars - 1);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail = buffer.get$ui_text(buffer.getSelectionEnd$ui_text() + afterLenInChars))) continue;
                ++afterLenInChars;
                continue;
            }
            afterLenInChars = buffer.getLength$ui_text() - buffer.getSelectionEnd$ui_text();
            break;
        }
        buffer.delete$ui_text(buffer.getSelectionEnd$ui_text(), buffer.getSelectionEnd$ui_text() + afterLenInChars);
        buffer.delete$ui_text(buffer.getSelectionStart$ui_text() - beforeLenInChars, buffer.getSelectionStart$ui_text());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteSurroundingTextInCodePointsCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextInCodePointsCommand)other).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextInCodePointsCommand)other).lengthAfterCursor;
    }

    public int hashCode() {
        int result2 = this.lengthBeforeCursor;
        result2 = 31 * result2 + this.lengthAfterCursor;
        return result2;
    }

    @NotNull
    public String toString() {
        return "DeleteSurroundingTextInCodePointsCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ")";
    }
}

