/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.ParagraphStyleKt;
import androidx.compose.ui.text.PlatformTextStyle;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.SpanStyleKt;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.intl.LocaleList;
import androidx.compose.ui.text.style.BaselineShift;
import androidx.compose.ui.text.style.Hyphens;
import androidx.compose.ui.text.style.LineBreak;
import androidx.compose.ui.text.style.LineHeightStyle;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.text.style.TextForegroundStyle;
import androidx.compose.ui.text.style.TextGeometricTransform;
import androidx.compose.ui.text.style.TextIndent;
import androidx.compose.ui.text.style.TextMotion;
import androidx.compose.ui.unit.TextUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TextStyle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpanStyle spanStyle;
    @NotNull
    private final ParagraphStyle paragraphStyle;
    @Nullable
    private final PlatformTextStyle platformStyle;
    @NotNull
    private static final TextStyle Default = new TextStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFFFFF, null);

    public TextStyle(@NotNull SpanStyle spanStyle, @NotNull ParagraphStyle paragraphStyle, @Nullable PlatformTextStyle platformStyle) {
        Intrinsics.checkNotNullParameter((Object)spanStyle, (String)"spanStyle");
        Intrinsics.checkNotNullParameter((Object)paragraphStyle, (String)"paragraphStyle");
        this.spanStyle = spanStyle;
        this.paragraphStyle = paragraphStyle;
        this.platformStyle = platformStyle;
    }

    @NotNull
    public final SpanStyle getSpanStyle$ui_text() {
        return this.spanStyle;
    }

    @NotNull
    public final ParagraphStyle getParagraphStyle$ui_text() {
        return this.paragraphStyle;
    }

    @Nullable
    public final PlatformTextStyle getPlatformStyle() {
        return this.platformStyle;
    }

    public TextStyle(@NotNull SpanStyle spanStyle, @NotNull ParagraphStyle paragraphStyle) {
        Intrinsics.checkNotNullParameter((Object)spanStyle, (String)"spanStyle");
        Intrinsics.checkNotNullParameter((Object)paragraphStyle, (String)"paragraphStyle");
        this(spanStyle, paragraphStyle, TextStyleKt.access$createPlatformTextStyleInternal(spanStyle.getPlatformStyle(), paragraphStyle.getPlatformStyle()));
    }

    private TextStyle(long color, long fontSize, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String fontFeatureSettings, long letterSpacing, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, long background, TextDecoration textDecoration, Shadow shadow, DrawStyle drawStyle, int textAlign, int textDirection, long lineHeight, TextIndent textIndent, PlatformTextStyle platformStyle, LineHeightStyle lineHeightStyle, int lineBreak, int hyphens, TextMotion textMotion) {
        PlatformTextStyle platformTextStyle = platformStyle;
        PlatformTextStyle platformTextStyle2 = platformStyle;
        this(new SpanStyle(color, fontSize, fontWeight, fontStyle, fontSynthesis, fontFamily, fontFeatureSettings, letterSpacing, baselineShift, textGeometricTransform, localeList, background, textDecoration, shadow, platformTextStyle != null ? platformTextStyle.getSpanStyle() : null, drawStyle, null), new ParagraphStyle(textAlign, textDirection, lineHeight, textIndent, platformTextStyle2 != null ? platformTextStyle2.getParagraphStyle() : null, lineHeightStyle, lineBreak, hyphens, textMotion, null), platformStyle);
    }

    public /* synthetic */ TextStyle(long l, long l2, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String string, long l3, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, long l4, TextDecoration textDecoration, Shadow shadow, DrawStyle drawStyle, int n, int n2, long l5, TextIndent textIndent, PlatformTextStyle platformTextStyle, LineHeightStyle lineHeightStyle, int n3, int n4, TextMotion textMotion, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            l = Color.Companion.getUnspecified-0d7_KjU();
        }
        if ((n5 & 2) != 0) {
            l2 = TextUnit.Companion.getUnspecified-XSAIIZE();
        }
        if ((n5 & 4) != 0) {
            fontWeight = null;
        }
        if ((n5 & 8) != 0) {
            fontStyle = null;
        }
        if ((n5 & 0x10) != 0) {
            fontSynthesis = null;
        }
        if ((n5 & 0x20) != 0) {
            fontFamily = null;
        }
        if ((n5 & 0x40) != 0) {
            string = null;
        }
        if ((n5 & 0x80) != 0) {
            l3 = TextUnit.Companion.getUnspecified-XSAIIZE();
        }
        if ((n5 & 0x100) != 0) {
            baselineShift = null;
        }
        if ((n5 & 0x200) != 0) {
            textGeometricTransform = null;
        }
        if ((n5 & 0x400) != 0) {
            localeList = null;
        }
        if ((n5 & 0x800) != 0) {
            l4 = Color.Companion.getUnspecified-0d7_KjU();
        }
        if ((n5 & 0x1000) != 0) {
            textDecoration = null;
        }
        if ((n5 & 0x2000) != 0) {
            shadow = null;
        }
        if ((n5 & 0x4000) != 0) {
            drawStyle = null;
        }
        if ((n5 & 0x8000) != 0) {
            n = TextAlign.Companion.getUnspecified-e0LSkKk();
        }
        if ((n5 & 0x10000) != 0) {
            n2 = TextDirection.Companion.getUnspecified-s_7X-co();
        }
        if ((n5 & 0x20000) != 0) {
            l5 = TextUnit.Companion.getUnspecified-XSAIIZE();
        }
        if ((n5 & 0x40000) != 0) {
            textIndent = null;
        }
        if ((n5 & 0x80000) != 0) {
            platformTextStyle = null;
        }
        if ((n5 & 0x100000) != 0) {
            lineHeightStyle = null;
        }
        if ((n5 & 0x200000) != 0) {
            n3 = LineBreak.Companion.getUnspecified-rAG3T2k();
        }
        if ((n5 & 0x400000) != 0) {
            n4 = Hyphens.Companion.getUnspecified-vmbZdU8();
        }
        if ((n5 & 0x800000) != 0) {
            textMotion = null;
        }
        this(l, l2, fontWeight, fontStyle, fontSynthesis, fontFamily, string, l3, baselineShift, textGeometricTransform, localeList, l4, textDecoration, shadow, drawStyle, n, n2, l5, textIndent, platformTextStyle, lineHeightStyle, n3, n4, textMotion, null);
    }

    @NotNull
    public final SpanStyle toSpanStyle() {
        return this.spanStyle;
    }

    @NotNull
    public final ParagraphStyle toParagraphStyle() {
        return this.paragraphStyle;
    }

    @NotNull
    public final TextStyle merge(@Nullable TextStyle other) {
        if (other == null || Intrinsics.areEqual((Object)other, (Object)Default)) {
            return this;
        }
        return new TextStyle(this.toSpanStyle().merge(other.toSpanStyle()), this.toParagraphStyle().merge(other.toParagraphStyle()));
    }

    @NotNull
    public final TextStyle merge-dA7vx0o(long color, long fontSize, @Nullable FontWeight fontWeight, @Nullable FontStyle fontStyle, @Nullable FontSynthesis fontSynthesis, @Nullable FontFamily fontFamily, @Nullable String fontFeatureSettings, long letterSpacing, @Nullable BaselineShift baselineShift, @Nullable TextGeometricTransform textGeometricTransform, @Nullable LocaleList localeList, long background, @Nullable TextDecoration textDecoration, @Nullable Shadow shadow, @Nullable DrawStyle drawStyle, int textAlign, int textDirection, long lineHeight, @Nullable TextIndent textIndent, @Nullable LineHeightStyle lineHeightStyle, int lineBreak, int hyphens, @Nullable PlatformTextStyle platformStyle, @Nullable TextMotion textMotion) {
        PlatformTextStyle platformTextStyle = platformStyle;
        SpanStyle mergedSpanStyle = SpanStyleKt.fastMerge-dSHsh3o(this.spanStyle, color, null, Float.NaN, fontSize, fontWeight, fontStyle, fontSynthesis, fontFamily, fontFeatureSettings, letterSpacing, baselineShift, textGeometricTransform, localeList, background, textDecoration, shadow, platformTextStyle != null ? platformTextStyle.getSpanStyle() : null, drawStyle);
        PlatformTextStyle platformTextStyle2 = platformStyle;
        ParagraphStyle mergedParagraphStyle = ParagraphStyleKt.fastMerge-j5T8yCg(this.paragraphStyle, textAlign, textDirection, lineHeight, textIndent, platformTextStyle2 != null ? platformTextStyle2.getParagraphStyle() : null, lineHeightStyle, lineBreak, hyphens, textMotion);
        if (this.spanStyle == mergedSpanStyle && this.paragraphStyle == mergedParagraphStyle) {
            return this;
        }
        return new TextStyle(mergedSpanStyle, mergedParagraphStyle);
    }

    public static /* synthetic */ TextStyle merge-dA7vx0o$default(TextStyle textStyle, long l, long l2, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String string, long l3, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, long l4, TextDecoration textDecoration, Shadow shadow, DrawStyle drawStyle, int n, int n2, long l5, TextIndent textIndent, LineHeightStyle lineHeightStyle, int n3, int n4, PlatformTextStyle platformTextStyle, TextMotion textMotion, int n5, Object object) {
        if ((n5 & 1) != 0) {
            l = Color.Companion.getUnspecified-0d7_KjU();
        }
        if ((n5 & 2) != 0) {
            l2 = TextUnit.Companion.getUnspecified-XSAIIZE();
        }
        if ((n5 & 4) != 0) {
            fontWeight = null;
        }
        if ((n5 & 8) != 0) {
            fontStyle = null;
        }
        if ((n5 & 0x10) != 0) {
            fontSynthesis = null;
        }
        if ((n5 & 0x20) != 0) {
            fontFamily = null;
        }
        if ((n5 & 0x40) != 0) {
            string = null;
        }
        if ((n5 & 0x80) != 0) {
            l3 = TextUnit.Companion.getUnspecified-XSAIIZE();
        }
        if ((n5 & 0x100) != 0) {
            baselineShift = null;
        }
        if ((n5 & 0x200) != 0) {
            textGeometricTransform = null;
        }
        if ((n5 & 0x400) != 0) {
            localeList = null;
        }
        if ((n5 & 0x800) != 0) {
            l4 = Color.Companion.getUnspecified-0d7_KjU();
        }
        if ((n5 & 0x1000) != 0) {
            textDecoration = null;
        }
        if ((n5 & 0x2000) != 0) {
            shadow = null;
        }
        if ((n5 & 0x4000) != 0) {
            drawStyle = null;
        }
        if ((n5 & 0x8000) != 0) {
            n = TextAlign.Companion.getUnspecified-e0LSkKk();
        }
        if ((n5 & 0x10000) != 0) {
            n2 = TextDirection.Companion.getUnspecified-s_7X-co();
        }
        if ((n5 & 0x20000) != 0) {
            l5 = TextUnit.Companion.getUnspecified-XSAIIZE();
        }
        if ((n5 & 0x40000) != 0) {
            textIndent = null;
        }
        if ((n5 & 0x80000) != 0) {
            lineHeightStyle = null;
        }
        if ((n5 & 0x100000) != 0) {
            n3 = LineBreak.Companion.getUnspecified-rAG3T2k();
        }
        if ((n5 & 0x200000) != 0) {
            n4 = Hyphens.Companion.getUnspecified-vmbZdU8();
        }
        if ((n5 & 0x400000) != 0) {
            platformTextStyle = null;
        }
        if ((n5 & 0x800000) != 0) {
            textMotion = null;
        }
        return textStyle.merge-dA7vx0o(l, l2, fontWeight, fontStyle, fontSynthesis, fontFamily, string, l3, baselineShift, textGeometricTransform, localeList, l4, textDecoration, shadow, drawStyle, n, n2, l5, textIndent, lineHeightStyle, n3, n4, platformTextStyle, textMotion);
    }

    @NotNull
    public final TextStyle merge(@NotNull ParagraphStyle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new TextStyle(this.toSpanStyle(), this.toParagraphStyle().merge(other));
    }

    @NotNull
    public final TextStyle copy-p1EtxEg(long color, long fontSize, @Nullable FontWeight fontWeight, @Nullable FontStyle fontStyle, @Nullable FontSynthesis fontSynthesis, @Nullable FontFamily fontFamily, @Nullable String fontFeatureSettings, long letterSpacing, @Nullable BaselineShift baselineShift, @Nullable TextGeometricTransform textGeometricTransform, @Nullable LocaleList localeList, long background, @Nullable TextDecoration textDecoration, @Nullable Shadow shadow, @Nullable DrawStyle drawStyle, int textAlign, int textDirection, long lineHeight, @Nullable TextIndent textIndent, @Nullable PlatformTextStyle platformStyle, @Nullable LineHeightStyle lineHeightStyle, int lineBreak, int hyphens, @Nullable TextMotion textMotion) {
        PlatformTextStyle platformTextStyle = platformStyle;
        PlatformTextStyle platformTextStyle2 = platformStyle;
        return new TextStyle(new SpanStyle(Color.equals-impl0(color, this.spanStyle.getColor-0d7_KjU()) ? this.spanStyle.getTextForegroundStyle$ui_text() : TextForegroundStyle.Companion.from-8_81llA(color), fontSize, fontWeight, fontStyle, fontSynthesis, fontFamily, fontFeatureSettings, letterSpacing, baselineShift, textGeometricTransform, localeList, background, textDecoration, shadow, platformTextStyle != null ? platformTextStyle.getSpanStyle() : null, drawStyle, null), new ParagraphStyle(textAlign, textDirection, lineHeight, textIndent, platformTextStyle2 != null ? platformTextStyle2.getParagraphStyle() : null, lineHeightStyle, lineBreak, hyphens, textMotion, null), platformStyle);
    }

    public static /* synthetic */ TextStyle copy-p1EtxEg$default(TextStyle textStyle, long l, long l2, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String string, long l3, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, long l4, TextDecoration textDecoration, Shadow shadow, DrawStyle drawStyle, int n, int n2, long l5, TextIndent textIndent, PlatformTextStyle platformTextStyle, LineHeightStyle lineHeightStyle, int n3, int n4, TextMotion textMotion, int n5, Object object) {
        if ((n5 & 1) != 0) {
            l = textStyle.spanStyle.getColor-0d7_KjU();
        }
        if ((n5 & 2) != 0) {
            l2 = textStyle.spanStyle.getFontSize-XSAIIZE();
        }
        if ((n5 & 4) != 0) {
            fontWeight = textStyle.spanStyle.getFontWeight();
        }
        if ((n5 & 8) != 0) {
            fontStyle = textStyle.spanStyle.getFontStyle-4Lr2A7w();
        }
        if ((n5 & 0x10) != 0) {
            fontSynthesis = textStyle.spanStyle.getFontSynthesis-ZQGJjVo();
        }
        if ((n5 & 0x20) != 0) {
            fontFamily = textStyle.spanStyle.getFontFamily();
        }
        if ((n5 & 0x40) != 0) {
            string = textStyle.spanStyle.getFontFeatureSettings();
        }
        if ((n5 & 0x80) != 0) {
            l3 = textStyle.spanStyle.getLetterSpacing-XSAIIZE();
        }
        if ((n5 & 0x100) != 0) {
            baselineShift = textStyle.spanStyle.getBaselineShift-5SSeXJ0();
        }
        if ((n5 & 0x200) != 0) {
            textGeometricTransform = textStyle.spanStyle.getTextGeometricTransform();
        }
        if ((n5 & 0x400) != 0) {
            localeList = textStyle.spanStyle.getLocaleList();
        }
        if ((n5 & 0x800) != 0) {
            l4 = textStyle.spanStyle.getBackground-0d7_KjU();
        }
        if ((n5 & 0x1000) != 0) {
            textDecoration = textStyle.spanStyle.getTextDecoration();
        }
        if ((n5 & 0x2000) != 0) {
            shadow = textStyle.spanStyle.getShadow();
        }
        if ((n5 & 0x4000) != 0) {
            drawStyle = textStyle.spanStyle.getDrawStyle();
        }
        if ((n5 & 0x8000) != 0) {
            n = textStyle.paragraphStyle.getTextAlign-e0LSkKk();
        }
        if ((n5 & 0x10000) != 0) {
            n2 = textStyle.paragraphStyle.getTextDirection-s_7X-co();
        }
        if ((n5 & 0x20000) != 0) {
            l5 = textStyle.paragraphStyle.getLineHeight-XSAIIZE();
        }
        if ((n5 & 0x40000) != 0) {
            textIndent = textStyle.paragraphStyle.getTextIndent();
        }
        if ((n5 & 0x80000) != 0) {
            platformTextStyle = textStyle.platformStyle;
        }
        if ((n5 & 0x100000) != 0) {
            lineHeightStyle = textStyle.paragraphStyle.getLineHeightStyle();
        }
        if ((n5 & 0x200000) != 0) {
            n3 = textStyle.paragraphStyle.getLineBreak-rAG3T2k();
        }
        if ((n5 & 0x400000) != 0) {
            n4 = textStyle.paragraphStyle.getHyphens-vmbZdU8();
        }
        if ((n5 & 0x800000) != 0) {
            textMotion = textStyle.paragraphStyle.getTextMotion();
        }
        return textStyle.copy-p1EtxEg(l, l2, fontWeight, fontStyle, fontSynthesis, fontFamily, string, l3, baselineShift, textGeometricTransform, localeList, l4, textDecoration, shadow, drawStyle, n, n2, l5, textIndent, platformTextStyle, lineHeightStyle, n3, n4, textMotion);
    }

    @NotNull
    public final TextStyle copy-Ns73l9s(@Nullable Brush brush, float alpha2, long fontSize, @Nullable FontWeight fontWeight, @Nullable FontStyle fontStyle, @Nullable FontSynthesis fontSynthesis, @Nullable FontFamily fontFamily, @Nullable String fontFeatureSettings, long letterSpacing, @Nullable BaselineShift baselineShift, @Nullable TextGeometricTransform textGeometricTransform, @Nullable LocaleList localeList, long background, @Nullable TextDecoration textDecoration, @Nullable Shadow shadow, @Nullable DrawStyle drawStyle, int textAlign, int textDirection, long lineHeight, @Nullable TextIndent textIndent, @Nullable PlatformTextStyle platformStyle, @Nullable LineHeightStyle lineHeightStyle, int lineBreak, int hyphens, @Nullable TextMotion textMotion) {
        PlatformTextStyle platformTextStyle = platformStyle;
        PlatformTextStyle platformTextStyle2 = platformStyle;
        return new TextStyle(new SpanStyle(brush, alpha2, fontSize, fontWeight, fontStyle, fontSynthesis, fontFamily, fontFeatureSettings, letterSpacing, baselineShift, textGeometricTransform, localeList, background, textDecoration, shadow, platformTextStyle != null ? platformTextStyle.getSpanStyle() : null, drawStyle, null), new ParagraphStyle(textAlign, textDirection, lineHeight, textIndent, platformTextStyle2 != null ? platformTextStyle2.getParagraphStyle() : null, lineHeightStyle, lineBreak, hyphens, textMotion, null), platformStyle);
    }

    public static /* synthetic */ TextStyle copy-Ns73l9s$default(TextStyle textStyle, Brush brush, float f, long l, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String string, long l2, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, long l3, TextDecoration textDecoration, Shadow shadow, DrawStyle drawStyle, int n, int n2, long l4, TextIndent textIndent, PlatformTextStyle platformTextStyle, LineHeightStyle lineHeightStyle, int n3, int n4, TextMotion textMotion, int n5, Object object) {
        if ((n5 & 2) != 0) {
            f = textStyle.spanStyle.getAlpha();
        }
        if ((n5 & 4) != 0) {
            l = textStyle.spanStyle.getFontSize-XSAIIZE();
        }
        if ((n5 & 8) != 0) {
            fontWeight = textStyle.spanStyle.getFontWeight();
        }
        if ((n5 & 0x10) != 0) {
            fontStyle = textStyle.spanStyle.getFontStyle-4Lr2A7w();
        }
        if ((n5 & 0x20) != 0) {
            fontSynthesis = textStyle.spanStyle.getFontSynthesis-ZQGJjVo();
        }
        if ((n5 & 0x40) != 0) {
            fontFamily = textStyle.spanStyle.getFontFamily();
        }
        if ((n5 & 0x80) != 0) {
            string = textStyle.spanStyle.getFontFeatureSettings();
        }
        if ((n5 & 0x100) != 0) {
            l2 = textStyle.spanStyle.getLetterSpacing-XSAIIZE();
        }
        if ((n5 & 0x200) != 0) {
            baselineShift = textStyle.spanStyle.getBaselineShift-5SSeXJ0();
        }
        if ((n5 & 0x400) != 0) {
            textGeometricTransform = textStyle.spanStyle.getTextGeometricTransform();
        }
        if ((n5 & 0x800) != 0) {
            localeList = textStyle.spanStyle.getLocaleList();
        }
        if ((n5 & 0x1000) != 0) {
            l3 = textStyle.spanStyle.getBackground-0d7_KjU();
        }
        if ((n5 & 0x2000) != 0) {
            textDecoration = textStyle.spanStyle.getTextDecoration();
        }
        if ((n5 & 0x4000) != 0) {
            shadow = textStyle.spanStyle.getShadow();
        }
        if ((n5 & 0x8000) != 0) {
            drawStyle = textStyle.spanStyle.getDrawStyle();
        }
        if ((n5 & 0x10000) != 0) {
            n = textStyle.paragraphStyle.getTextAlign-e0LSkKk();
        }
        if ((n5 & 0x20000) != 0) {
            n2 = textStyle.paragraphStyle.getTextDirection-s_7X-co();
        }
        if ((n5 & 0x40000) != 0) {
            l4 = textStyle.paragraphStyle.getLineHeight-XSAIIZE();
        }
        if ((n5 & 0x80000) != 0) {
            textIndent = textStyle.paragraphStyle.getTextIndent();
        }
        if ((n5 & 0x100000) != 0) {
            platformTextStyle = textStyle.platformStyle;
        }
        if ((n5 & 0x200000) != 0) {
            lineHeightStyle = textStyle.paragraphStyle.getLineHeightStyle();
        }
        if ((n5 & 0x400000) != 0) {
            n3 = textStyle.paragraphStyle.getLineBreak-rAG3T2k();
        }
        if ((n5 & 0x800000) != 0) {
            n4 = textStyle.paragraphStyle.getHyphens-vmbZdU8();
        }
        if ((n5 & 0x1000000) != 0) {
            textMotion = textStyle.paragraphStyle.getTextMotion();
        }
        return textStyle.copy-Ns73l9s(brush, f, l, fontWeight, fontStyle, fontSynthesis, fontFamily, string, l2, baselineShift, textGeometricTransform, localeList, l3, textDecoration, shadow, drawStyle, n, n2, l4, textIndent, platformTextStyle, lineHeightStyle, n3, n4, textMotion);
    }

    @Nullable
    public final Brush getBrush() {
        return this.spanStyle.getBrush();
    }

    public final long getColor-0d7_KjU() {
        return this.spanStyle.getColor-0d7_KjU();
    }

    public final float getAlpha() {
        return this.spanStyle.getAlpha();
    }

    public final long getFontSize-XSAIIZE() {
        return this.spanStyle.getFontSize-XSAIIZE();
    }

    @Nullable
    public final FontWeight getFontWeight() {
        return this.spanStyle.getFontWeight();
    }

    @Nullable
    public final FontStyle getFontStyle-4Lr2A7w() {
        return this.spanStyle.getFontStyle-4Lr2A7w();
    }

    @Nullable
    public final FontSynthesis getFontSynthesis-ZQGJjVo() {
        return this.spanStyle.getFontSynthesis-ZQGJjVo();
    }

    @Nullable
    public final FontFamily getFontFamily() {
        return this.spanStyle.getFontFamily();
    }

    @Nullable
    public final String getFontFeatureSettings() {
        return this.spanStyle.getFontFeatureSettings();
    }

    public final long getLetterSpacing-XSAIIZE() {
        return this.spanStyle.getLetterSpacing-XSAIIZE();
    }

    @Nullable
    public final BaselineShift getBaselineShift-5SSeXJ0() {
        return this.spanStyle.getBaselineShift-5SSeXJ0();
    }

    @Nullable
    public final TextGeometricTransform getTextGeometricTransform() {
        return this.spanStyle.getTextGeometricTransform();
    }

    @Nullable
    public final LocaleList getLocaleList() {
        return this.spanStyle.getLocaleList();
    }

    public final long getBackground-0d7_KjU() {
        return this.spanStyle.getBackground-0d7_KjU();
    }

    @Nullable
    public final TextDecoration getTextDecoration() {
        return this.spanStyle.getTextDecoration();
    }

    @Nullable
    public final Shadow getShadow() {
        return this.spanStyle.getShadow();
    }

    @Nullable
    public final DrawStyle getDrawStyle() {
        return this.spanStyle.getDrawStyle();
    }

    public final int getTextAlign-e0LSkKk() {
        return this.paragraphStyle.getTextAlign-e0LSkKk();
    }

    public final int getTextDirection-s_7X-co() {
        return this.paragraphStyle.getTextDirection-s_7X-co();
    }

    public final long getLineHeight-XSAIIZE() {
        return this.paragraphStyle.getLineHeight-XSAIIZE();
    }

    @Nullable
    public final TextIndent getTextIndent() {
        return this.paragraphStyle.getTextIndent();
    }

    @Nullable
    public final LineHeightStyle getLineHeightStyle() {
        return this.paragraphStyle.getLineHeightStyle();
    }

    public final int getHyphens-vmbZdU8() {
        return this.paragraphStyle.getHyphens-vmbZdU8();
    }

    public final int getLineBreak-rAG3T2k() {
        return this.paragraphStyle.getLineBreak-rAG3T2k();
    }

    @Nullable
    public final TextMotion getTextMotion() {
        return this.paragraphStyle.getTextMotion();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextStyle)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spanStyle, (Object)((TextStyle)other).spanStyle)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paragraphStyle, (Object)((TextStyle)other).paragraphStyle)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.platformStyle, (Object)((TextStyle)other).platformStyle);
    }

    public final boolean hasSameLayoutAffectingAttributes(@NotNull TextStyle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this == other || Intrinsics.areEqual((Object)this.paragraphStyle, (Object)other.paragraphStyle) && this.spanStyle.hasSameLayoutAffectingAttributes$ui_text(other.spanStyle);
    }

    public final boolean hasSameDrawAffectingAttributes(@NotNull TextStyle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this == other || this.spanStyle.hasSameNonLayoutAttributes$ui_text(other.spanStyle);
    }

    public int hashCode() {
        int result2 = this.spanStyle.hashCode();
        result2 = 31 * result2 + this.paragraphStyle.hashCode();
        PlatformTextStyle platformTextStyle = this.platformStyle;
        result2 = 31 * result2 + (platformTextStyle != null ? platformTextStyle.hashCode() : 0);
        return result2;
    }

    public final int hashCodeLayoutAffectingAttributes$ui_text() {
        int result2 = this.spanStyle.hashCodeLayoutAffectingAttributes$ui_text();
        result2 = 31 * result2 + this.paragraphStyle.hashCode();
        PlatformTextStyle platformTextStyle = this.platformStyle;
        result2 = 31 * result2 + (platformTextStyle != null ? platformTextStyle.hashCode() : 0);
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("TextStyle(");
        $this$toString_u24lambda_u240.append("color=" + Color.toString-impl(this.getColor-0d7_KjU()) + ", ");
        $this$toString_u24lambda_u240.append("brush=" + this.getBrush() + ", ");
        $this$toString_u24lambda_u240.append("alpha=" + this.getAlpha() + ", ");
        $this$toString_u24lambda_u240.append("fontSize=" + TextUnit.toString-impl(this.getFontSize-XSAIIZE()) + ", ");
        $this$toString_u24lambda_u240.append("fontWeight=" + this.getFontWeight() + ", ");
        $this$toString_u24lambda_u240.append("fontStyle=" + this.getFontStyle-4Lr2A7w() + ", ");
        $this$toString_u24lambda_u240.append("fontSynthesis=" + this.getFontSynthesis-ZQGJjVo() + ", ");
        $this$toString_u24lambda_u240.append("fontFamily=" + this.getFontFamily() + ", ");
        $this$toString_u24lambda_u240.append("fontFeatureSettings=" + this.getFontFeatureSettings() + ", ");
        $this$toString_u24lambda_u240.append("letterSpacing=" + TextUnit.toString-impl(this.getLetterSpacing-XSAIIZE()) + ", ");
        $this$toString_u24lambda_u240.append("baselineShift=" + this.getBaselineShift-5SSeXJ0() + ", ");
        $this$toString_u24lambda_u240.append("textGeometricTransform=" + this.getTextGeometricTransform() + ", ");
        $this$toString_u24lambda_u240.append("localeList=" + this.getLocaleList() + ", ");
        $this$toString_u24lambda_u240.append("background=" + Color.toString-impl(this.getBackground-0d7_KjU()) + ", ");
        $this$toString_u24lambda_u240.append("textDecoration=" + this.getTextDecoration() + ", ");
        $this$toString_u24lambda_u240.append("shadow=" + this.getShadow() + ", ");
        $this$toString_u24lambda_u240.append("drawStyle=" + this.getDrawStyle() + ", ");
        $this$toString_u24lambda_u240.append("textAlign=" + TextAlign.toString-impl(this.getTextAlign-e0LSkKk()) + ", ");
        $this$toString_u24lambda_u240.append("textDirection=" + TextDirection.toString-impl(this.getTextDirection-s_7X-co()) + ", ");
        $this$toString_u24lambda_u240.append("lineHeight=" + TextUnit.toString-impl(this.getLineHeight-XSAIIZE()) + ", ");
        $this$toString_u24lambda_u240.append("textIndent=" + this.getTextIndent() + ", ");
        $this$toString_u24lambda_u240.append("platformStyle=" + this.platformStyle + ", ");
        $this$toString_u24lambda_u240.append("lineHeightStyle=" + this.getLineHeightStyle() + ", ");
        $this$toString_u24lambda_u240.append("lineBreak=" + LineBreak.toString-impl(this.getLineBreak-rAG3T2k()) + ", ");
        $this$toString_u24lambda_u240.append("hyphens=" + Hyphens.toString-impl(this.getHyphens-vmbZdU8()) + ", ");
        $this$toString_u24lambda_u240.append("textMotion=" + this.getTextMotion());
        $this$toString_u24lambda_u240.append(")");
        return stringBuilder.toString();
    }

    public /* synthetic */ TextStyle(long color, long fontSize, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String fontFeatureSettings, long letterSpacing, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, long background, TextDecoration textDecoration, Shadow shadow, DrawStyle drawStyle, int textAlign, int textDirection, long lineHeight, TextIndent textIndent, PlatformTextStyle platformStyle, LineHeightStyle lineHeightStyle, int lineBreak, int hyphens, TextMotion textMotion, DefaultConstructorMarker $constructor_marker) {
        this(color, fontSize, fontWeight, fontStyle, fontSynthesis, fontFamily, fontFeatureSettings, letterSpacing, baselineShift, textGeometricTransform, localeList, background, textDecoration, shadow, drawStyle, textAlign, textDirection, lineHeight, textIndent, platformStyle, lineHeightStyle, lineBreak, hyphens, textMotion);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextStyle getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

