/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.ParagraphKt;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutCache;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextMeasurerKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nTextMeasurer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMeasurer.kt\nandroidx/compose/ui/text/TextMeasurer\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,455:1\n30#2:456\n80#3:457\n*S KotlinDebug\n*F\n+ 1 TextMeasurer.kt\nandroidx/compose/ui/text/TextMeasurer\n*L\n178#1:456\n178#1:457\n*E\n"})
public final class TextMeasurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FontFamily.Resolver defaultFontFamilyResolver;
    @NotNull
    private final Density defaultDensity;
    @NotNull
    private final LayoutDirection defaultLayoutDirection;
    private final int cacheSize;
    @Nullable
    private final TextLayoutCache textLayoutCache;

    public TextMeasurer(@NotNull FontFamily.Resolver defaultFontFamilyResolver, @NotNull Density defaultDensity, @NotNull LayoutDirection defaultLayoutDirection, int cacheSize) {
        Intrinsics.checkNotNullParameter((Object)defaultFontFamilyResolver, (String)"defaultFontFamilyResolver");
        Intrinsics.checkNotNullParameter((Object)defaultDensity, (String)"defaultDensity");
        Intrinsics.checkNotNullParameter((Object)((Object)defaultLayoutDirection), (String)"defaultLayoutDirection");
        this.defaultFontFamilyResolver = defaultFontFamilyResolver;
        this.defaultDensity = defaultDensity;
        this.defaultLayoutDirection = defaultLayoutDirection;
        this.cacheSize = cacheSize;
        this.textLayoutCache = this.cacheSize > 0 ? new TextLayoutCache(this.cacheSize) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextLayoutResult measure-xDpz5zY(@NotNull AnnotatedString text2, @NotNull TextStyle style, int overflow, boolean softWrap, int maxLines, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, long constraints, @NotNull LayoutDirection layoutDirection, @NotNull Density density, @NotNull FontFamily.Resolver fontFamilyResolver, boolean skipCache) {
        TextLayoutResult textLayoutResult;
        TextLayoutResult cacheResult;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        TextLayoutInput requestedTextLayoutInput = new TextLayoutInput(text2, style, placeholders, maxLines, softWrap, overflow, density, layoutDirection, fontFamilyResolver, constraints, null);
        TextLayoutResult textLayoutResult2 = cacheResult = !skipCache && this.textLayoutCache != null ? this.textLayoutCache.get(requestedTextLayoutInput) : null;
        if (cacheResult != null) {
            void height$iv;
            void width$iv;
            int n = ParagraphKt.ceilToInt(cacheResult.getMultiParagraph().getWidth());
            int n2 = ParagraphKt.ceilToInt(cacheResult.getMultiParagraph().getHeight());
            boolean $i$f$IntSize = false;
            boolean $i$f$packInts = false;
            textLayoutResult = cacheResult.copy-O0kMr_c(requestedTextLayoutInput, ConstraintsKt.constrain-4WqzIAM(constraints, IntSize.constructor-impl((long)width$iv << 32 | (long)height$iv & 0xFFFFFFFFL)));
        } else {
            TextLayoutResult textLayoutResult3;
            TextLayoutResult it = textLayoutResult3 = TextMeasurer.Companion.layout(requestedTextLayoutInput);
            boolean bl = false;
            TextLayoutCache textLayoutCache = this.textLayoutCache;
            if (textLayoutCache != null) {
                textLayoutCache.put(requestedTextLayoutInput, it);
            }
            textLayoutResult = textLayoutResult3;
        }
        return textLayoutResult;
    }

    public static /* synthetic */ TextLayoutResult measure-xDpz5zY$default(TextMeasurer textMeasurer, AnnotatedString annotatedString, TextStyle textStyle, int n, boolean bl, int n2, List list2, long l, LayoutDirection layoutDirection, Density density, FontFamily.Resolver resolver, boolean bl2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            textStyle = TextStyle.Companion.getDefault();
        }
        if ((n3 & 4) != 0) {
            n = TextOverflow.Companion.getClip-gIe3tQ8();
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        if ((n3 & 0x10) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n3 & 0x40) != 0) {
            l = ConstraintsKt.Constraints$default(0, 0, 0, 0, 15, null);
        }
        if ((n3 & 0x80) != 0) {
            layoutDirection = textMeasurer.defaultLayoutDirection;
        }
        if ((n3 & 0x100) != 0) {
            density = textMeasurer.defaultDensity;
        }
        if ((n3 & 0x200) != 0) {
            resolver = textMeasurer.defaultFontFamilyResolver;
        }
        if ((n3 & 0x400) != 0) {
            bl2 = false;
        }
        return textMeasurer.measure-xDpz5zY(annotatedString, textStyle, n, bl, n2, list2, l, layoutDirection, density, resolver, bl2);
    }

    @SourceDebugExtension(value={"SMAP\nTextMeasurer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMeasurer.kt\nandroidx/compose/ui/text/TextMeasurer$Companion\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,455:1\n30#2:456\n80#3:457\n*S KotlinDebug\n*F\n+ 1 TextMeasurer.kt\nandroidx/compose/ui/text/TextMeasurer$Companion\n*L\n343#1:456\n343#1:457\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final TextLayoutResult layout(TextLayoutInput textLayoutInput) {
            void height$iv;
            void width$iv;
            TextLayoutInput $this$layout_u24lambda_u240 = textLayoutInput;
            boolean bl = false;
            AnnotatedString annotatedString = $this$layout_u24lambda_u240.getText();
            TextStyle textStyle = TextStyleKt.resolveDefaults($this$layout_u24lambda_u240.getStyle(), $this$layout_u24lambda_u240.getLayoutDirection());
            Density density = $this$layout_u24lambda_u240.getDensity();
            FontFamily.Resolver resolver = $this$layout_u24lambda_u240.getFontFamilyResolver();
            List<AnnotatedString.Range<Placeholder>> list2 = $this$layout_u24lambda_u240.getPlaceholders();
            MultiParagraphIntrinsics nonNullIntrinsics = new MultiParagraphIntrinsics(annotatedString, textStyle, list2, density, resolver);
            int minWidth = Constraints.getMinWidth-impl($this$layout_u24lambda_u240.getConstraints-msEJaDk());
            boolean widthMatters = $this$layout_u24lambda_u240.getSoftWrap() || TextMeasurerKt.access$isEllipsis-MW5-ApA($this$layout_u24lambda_u240.getOverflow-gIe3tQ8());
            int maxWidth = widthMatters && Constraints.getHasBoundedWidth-impl($this$layout_u24lambda_u240.getConstraints-msEJaDk()) ? Constraints.getMaxWidth-impl($this$layout_u24lambda_u240.getConstraints-msEJaDk()) : Integer.MAX_VALUE;
            boolean overwriteMaxLines = !$this$layout_u24lambda_u240.getSoftWrap() && TextMeasurerKt.access$isEllipsis-MW5-ApA($this$layout_u24lambda_u240.getOverflow-gIe3tQ8());
            int finalMaxLines = overwriteMaxLines ? 1 : $this$layout_u24lambda_u240.getMaxLines();
            int width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((int)ParagraphKt.ceilToInt(nonNullIntrinsics.getMaxIntrinsicWidth()), (int)minWidth, (int)maxWidth);
            MultiParagraph multiParagraph = new MultiParagraph(nonNullIntrinsics, Constraints.Companion.fitPrioritizingWidth-Zbe2FdA(0, width, 0, Constraints.getMaxHeight-impl($this$layout_u24lambda_u240.getConstraints-msEJaDk())), finalMaxLines, $this$layout_u24lambda_u240.getOverflow-gIe3tQ8(), null);
            int n = (int)Math.ceil(multiParagraph.getWidth());
            int n2 = (int)Math.ceil(multiParagraph.getHeight());
            boolean $i$f$IntSize = false;
            boolean $i$f$packInts = false;
            return new TextLayoutResult(textLayoutInput, multiParagraph, ConstraintsKt.constrain-4WqzIAM($this$layout_u24lambda_u240.getConstraints-msEJaDk(), IntSize.constructor-impl((long)width$iv << 32 | (long)height$iv & 0xFFFFFFFFL)), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

