/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.collection.LruCache;
import androidx.compose.ui.text.CacheTextLayoutInput;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextLayoutCache {
    @Nullable
    private final LruCache<CacheTextLayoutInput, TextLayoutResult> cache;
    @Nullable
    private CacheTextLayoutInput singleSizeCacheInput;
    @Nullable
    private TextLayoutResult singleSizeCacheResult;
    public static final int $stable = 8;

    public TextLayoutCache(int capacity) {
        this.cache = capacity != 1 ? new LruCache(capacity) : null;
    }

    public /* synthetic */ TextLayoutCache(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        this(n);
    }

    @Nullable
    public final TextLayoutResult get(@NotNull TextLayoutInput key2) {
        TextLayoutResult textLayoutResult;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        CacheTextLayoutInput cacheKey = new CacheTextLayoutInput(key2);
        if (this.cache != null) {
            textLayoutResult = (TextLayoutResult)this.cache.get((Object)cacheKey);
        } else if (Intrinsics.areEqual((Object)this.singleSizeCacheInput, (Object)cacheKey)) {
            textLayoutResult = this.singleSizeCacheResult;
        } else {
            return null;
        }
        TextLayoutResult resultFromCache = textLayoutResult;
        if (resultFromCache == null) {
            return null;
        }
        if (resultFromCache.getMultiParagraph().getIntrinsics().getHasStaleResolvedFonts()) {
            return null;
        }
        return resultFromCache;
    }

    public final void put(@NotNull TextLayoutInput key2, @NotNull TextLayoutResult value2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (this.cache != null) {
            this.cache.put((Object)new CacheTextLayoutInput(key2), (Object)value2);
        } else {
            this.singleSizeCacheInput = new CacheTextLayoutInput(key2);
            this.singleSizeCacheResult = value2;
        }
    }

    public TextLayoutCache() {
        this(0, 1, null);
    }
}

