/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.MultiParagraphIntrinsicsKt;
import androidx.compose.ui.text.ParagraphIntrinsicInfo;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.ParagraphIntrinsicsKt;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nMultiParagraphIntrinsics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiParagraphIntrinsics.kt\nandroidx/compose/ui/text/MultiParagraphIntrinsics\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,157:1\n1245#2:158\n1247#2:164\n1246#2,3:165\n151#3,2:159\n35#3,3:161\n39#3:168\n153#3:169\n103#3:170\n35#3,5:171\n104#3:176\n169#3,12:177\n169#3,12:189\n*S KotlinDebug\n*F\n+ 1 MultiParagraphIntrinsics.kt\nandroidx/compose/ui/text/MultiParagraphIntrinsics\n*L\n98#1:158\n98#1:164\n98#1:165,3\n98#1:159,2\n98#1:161,3\n98#1:168\n98#1:169\n125#1:170\n125#1:171,5\n125#1:176\n79#1:177,12\n85#1:189,12\n*E\n"})
public final class MultiParagraphIntrinsics
implements ParagraphIntrinsics {
    @NotNull
    private final AnnotatedString annotatedString;
    @NotNull
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    @NotNull
    private final Lazy minIntrinsicWidth$delegate;
    @NotNull
    private final Lazy maxIntrinsicWidth$delegate;
    @NotNull
    private final List<ParagraphIntrinsicInfo> infoList;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public MultiParagraphIntrinsics(@NotNull AnnotatedString annotatedString, @NotNull TextStyle style, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, @NotNull Density density, @NotNull FontFamily.Resolver fontFamilyResolver) {
        void $this$mapEachParagraphStyle$iv;
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.annotatedString = annotatedString;
        this.placeholders = placeholders;
        this.minIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> MultiParagraphIntrinsics.minIntrinsicWidth_delegate$lambda$1(this));
        this.maxIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> MultiParagraphIntrinsics.maxIntrinsicWidth_delegate$lambda$3(this));
        ParagraphStyle paragraphStyle = style.toParagraphStyle();
        AnnotatedString annotatedString2 = this.annotatedString;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this;
        boolean $i$f$mapEachParagraphStyle = false;
        List<AnnotatedString.Range<ParagraphStyle>> $this$fastMap$iv$iv = AnnotatedStringKt.normalizedParagraphStyles((AnnotatedString)$this$mapEachParagraphStyle$iv, paragraphStyle);
        boolean $i$f$fastMap = false;
        ArrayList target$iv$iv = new ArrayList($this$fastMap$iv$iv.size());
        List<AnnotatedString.Range<ParagraphStyle>> $this$fastForEach$iv$iv$iv = $this$fastMap$iv$iv;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv$iv$iv).size();
        for (int index$iv$iv$iv = 0; index$iv$iv$iv < n; ++index$iv$iv$iv) {
            void paragraphStyleItem;
            void paragraphStyleRange$iv;
            AnnotatedString.Range<ParagraphStyle> item$iv$iv$iv;
            AnnotatedString.Range<ParagraphStyle> it$iv$iv = item$iv$iv$iv = $this$fastForEach$iv$iv$iv.get(index$iv$iv$iv);
            boolean bl = false;
            AnnotatedString.Range<ParagraphStyle> range = it$iv$iv;
            Collection collection = target$iv$iv;
            boolean bl2 = false;
            AnnotatedString annotatedString$iv = AnnotatedStringKt.access$substringWithoutParagraphStyles((AnnotatedString)$this$mapEachParagraphStyle$iv, paragraphStyleRange$iv.getStart(), paragraphStyleRange$iv.getEnd());
            void var23_24 = paragraphStyleRange$iv;
            AnnotatedString annotatedString3 = annotatedString$iv;
            boolean bl3 = false;
            ParagraphStyle currentParagraphStyle = this.resolveTextDirection((ParagraphStyle)paragraphStyleItem.getItem(), paragraphStyle);
            String string = annotatedString3.getText();
            TextStyle textStyle = style.merge(currentParagraphStyle);
            List list2 = annotatedString3.getAnnotations$ui_text();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List list3 = list2;
            List list4 = MultiParagraphIntrinsicsKt.access$getLocalPlaceholders(this.getPlaceholders(), paragraphStyleItem.getStart(), paragraphStyleItem.getEnd());
            collection.add(new ParagraphIntrinsicInfo(ParagraphIntrinsicsKt.ParagraphIntrinsics(string, textStyle, list3, density, fontFamilyResolver, list4), paragraphStyleItem.getStart(), paragraphStyleItem.getEnd()));
        }
        multiParagraphIntrinsics.infoList = target$iv$iv;
    }

    @NotNull
    public final AnnotatedString getAnnotatedString() {
        return this.annotatedString;
    }

    @NotNull
    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public float getMinIntrinsicWidth() {
        Lazy lazy = this.minIntrinsicWidth$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        Lazy lazy = this.maxIntrinsicWidth$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    @NotNull
    public final List<ParagraphIntrinsicInfo> getInfoList$ui_text() {
        return this.infoList;
    }

    @Override
    public boolean getHasStaleResolvedFonts() {
        boolean bl;
        block1: {
            List<ParagraphIntrinsicInfo> $this$fastAny$iv = this.infoList;
            boolean $i$f$fastAny = false;
            List<ParagraphIntrinsicInfo> $this$fastForEach$iv$iv = $this$fastAny$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                ParagraphIntrinsicInfo item$iv$iv;
                ParagraphIntrinsicInfo it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl2 = false;
                ParagraphIntrinsicInfo it = it$iv;
                boolean bl3 = false;
                if (!it.getIntrinsics().getHasStaleResolvedFonts()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final ParagraphStyle resolveTextDirection(ParagraphStyle style, ParagraphStyle defaultStyle) {
        return !TextDirection.equals-impl0(style.getTextDirection-s_7X-co(), TextDirection.Companion.getUnspecified-s_7X-co()) ? style : ParagraphStyle.copy-ykzQM6k$default(style, 0, defaultStyle.getTextDirection-s_7X-co(), 0L, null, null, null, 0, 0, null, 509, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final float minIntrinsicWidth_delegate$lambda$1(MultiParagraphIntrinsics this$0) {
        Object object;
        Object v0;
        List<ParagraphIntrinsicInfo> $this$fastMaxBy$iv = this$0.infoList;
        boolean $i$f$fastMaxBy = false;
        if ($this$fastMaxBy$iv.isEmpty()) {
            v0 = null;
        } else {
            void var3_3;
            ParagraphIntrinsicInfo maxElem$iv;
            ParagraphIntrinsicInfo it = maxElem$iv = $this$fastMaxBy$iv.get(0);
            boolean bl = false;
            float maxValue$iv = it.getIntrinsics().getMinIntrinsicWidth();
            int i$iv = 1;
            int n = CollectionsKt.getLastIndex($this$fastMaxBy$iv);
            if (i$iv <= n) {
                while (true) {
                    ParagraphIntrinsicInfo e$iv;
                    ParagraphIntrinsicInfo it2 = e$iv = $this$fastMaxBy$iv.get(i$iv);
                    $i$a$-fastMaxBy-MultiParagraphIntrinsics$minIntrinsicWidth$2$1 = false;
                    float v$iv = it2.getIntrinsics().getMinIntrinsicWidth();
                    if (Float.compare(maxValue$iv, v$iv) < 0) {
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            v0 = var3_3;
        }
        return (object = (ParagraphIntrinsicInfo)v0) != null && (object = ((ParagraphIntrinsicInfo)object).getIntrinsics()) != null ? object.getMinIntrinsicWidth() : 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private static final float maxIntrinsicWidth_delegate$lambda$3(MultiParagraphIntrinsics this$0) {
        Object object;
        Object v0;
        List<ParagraphIntrinsicInfo> $this$fastMaxBy$iv = this$0.infoList;
        boolean $i$f$fastMaxBy = false;
        if ($this$fastMaxBy$iv.isEmpty()) {
            v0 = null;
        } else {
            void var3_3;
            ParagraphIntrinsicInfo maxElem$iv;
            ParagraphIntrinsicInfo it = maxElem$iv = $this$fastMaxBy$iv.get(0);
            boolean bl = false;
            float maxValue$iv = it.getIntrinsics().getMaxIntrinsicWidth();
            int i$iv = 1;
            int n = CollectionsKt.getLastIndex($this$fastMaxBy$iv);
            if (i$iv <= n) {
                while (true) {
                    ParagraphIntrinsicInfo e$iv;
                    ParagraphIntrinsicInfo it2 = e$iv = $this$fastMaxBy$iv.get(i$iv);
                    $i$a$-fastMaxBy-MultiParagraphIntrinsics$maxIntrinsicWidth$2$1 = false;
                    float v$iv = it2.getIntrinsics().getMaxIntrinsicWidth();
                    if (Float.compare(maxValue$iv, v$iv) < 0) {
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            v0 = var3_3;
        }
        return (object = (ParagraphIntrinsicInfo)v0) != null && (object = ((ParagraphIntrinsicInfo)object).getIntrinsics()) != null ? object.getMaxIntrinsicWidth() : 0.0f;
    }
}

