/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.MultiParagraphKt;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphInfo;
import androidx.compose.ui.text.ParagraphIntrinsicInfo;
import androidx.compose.ui.text.ParagraphKt;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.text.platform.SkiaMultiParagraphDraw_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nMultiParagraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiParagraph.kt\nandroidx/compose/ui/text/MultiParagraph\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 6 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 7 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,1227:1\n118#2,4:1228\n118#2,4:1261\n118#2,4:1268\n118#2,4:1272\n118#2,4:1276\n530#3,2:1232\n35#3,3:1234\n532#3:1237\n151#3,2:1239\n35#3,5:1241\n153#3:1246\n533#3,2:1247\n39#3:1249\n535#3:1250\n35#3,5:1251\n35#3,5:1256\n1#4:1238\n69#5:1265\n70#6:1266\n22#7:1267\n*S KotlinDebug\n*F\n+ 1 MultiParagraph.kt\nandroidx/compose/ui/text/MultiParagraph\n*L\n389#1:1228,4\n522#1:1261,4\n988#1:1268,4\n994#1:1272,4\n1000#1:1276,4\n455#1:1232,2\n455#1:1234,3\n455#1:1237\n456#1:1239,2\n456#1:1241,5\n456#1:1246\n455#1:1247,2\n455#1:1249\n455#1:1250\n483#1:1251,5\n500#1:1256,5\n564#1:1265\n564#1:1266\n564#1:1267\n*E\n"})
public final class MultiParagraph {
    @NotNull
    private final MultiParagraphIntrinsics intrinsics;
    private final int maxLines;
    private final boolean didExceedMaxLines;
    private final float width;
    private final float height;
    private final int lineCount;
    @NotNull
    private final List<Rect> placeholderRects;
    @NotNull
    private final List<ParagraphInfo> paragraphInfoList;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private MultiParagraph(MultiParagraphIntrinsics intrinsics, long constraints, int maxLines, int overflow) {
        List list2;
        void it;
        void $this$fastFlatMap$iv;
        Intrinsics.checkNotNullParameter((Object)intrinsics, (String)"intrinsics");
        this.intrinsics = intrinsics;
        this.maxLines = maxLines;
        boolean value$iv = Constraints.getMinWidth-impl(constraints) == 0 && Constraints.getMinHeight-impl(constraints) == 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Setting Constraints.minWidth and Constraints.minHeight is not supported, these should be the default zero values instead.");
        }
        float currentHeight = 0.0f;
        int currentLineCount = 0;
        boolean didExceedMaxLines = false;
        List paragraphInfoList = new ArrayList();
        List<ParagraphIntrinsicInfo> infoList = this.intrinsics.getInfoList$ui_text();
        int n = ((Collection)infoList).size();
        for (int index = 0; index < n; ++index) {
            int endLineIndex;
            float paragraphBottom;
            ParagraphIntrinsicInfo paragraphInfo = infoList.get(index);
            Paragraph paragraph = ParagraphKt.Paragraph-czeN-Hc(paragraphInfo.getIntrinsics(), ConstraintsKt.Constraints$default(0, Constraints.getMaxWidth-impl(constraints), 0, Constraints.getHasBoundedHeight-impl(constraints) ? RangesKt.coerceAtLeast((int)(Constraints.getMaxHeight-impl(constraints) - ParagraphKt.ceilToInt(currentHeight)), (int)0) : Constraints.getMaxHeight-impl(constraints), 5, null), this.maxLines - currentLineCount, overflow);
            float paragraphTop = currentHeight;
            currentHeight = paragraphBottom = currentHeight + paragraph.getHeight();
            int startLineIndex = currentLineCount;
            currentLineCount = endLineIndex = startLineIndex + paragraph.getLineCount();
            paragraphInfoList.add(new ParagraphInfo(paragraph, paragraphInfo.getStartIndex(), paragraphInfo.getEndIndex(), startLineIndex, endLineIndex, paragraphTop, paragraphBottom));
            if (!paragraph.getDidExceedMaxLines() && (endLineIndex != this.maxLines || index == CollectionsKt.getLastIndex(this.intrinsics.getInfoList$ui_text()))) continue;
            didExceedMaxLines = true;
            break;
        }
        this.height = currentHeight;
        this.lineCount = currentLineCount;
        this.didExceedMaxLines = didExceedMaxLines;
        this.paragraphInfoList = paragraphInfoList;
        this.width = Constraints.getMaxWidth-impl(constraints);
        List index = paragraphInfoList;
        MultiParagraph multiParagraph = this;
        boolean $i$f$fastFlatMap22 = false;
        ArrayList target$iv = new ArrayList($this$fastFlatMap$iv.size());
        void $this$fastForEach$iv$iv = $this$fastFlatMap$iv;
        boolean $i$f$fastForEach = false;
        int n2 = ((Collection)$this$fastForEach$iv$iv).size();
        for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
            Object item$iv$iv;
            Object e$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl = false;
            ParagraphInfo paragraphInfo = (ParagraphInfo)e$iv;
            boolean bl2 = false;
            ParagraphInfo $this$lambda_u244_u24lambda_u243 = paragraphInfo;
            boolean bl3 = false;
            List<Rect> $this$fastMap$iv = $this$lambda_u244_u24lambda_u243.getParagraph().getPlaceholderRects();
            boolean $i$f$fastMap = false;
            ArrayList target$iv2 = new ArrayList($this$fastMap$iv.size());
            List<Rect> $this$fastForEach$iv$iv2 = $this$fastMap$iv;
            boolean $i$f$fastForEach2 = false;
            int n3 = ((Collection)$this$fastForEach$iv$iv2).size();
            for (int index$iv$iv2 = 0; index$iv$iv2 < n3; ++index$iv$iv2) {
                void it2;
                Rect item$iv$iv2;
                Rect it$iv = item$iv$iv2 = $this$fastForEach$iv$iv2.get(index$iv$iv2);
                boolean bl4 = false;
                Rect rect = it$iv;
                Collection collection = target$iv2;
                boolean bl5 = false;
                void v0 = it2;
                collection.add(v0 != null ? $this$lambda_u244_u24lambda_u243.toGlobal((Rect)v0) : null);
            }
            Iterable list$iv = target$iv2;
            CollectionsKt.addAll((Collection)target$iv, (Iterable)list$iv);
        }
        List $i$f$fastFlatMap22 = target$iv;
        boolean bl = false;
        if (it.size() < this.intrinsics.getPlaceholders().size()) {
            int n4 = this.intrinsics.getPlaceholders().size() - it.size();
            Collection collection = (Collection)it;
            ArrayList<Object> arrayList = new ArrayList<Object>(n4);
            n2 = 0;
            while (n2 < n4) {
                int n5;
                int e$iv = n5 = n2++;
                ArrayList<Object> arrayList2 = arrayList;
                boolean bl6 = false;
                arrayList2.add(null);
            }
            list2 = CollectionsKt.plus((Collection)collection, (Iterable)arrayList);
        } else {
            list2 = it;
        }
        multiParagraph.placeholderRects = list2;
    }

    @NotNull
    public final MultiParagraphIntrinsics getIntrinsics() {
        return this.intrinsics;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    private final AnnotatedString getAnnotatedString() {
        return this.intrinsics.getAnnotatedString();
    }

    public final boolean getDidExceedMaxLines() {
        return this.didExceedMaxLines;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getFirstBaseline() {
        return this.paragraphInfoList.isEmpty() ? 0.0f : this.paragraphInfoList.get(0).getParagraph().getFirstBaseline();
    }

    public final float getLastBaseline() {
        float f;
        if (this.paragraphInfoList.isEmpty()) {
            f = 0.0f;
        } else {
            ParagraphInfo $this$_get_lastBaseline__u24lambda_u240 = (ParagraphInfo)CollectionsKt.last(this.paragraphInfoList);
            boolean bl = false;
            f = $this$_get_lastBaseline__u24lambda_u240.toGlobalYPosition($this$_get_lastBaseline__u24lambda_u240.getParagraph().getLastBaseline());
        }
        return f;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    @NotNull
    public final List<Rect> getPlaceholderRects() {
        return this.placeholderRects;
    }

    @NotNull
    public final List<ParagraphInfo> getParagraphInfoList$ui_text() {
        return this.paragraphInfoList;
    }

    public final void paint-LG529CI(@NotNull Canvas canvas, long color, @Nullable Shadow shadow, @Nullable TextDecoration decoration, @Nullable DrawStyle drawStyle, int blendMode) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        List<ParagraphInfo> $this$fastForEach$iv = this.paragraphInfoList;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            ParagraphInfo item$iv;
            ParagraphInfo it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            it.getParagraph().paint-LG529CI(canvas, color, shadow, decoration, drawStyle, blendMode);
            canvas.translate(0.0f, it.getParagraph().getHeight());
        }
        canvas.restore();
    }

    public static /* synthetic */ void paint-LG529CI$default(MultiParagraph multiParagraph, Canvas canvas, long l, Shadow shadow, TextDecoration textDecoration, DrawStyle drawStyle, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = Color.Companion.getUnspecified-0d7_KjU();
        }
        if ((n2 & 4) != 0) {
            shadow = null;
        }
        if ((n2 & 8) != 0) {
            textDecoration = null;
        }
        if ((n2 & 0x10) != 0) {
            drawStyle = null;
        }
        if ((n2 & 0x20) != 0) {
            n = DrawScope.Companion.getDefaultBlendMode-0nO6VwU();
        }
        multiParagraph.paint-LG529CI(canvas, l, shadow, textDecoration, drawStyle, n);
    }

    public final void paint-hn5TExg(@NotNull Canvas canvas, @NotNull Brush brush, float alpha2, @Nullable Shadow shadow, @Nullable TextDecoration decoration, @Nullable DrawStyle drawStyle, int blendMode) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"brush");
        SkiaMultiParagraphDraw_skikoKt.drawMultiParagraph-7AXcY_I(this, canvas, brush, alpha2, shadow, decoration, drawStyle, blendMode);
    }

    public static /* synthetic */ void paint-hn5TExg$default(MultiParagraph multiParagraph, Canvas canvas, Brush brush, float f, Shadow shadow, TextDecoration textDecoration, DrawStyle drawStyle, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            f = Float.NaN;
        }
        if ((n2 & 8) != 0) {
            shadow = null;
        }
        if ((n2 & 0x10) != 0) {
            textDecoration = null;
        }
        if ((n2 & 0x20) != 0) {
            drawStyle = null;
        }
        if ((n2 & 0x40) != 0) {
            n = DrawScope.Companion.getDefaultBlendMode-0nO6VwU();
        }
        multiParagraph.paint-hn5TExg(canvas, brush, f, shadow, textDecoration, drawStyle, n);
    }

    @NotNull
    public final Path getPathForRange(int start2, int end) {
        boolean value$iv = (0 <= start2 ? start2 <= end : false) && end <= this.getAnnotatedString().getText().length();
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Start(" + start2 + ") or End(" + end + ") is out of range [0.." + this.getAnnotatedString().getText().length() + "), or start > end!");
        }
        if (start2 == end) {
            return SkiaBackedPath_skikoKt.Path();
        }
        Path path2 = SkiaBackedPath_skikoKt.Path();
        MultiParagraphKt.findParagraphsByRange-Sb-Bc2M(this.paragraphInfoList, TextRangeKt.TextRange(start2, end), (Function1<? super ParagraphInfo, Unit>)((Function1)arg_0 -> MultiParagraph.getPathForRange$lambda$11(path2, start2, end, arg_0)));
        return path2;
    }

    public final int getLineForVerticalPosition(float vertical) {
        int paragraphIndex = MultiParagraphKt.findParagraphByY(this.paragraphInfoList, vertical);
        ParagraphInfo $this$getLineForVerticalPosition_u24lambda_u2412 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineForVerticalPosition_u24lambda_u2412.getLength() == 0 ? $this$getLineForVerticalPosition_u24lambda_u2412.getStartLineIndex() : $this$getLineForVerticalPosition_u24lambda_u2412.toGlobalLineIndex($this$getLineForVerticalPosition_u24lambda_u2412.getParagraph().getLineForVerticalPosition($this$getLineForVerticalPosition_u24lambda_u2412.toLocalYPosition(vertical)));
    }

    public final int getOffsetForPosition-k-4lQ0M(long position) {
        boolean bl = false;
        long value$iv$iv = position;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits = false;
        int paragraphIndex = MultiParagraphKt.findParagraphByY(this.paragraphInfoList, Float.intBitsToFloat(bits$iv$iv$iv));
        ParagraphInfo $this$getOffsetForPosition_k_4lQ0M_u24lambda_u2413 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl2 = false;
        return $this$getOffsetForPosition_k_4lQ0M_u24lambda_u2413.getLength() == 0 ? $this$getOffsetForPosition_k_4lQ0M_u24lambda_u2413.getStartIndex() : $this$getOffsetForPosition_k_4lQ0M_u24lambda_u2413.toGlobalIndex($this$getOffsetForPosition_k_4lQ0M_u24lambda_u2413.getParagraph().getOffsetForPosition-k-4lQ0M($this$getOffsetForPosition_k_4lQ0M_u24lambda_u2413.toLocal-MK-Hz9U(position)));
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        this.requireIndexInRange(offset);
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getBoundingBox_u24lambda_u2417 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getBoundingBox_u24lambda_u2417.toGlobal($this$getBoundingBox_u24lambda_u2417.getParagraph().getBoundingBox($this$getBoundingBox_u24lambda_u2417.toLocalIndex(offset)));
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getHorizontalPosition_u24lambda_u2420 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getHorizontalPosition_u24lambda_u2420.getParagraph().getHorizontalPosition($this$getHorizontalPosition_u24lambda_u2420.toLocalIndex(offset), usePrimaryDirection);
    }

    @NotNull
    public final ResolvedTextDirection getParagraphDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getParagraphDirection_u24lambda_u2421 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getParagraphDirection_u24lambda_u2421.getParagraph().getParagraphDirection($this$getParagraphDirection_u24lambda_u2421.toLocalIndex(offset));
    }

    @NotNull
    public final ResolvedTextDirection getBidiRunDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getBidiRunDirection_u24lambda_u2422 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getBidiRunDirection_u24lambda_u2422.getParagraph().getBidiRunDirection($this$getBidiRunDirection_u24lambda_u2422.toLocalIndex(offset));
    }

    public final long getWordBoundary--jx7JFs(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getWordBoundary__jx7JFs_u24lambda_u2423 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getWordBoundary__jx7JFs_u24lambda_u2423.toGlobal-xdX6-G0($this$getWordBoundary__jx7JFs_u24lambda_u2423.getParagraph().getWordBoundary--jx7JFs($this$getWordBoundary__jx7JFs_u24lambda_u2423.toLocalIndex(offset)), false);
    }

    @NotNull
    public final Rect getCursorRect(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getCursorRect_u24lambda_u2424 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getCursorRect_u24lambda_u2424.toGlobal($this$getCursorRect_u24lambda_u2424.getParagraph().getCursorRect($this$getCursorRect_u24lambda_u2424.toLocalIndex(offset)));
    }

    public final int getLineForOffset(int offset) {
        int paragraphIndex = offset >= this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : (offset < 0 ? 0 : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset));
        ParagraphInfo $this$getLineForOffset_u24lambda_u2425 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineForOffset_u24lambda_u2425.toGlobalLineIndex($this$getLineForOffset_u24lambda_u2425.getParagraph().getLineForOffset($this$getLineForOffset_u24lambda_u2425.toLocalIndex(offset)));
    }

    public final float getLineLeft(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineLeft_u24lambda_u2426 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineLeft_u24lambda_u2426.getParagraph().getLineLeft($this$getLineLeft_u24lambda_u2426.toLocalLineIndex(lineIndex));
    }

    public final float getLineRight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineRight_u24lambda_u2427 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineRight_u24lambda_u2427.getParagraph().getLineRight($this$getLineRight_u24lambda_u2427.toLocalLineIndex(lineIndex));
    }

    public final float getLineTop(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineTop_u24lambda_u2428 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineTop_u24lambda_u2428.toGlobalYPosition($this$getLineTop_u24lambda_u2428.getParagraph().getLineTop($this$getLineTop_u24lambda_u2428.toLocalLineIndex(lineIndex)));
    }

    public final float getLineBottom(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineBottom_u24lambda_u2430 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineBottom_u24lambda_u2430.toGlobalYPosition($this$getLineBottom_u24lambda_u2430.getParagraph().getLineBottom($this$getLineBottom_u24lambda_u2430.toLocalLineIndex(lineIndex)));
    }

    public final float getLineHeight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineHeight_u24lambda_u2431 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineHeight_u24lambda_u2431.getParagraph().getLineHeight($this$getLineHeight_u24lambda_u2431.toLocalLineIndex(lineIndex));
    }

    public final int getLineStart(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineStart_u24lambda_u2433 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineStart_u24lambda_u2433.toGlobalIndex($this$getLineStart_u24lambda_u2433.getParagraph().getLineStart($this$getLineStart_u24lambda_u2433.toLocalLineIndex(lineIndex)));
    }

    public final int getLineEnd(int lineIndex, boolean visibleEnd) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineEnd_u24lambda_u2434 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineEnd_u24lambda_u2434.toGlobalIndex($this$getLineEnd_u24lambda_u2434.getParagraph().getLineEnd($this$getLineEnd_u24lambda_u2434.toLocalLineIndex(lineIndex), visibleEnd));
    }

    public static /* synthetic */ int getLineEnd$default(MultiParagraph multiParagraph, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return multiParagraph.getLineEnd(n, bl);
    }

    private final void requireIndexInRange(int offset) {
        boolean value$iv = 0 <= offset ? offset < ((CharSequence)this.getAnnotatedString().getText()).length() : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + offset + ") is out of bounds [0, " + this.getAnnotatedString().length() + ")");
        }
    }

    private final void requireIndexInRangeInclusiveEnd(int offset) {
        boolean value$iv = 0 <= offset ? offset <= this.getAnnotatedString().getText().length() : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + offset + ") is out of bounds [0, " + this.getAnnotatedString().length() + "]");
        }
    }

    private final void requireLineIndexInRange(int lineIndex) {
        boolean value$iv = 0 <= lineIndex ? lineIndex < this.lineCount : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("lineIndex(" + lineIndex + ") is out of bounds [0, " + this.lineCount + ")");
        }
    }

    private static final Unit getPathForRange$lambda$11(Path $path, int $start, int $end, ParagraphInfo paragraphInfo) {
        Intrinsics.checkNotNullParameter((Object)paragraphInfo, (String)"paragraphInfo");
        ParagraphInfo $this$getPathForRange_u24lambda_u2411_u24lambda_u2410 = paragraphInfo;
        boolean bl = false;
        Path.addPath-Uv8p0NA$default($path, $this$getPathForRange_u24lambda_u2411_u24lambda_u2410.toGlobal($this$getPathForRange_u24lambda_u2411_u24lambda_u2410.getParagraph().getPathForRange($this$getPathForRange_u24lambda_u2411_u24lambda_u2410.toLocalIndex($start), $this$getPathForRange_u24lambda_u2411_u24lambda_u2410.toLocalIndex($end))), 0L, 2, null);
        return Unit.INSTANCE;
    }

    public /* synthetic */ MultiParagraph(MultiParagraphIntrinsics intrinsics, long constraints, int maxLines, int overflow, DefaultConstructorMarker $constructor_marker) {
        this(intrinsics, constraints, maxLines, overflow);
    }
}

