/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.spatial;

import androidx.collection.IntObjectMap;
import androidx.collection.IntObjectMapKt;
import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.Actual_jvmKt;
import androidx.compose.ui.Actuals_skikoKt;
import androidx.compose.ui.ComposeUiFlags;
import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.MatrixKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasurePassDelegate;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.spatial.RectList;
import androidx.compose.ui.spatial.RectManagerKt;
import androidx.compose.ui.spatial.ThrottledCallbacks;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.IntSize;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nRectManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n+ 3 RectManager.kt\nandroidx/compose/ui/spatial/RectManagerKt\n+ 4 ObjectList.kt\nandroidx/collection/ObjectList\n+ 5 RectList.kt\nandroidx/compose/ui/spatial/RectList\n+ 6 RectList.kt\nandroidx/compose/ui/spatial/RectListKt\n+ 7 LayoutNode.kt\nandroidx/compose/ui/node/LayoutNode\n+ 8 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 9 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 10 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 11 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 12 IntOffset.kt\nandroidx/compose/ui/unit/IntOffsetKt\n+ 13 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 14 Trace.desktop.kt\nandroidx/compose/ui/util/Trace_jbKt\n*L\n1#1,547:1\n1516#2:548\n544#3:549\n540#3:605\n544#3:606\n287#4,6:550\n725#5,7:556\n732#5,4:564\n736#5,7:569\n835#6:563\n810#6:568\n787#6:608\n787#6:609\n207#7:576\n207#7:591\n424#8,8:577\n424#8,8:592\n54#9:585\n59#9:587\n85#10:586\n90#10:588\n80#10:590\n53#10,3:602\n30#11:589\n159#12:600\n30#13:601\n21#14:607\n*S KotlinDebug\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n*L\n50#1:548\n75#1:549\n425#1:605\n426#1:606\n90#1:550,6\n91#1:556,7\n91#1:564,4\n91#1:569,7\n91#1:563\n91#1:568\n147#1:608\n148#1:609\n213#1:576\n303#1:591\n213#1:577,8\n303#1:592,8\n249#1:585\n250#1:587\n249#1:586\n250#1:588\n288#1:590\n402#1:602,3\n288#1:589\n402#1:600\n402#1:601\n58#1:607\n*E\n"})
public final class RectManager {
    @NotNull
    private final IntObjectMap<LayoutNode> layoutNodes;
    @NotNull
    private final RectList rects;
    @NotNull
    private final ThrottledCallbacks throttledCallbacks;
    @NotNull
    private final MutableObjectList<Function0<Unit>> callbacks;
    private boolean isDirty;
    private boolean isScreenOrWindowDirty;
    private boolean isFragmented;
    @Nullable
    private Object dispatchToken;
    private long scheduledDispatchDeadline;
    @NotNull
    private final Function0<Unit> dispatchLambda;
    @NotNull
    private final MutableRect cachedRect;
    public static final int $stable = 8;

    public RectManager(@NotNull IntObjectMap<LayoutNode> layoutNodes) {
        Intrinsics.checkNotNullParameter(layoutNodes, (String)"layoutNodes");
        this.layoutNodes = layoutNodes;
        this.rects = new RectList();
        this.throttledCallbacks = new ThrottledCallbacks();
        boolean $i$f$mutableObjectListOf = false;
        this.callbacks = new MutableObjectList(0, 1, null);
        this.scheduledDispatchDeadline = -1L;
        this.dispatchLambda = () -> RectManager.dispatchLambda$lambda$1(this);
        this.cachedRect = new MutableRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public /* synthetic */ RectManager(IntObjectMap intObjectMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            intObjectMap = IntObjectMapKt.intObjectMapOf();
        }
        this((IntObjectMap<LayoutNode>)intObjectMap);
    }

    public final void invalidate() {
        this.isDirty = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void dispatchCallbacks() {
        boolean isDispatchGlobalCallbacks;
        long currentTime = Actual_jvmKt.currentTimeMillis();
        boolean bl = isDispatchGlobalCallbacks = this.isDirty || this.isScreenOrWindowDirty;
        if (this.isDirty) {
            this.isDirty = false;
            Object this_$iv = (ObjectList)this.callbacks;
            boolean $i$f$forEach = false;
            Object[] content$iv = this_$iv.content;
            int n = this_$iv._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Function0 it = (Function0)content$iv[i$iv];
                boolean bl2 = false;
                it.invoke();
            }
            this_$iv = this.rects;
            boolean $i$f$forEachUpdatedRect = false;
            long[] items$iv = this_$iv.items;
            int size$iv = this_$iv.itemsSize;
            for (int i$iv = 0; i$iv < items$iv.length - 2 && i$iv < size$iv; i$iv += 3) {
                void bottomRight;
                void topLeft;
                long meta$iv = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaUpdated = false;
                if (((int)(meta$iv >> 61) & 1) == 0) continue;
                long topLeft$iv = items$iv[i$iv + 0];
                long bottomRight$iv = items$iv[i$iv + 1];
                boolean $i$f$unpackMetaValue = false;
                long l = bottomRight$iv;
                long l2 = topLeft$iv;
                int id = (int)meta$iv & 0x3FFFFFF;
                boolean bl3 = false;
                this.throttledCallbacks.fireOnUpdatedRect(id, (long)topLeft, (long)bottomRight, currentTime);
            }
            this.rects.clearUpdated();
        }
        if (this.isScreenOrWindowDirty) {
            this.isScreenOrWindowDirty = false;
            this.throttledCallbacks.fireOnRectChangedEntries(currentTime);
        }
        if (isDispatchGlobalCallbacks) {
            this.throttledCallbacks.fireGlobalChangeEntries(currentTime);
        }
        if (this.isFragmented) {
            this.isFragmented = false;
            this.rects.defragment();
        }
        this.throttledCallbacks.triggerDebounced(currentTime);
    }

    public final void scheduleDebounceCallback(boolean ensureSomethingScheduled) {
        long deadline;
        boolean canExitEarly = !ensureSomethingScheduled || this.dispatchToken != null;
        long nextDeadline = this.throttledCallbacks.getMinDebounceDeadline();
        if (nextDeadline < 0L && canExitEarly) {
            return;
        }
        long currentScheduledDeadline = this.scheduledDispatchDeadline;
        if (currentScheduledDeadline == nextDeadline && canExitEarly) {
            return;
        }
        if (this.dispatchToken != null) {
            Actuals_skikoKt.removePost(this.dispatchToken);
        }
        long currentTime = Actual_jvmKt.currentTimeMillis();
        long nextFrameIsh = currentTime + (long)16;
        this.scheduledDispatchDeadline = deadline = Math.max(nextDeadline, nextFrameIsh);
        long delay = deadline - currentTime;
        this.dispatchToken = Actuals_skikoKt.postDelayed(delay, this.dispatchLambda);
    }

    public final void invalidateCallbacksFor(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this.isDirty = true;
        this.rects.markUpdated(layoutNode.getSemanticsId());
        this.scheduleDebounceCallback(true);
    }

    public final void onLayoutLayerPositionalPropertiesChanged(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        long outerToInnerOffset = this.outerToInnerOffset-Bjo55l4(layoutNode);
        if (RectManagerKt.access$isSet--gyyYBs(outerToInnerOffset)) {
            layoutNode.setOuterToInnerOffset--gyyYBs$ui(outerToInnerOffset);
            layoutNode.setOuterToInnerOffsetDirty$ui(false);
            LayoutNode this_$iv = layoutNode;
            boolean $i$f$forEachChild = false;
            MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
            boolean $i$f$forEach = false;
            T[] content$iv$iv = this_$iv$iv.content;
            int size$iv$iv = this_$iv$iv.getSize();
            for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
                boolean bl = false;
                this.onLayoutPositionChanged-70tqf50(it, it.getOuterCoordinator$ui().getPosition-nOcc-ac(), false);
            }
            this.invalidateCallbacksFor(layoutNode);
        } else {
            this.insertOrUpdateTransformedNodeSubhierarchy(layoutNode);
        }
    }

    public final void onLayoutPositionChanged-70tqf50(@NotNull LayoutNode layoutNode, long position, boolean firstPlacement) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        MeasurePassDelegate delegate = layoutNode.getMeasurePassDelegate$ui();
        int width = delegate.getMeasuredWidth();
        int height = delegate.getMeasuredHeight();
        LayoutNode parent = layoutNode.getParent$ui();
        long offset = 0L;
        long lastOffset = layoutNode.getOffsetFromRoot-nOcc-ac$ui();
        long lastSize = layoutNode.getLastSize-YbymL2g$ui();
        boolean bl = false;
        long value$iv$iv = lastSize;
        boolean $i$f$unpackInt1 = false;
        int lastWidth = (int)(value$iv$iv >> 32);
        boolean bl2 = false;
        long value$iv$iv2 = lastSize;
        boolean $i$f$unpackInt2 = false;
        int lastHeight = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean hasNonTranslationTransformations = false;
        if (parent != null) {
            long l;
            boolean parentOffsetDirty = parent.getOuterToInnerOffsetDirty$ui();
            long parentOffset = parent.getOffsetFromRoot-nOcc-ac$ui();
            long prevOuterToInnerOffset = parent.getOuterToInnerOffset-nOcc-ac$ui();
            if (RectManagerKt.access$isSet--gyyYBs(parentOffset)) {
                long l2;
                if (parentOffsetDirty) {
                    long it = this.outerToInnerOffset-Bjo55l4(parent);
                    parent.setOuterToInnerOffset--gyyYBs$ui(it);
                    parent.setOuterToInnerOffsetDirty$ui(false);
                    l2 = it;
                } else {
                    l2 = prevOuterToInnerOffset;
                }
                long parentOuterInnerOffset = l2;
                hasNonTranslationTransformations = !RectManagerKt.access$isSet--gyyYBs(parentOuterInnerOffset);
                l = IntOffset.plus-qkQi6aY(IntOffset.plus-qkQi6aY(parentOffset, parentOuterInnerOffset), position);
            } else {
                l = this.positionInRoot-Bjo55l4(layoutNode.getOuterCoordinator$ui());
            }
            offset = l;
        } else {
            offset = position;
        }
        if (hasNonTranslationTransformations || !RectManagerKt.access$isSet--gyyYBs(offset)) {
            this.insertOrUpdateTransformedNode-70tqf50(layoutNode, position, firstPlacement);
            return;
        }
        layoutNode.setOffsetFromRoot--gyyYBs$ui(offset);
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        layoutNode.setLastSize-ozmzZPI$ui(IntSize.constructor-impl((long)width << 32 | (long)height & 0xFFFFFFFFL));
        int l = IntOffset.getX-impl(offset);
        int t2 = IntOffset.getY-impl(offset);
        int r = l + width;
        int b = t2 + height;
        if (!firstPlacement && IntOffset.equals-impl0(offset, lastOffset) && lastWidth == width && lastHeight == height) {
            return;
        }
        this.insertOrUpdate(layoutNode, firstPlacement, l, t2, r, b);
    }

    private final void insertOrUpdateTransformedNodeSubhierarchy(LayoutNode layoutNode) {
        LayoutNode this_$iv = layoutNode;
        boolean $i$f$forEachChild = false;
        MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
        boolean $i$f$forEach = false;
        T[] content$iv$iv = this_$iv$iv.content;
        int size$iv$iv = this_$iv$iv.getSize();
        for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
            LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
            boolean bl = false;
            this.insertOrUpdateTransformedNode-70tqf50(it, it.getOuterCoordinator$ui().getPosition-nOcc-ac(), false);
            this.insertOrUpdateTransformedNodeSubhierarchy(it);
        }
    }

    private final void insertOrUpdateTransformedNode-70tqf50(LayoutNode layoutNode, long position, boolean firstPlacement) {
        NodeCoordinator coord = layoutNode.getOuterCoordinator$ui();
        MeasurePassDelegate delegate = layoutNode.getMeasurePassDelegate$ui();
        int width = delegate.getMeasuredWidth();
        int height = delegate.getMeasuredHeight();
        MutableRect rect = this.cachedRect;
        rect.set(IntOffset.getX-impl(position), IntOffset.getY-impl(position), IntOffset.getX-impl(position) + width, IntOffset.getY-impl(position) + height);
        this.boundingRectInRoot(coord, rect);
        int l = (int)rect.getLeft();
        int t2 = (int)rect.getTop();
        int r = (int)rect.getRight();
        int b = (int)rect.getBottom();
        int id = layoutNode.getSemanticsId();
        if (firstPlacement || !this.rects.update(id, l, t2, r, b)) {
            LayoutNode layoutNode2 = layoutNode.getParent$ui();
            int parentId = layoutNode2 != null ? layoutNode2.getSemanticsId() : -1;
            RectList.insert$default(this.rects, id, l, t2, r, b, parentId, false, false, 192, null);
        }
        this.invalidate();
    }

    private final void insertOrUpdate(LayoutNode layoutNode, boolean firstPlacement, int l, int t2, int r, int b) {
        int id = layoutNode.getSemanticsId();
        if (firstPlacement || !this.rects.move(id, l, t2, r, b)) {
            LayoutNode layoutNode2 = layoutNode.getParent$ui();
            int parentId = layoutNode2 != null ? layoutNode2.getSemanticsId() : -1;
            RectList.insert$default(this.rects, id, l, t2, r, b, parentId, false, false, 192, null);
        }
        this.invalidate();
    }

    private final long positionInRoot-Bjo55l4(NodeCoordinator $this$positionInRoot_u2dBjo55l4) {
        long position = Offset.Companion.getZero-F1C5BW0();
        for (NodeCoordinator coordinator = $this$positionInRoot_u2dBjo55l4; coordinator != null; coordinator = coordinator.getWrappedBy$ui()) {
            boolean hasNonTranslationComponents;
            float[] matrix;
            int analysis;
            OwnedLayer layer = coordinator.getLayer();
            position = IntOffsetKt.plus-Nv-tHpc(position, coordinator.getPosition-nOcc-ac());
            if (layer == null || (analysis = RectManagerKt.access$analyzeComponents-58bKbWc(matrix = layer.getUnderlyingMatrix-sQKQjiQ())) == 3) continue;
            boolean bl = hasNonTranslationComponents = (analysis & 2) == 0;
            if (hasNonTranslationComponents) {
                return IntOffset.Companion.getMax-nOcc-ac();
            }
            position = Matrix.map-MK-Hz9U(matrix, position);
        }
        return IntOffsetKt.round-k-4lQ0M(position);
    }

    /*
     * WARNING - void declaration
     */
    private final void boundingRectInRoot(NodeCoordinator $this$boundingRectInRoot, MutableRect rect) {
        for (NodeCoordinator coordinator = $this$boundingRectInRoot; coordinator != null; coordinator = coordinator.getWrappedBy$ui()) {
            float[] matrix;
            void x$iv$iv;
            OwnedLayer layer = coordinator.getLayer();
            long $this$toOffset_u2d_u2dgyyYBs$iv = coordinator.getPosition-nOcc-ac();
            boolean bl = false;
            float f = IntOffset.getX-impl($this$toOffset_u2d_u2dgyyYBs$iv);
            float y$iv$iv = IntOffset.getY-impl($this$toOffset_u2d_u2dgyyYBs$iv);
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv$iv = Float.floatToRawIntBits((float)x$iv$iv);
            long v2$iv$iv$iv = Float.floatToRawIntBits(y$iv$iv);
            rect.translate-k-4lQ0M(Offset.constructor-impl(v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL));
            if (layer == null || MatrixKt.isIdentity-58bKbWc(matrix = layer.getUnderlyingMatrix-sQKQjiQ())) continue;
            Matrix.map-impl(matrix, rect);
        }
    }

    private final long outerToInnerOffset-Bjo55l4(LayoutNode $this$outerToInnerOffset_u2dBjo55l4) {
        NodeCoordinator terminator = $this$outerToInnerOffset_u2dBjo55l4.getOuterCoordinator$ui();
        long position = Offset.Companion.getZero-F1C5BW0();
        for (NodeCoordinator coordinator = $this$outerToInnerOffset_u2dBjo55l4.getInnerCoordinator$ui(); coordinator != null && coordinator != terminator; coordinator = coordinator.getWrappedBy$ui()) {
            int analysis;
            OwnedLayer layer = coordinator.getLayer();
            position = IntOffsetKt.plus-Nv-tHpc(position, coordinator.getPosition-nOcc-ac());
            if (layer == null) continue;
            float[] matrix = layer.getUnderlyingMatrix-sQKQjiQ();
            int $this$isIdentity$iv = analysis = RectManagerKt.access$analyzeComponents-58bKbWc(matrix);
            boolean $i$f$isIdentity = false;
            if ($this$isIdentity$iv == 3) continue;
            int $this$hasNonTranslationComponents$iv = analysis;
            boolean $i$f$getHasNonTranslationComponents = false;
            if (($this$hasNonTranslationComponents$iv & 2) == 0) {
                return IntOffset.Companion.getMax-nOcc-ac();
            }
            position = Matrix.map-MK-Hz9U(matrix, position);
        }
        return IntOffsetKt.round-k-4lQ0M(position);
    }

    private static final Unit dispatchLambda$lambda$1(RectManager this$0) {
        this$0.dispatchToken = null;
        String sectionName$iv = "OnPositionedDispatch";
        boolean $i$f$trace = false;
        boolean bl = false;
        this$0.dispatchCallbacks();
        return Unit.INSTANCE;
    }

    public RectManager() {
        this(null, 1, null);
    }
}

