/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessibleKt;
import androidx.compose.ui.platform.a11y.ProgressBarAccessibleValue;
import androidx.compose.ui.platform.a11y.RadioButtonAccessibleValue;
import androidx.compose.ui.platform.a11y.ToggleableAccessibleValue;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.accessibility.AccessibleValue;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skiko.HardwareLayerKt;

public final class ComposeAccessible
extends Component
implements Accessible {
    @NotNull
    private final AccessibilityController controller;
    @NotNull
    private SemanticsNode semanticsNode;
    @Nullable
    private SemanticsConfiguration cachedSemanticsConfig;
    private volatile /* synthetic */ int isNativelyInitialized$volatile;
    @NotNull
    private final Lazy composeAccessibleContext$delegate;
    private boolean removed;
    private static final /* synthetic */ AtomicIntegerFieldUpdater isNativelyInitialized$volatile$FU;
    public static final int $stable;

    public ComposeAccessible(@NotNull SemanticsNode semanticsNode, @NotNull AccessibilityController controller) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"semanticsNode");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = controller;
        this.semanticsNode = semanticsNode;
        this.composeAccessibleContext$delegate = LazyKt.lazy(() -> ComposeAccessible.composeAccessibleContext_delegate$lambda$1(this));
    }

    @NotNull
    public final SemanticsNode getSemanticsNode() {
        return this.semanticsNode;
    }

    public final void setSemanticsNode(@NotNull SemanticsNode value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.semanticsNode = value2;
        this.cachedSemanticsConfig = null;
    }

    private final SemanticsConfiguration getSemanticsConfig() {
        SemanticsConfiguration semanticsConfiguration = this.cachedSemanticsConfig;
        if (semanticsConfiguration == null) {
            SemanticsConfiguration semanticsConfiguration2;
            SemanticsConfiguration it = semanticsConfiguration2 = this.semanticsNode.getConfig();
            boolean bl = false;
            this.cachedSemanticsConfig = it;
            semanticsConfiguration = semanticsConfiguration2;
        }
        return semanticsConfiguration;
    }

    @NotNull
    public final ComposeAccessibleComponent getComposeAccessibleContext() {
        Lazy lazy = this.composeAccessibleContext$delegate;
        return (ComposeAccessibleComponent)lazy.getValue();
    }

    public final void setRemoved(boolean bl) {
        this.removed = bl;
    }

    @Override
    @Nullable
    public AccessibleContext getAccessibleContext() {
        if (this.removed) {
            return null;
        }
        if (ComposeAccessible.isNativelyInitialized$volatile$FU.compareAndSet(this, 0, 1)) {
            HardwareLayerKt.nativeInitializeAccessible((Accessible)this);
        }
        return this.getComposeAccessibleContext();
    }

    private static final ComposeAccessibleComponent composeAccessibleContext_delegate$lambda$1(ComposeAccessible this$0) {
        return this$0.new ComposeAccessibleComponent();
    }

    static {
        isNativelyInitialized$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(ComposeAccessible.class, "isNativelyInitialized$volatile");
        $stable = 8;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Rect.kt\nandroidx/compose/ui/geometry/Rect\n+ 6 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 7 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 8 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 9 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 10 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n*L\n1#1,935:1\n113#2:936\n30#3:937\n53#4,3:938\n60#4:944\n70#4:947\n85#4:950\n90#4:952\n56#5:941\n61#5:942\n65#6:943\n69#6:946\n22#7:945\n22#7:948\n54#8:949\n59#8:951\n360#9,7:953\n91#10:960\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n*L\n224#1:936\n224#1:937\n224#1:938,3\n241#1:944\n242#1:947\n248#1:950\n249#1:952\n234#1:941\n235#1:942\n241#1:943\n242#1:946\n241#1:945\n242#1:948\n248#1:949\n249#1:951\n330#1:953,7\n367#1:960\n*E\n"})
    public class ComposeAccessibleComponent
    extends AccessibleContext
    implements AccessibleAction,
    AccessibleComponent {
        @Nullable
        private AccessibleAction accessibleAction;
        @NotNull
        private final Lazy accessibleText$delegate = LazyKt.lazy(() -> ComposeAccessibleComponent.accessibleText_delegate$lambda$13(this));

        @Nullable
        public final TextRange getTextSelectionRange-MzsxiRA() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getTextSelectionRange());
        }

        @Nullable
        public final AccessibilityAction<Function1<AnnotatedString, Boolean>> getSetText() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetText());
        }

        @Nullable
        public final AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> getSetSelection() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetSelection());
        }

        @Nullable
        public final AnnotatedString getText() {
            AnnotatedString annotatedString = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getEditableText());
            if (annotatedString == null) {
                annotatedString = (AnnotatedString)ComposeAccessibleKt.access$getFirstOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getText());
            }
            return annotatedString;
        }

        @Nullable
        public final TextLayoutResult getTextLayoutResult() {
            Function1<List<TextLayoutResult>, Boolean> function1;
            List textLayoutResults = new ArrayList();
            AccessibilityAction<Function1<List<TextLayoutResult>, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getGetTextLayoutResult());
            Boolean getLayoutResult = accessibilityAction != null && (function1 = accessibilityAction.getAction()) != null ? (Boolean)function1.invoke((Object)textLayoutResults) : null;
            return Intrinsics.areEqual(getLayoutResult, (Object)true) ? (TextLayoutResult)textLayoutResults.get(0) : null;
        }

        @Nullable
        public final Boolean getFocused() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getFocused());
        }

        @Nullable
        public final Boolean getSelected() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getSelected());
        }

        private final Density getDensity() {
            return ComposeAccessible.this.controller.getDesktopComponent().getDensity();
        }

        @Nullable
        public final ScrollAxisRange getHorizontalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        }

        @Nullable
        public final ScrollAxisRange getVerticalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        }

        @Nullable
        public final AccessibilityAction<Function2<Float, Float, Boolean>> getScrollBy() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getScrollBy());
        }

        public final boolean isPassword() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getPassword()) != null;
        }

        @Nullable
        public final ToggleableState getToggleableState() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getToggleableState());
        }

        @NotNull
        public final List<Accessible> getAuxiliaryChildren() {
            List list2;
            block1: {
                ScrollAxisRange it;
                List $this$_get_auxiliaryChildren__u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                ScrollAxisRange scrollAxisRange = this.getHorizontalScroll();
                if (scrollAxisRange != null) {
                    it = scrollAxisRange;
                    boolean bl2 = false;
                    $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(false));
                }
                ScrollAxisRange scrollAxisRange2 = this.getVerticalScroll();
                if (scrollAxisRange2 == null) break block1;
                it = scrollAxisRange2;
                boolean bl3 = false;
                $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(true));
            }
            return CollectionsKt.build((List)list2);
        }

        @Nullable
        public final ProgressBarRangeInfo getProgressBarRangeInfo() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getProgressBarRangeInfo());
        }

        @Nullable
        public final Boolean isContainer() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsContainer());
        }

        @Nullable
        public final Boolean isTraversalGroup() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsTraversalGroup());
        }

        private final Accessible makeScrollbarChild(boolean vertical) {
            ScrollBarAccessible bar = new ScrollBarAccessible(vertical);
            AccessibleRelation controlledBy = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, bar);
            AccessibleRelation controllerFor = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, ComposeAccessible.this);
            bar.getContext().getAccessibleRelationSet().add(controllerFor);
            this.getAccessibleRelationSet().add(controlledBy);
            return bar;
        }

        /*
         * WARNING - void declaration
         */
        private final long toComposeOffset-tuRUvjQ(Point $this$toComposeOffset_u2dtuRUvjQ) {
            void x$iv;
            Density $this$toComposeOffset_tuRUvjQ_u24lambda_u243 = this.getDensity();
            boolean bl = false;
            int $this$dp$iv22 = $this$toComposeOffset_u2dtuRUvjQ.x;
            boolean $i$f$getDp = false;
            float $this$dp$iv22 = $this$toComposeOffset_tuRUvjQ_u24lambda_u243.toPx-0680j_4(Dp.constructor-impl($this$dp$iv22));
            int $this$dp$iv = $this$toComposeOffset_u2dtuRUvjQ.y;
            boolean $i$f$getDp2 = false;
            float y$iv = $this$toComposeOffset_tuRUvjQ_u24lambda_u243.toPx-0680j_4(Dp.constructor-impl($this$dp$iv));
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            return Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
        }

        private final int toAwtPx-0680j_4(float $this$toAwtPx_u2d0680j_4) {
            return Float.isInfinite($this$toAwtPx_u2d0680j_4) ? Integer.MAX_VALUE : MathKt.roundToInt((float)$this$toAwtPx_u2d0680j_4);
        }

        private final Rectangle toAwtRectangle(Rect $this$toAwtRectangle) {
            Density $this$toAwtRectangle_u24lambda_u244 = this.getDensity();
            boolean bl = false;
            Rect this_$iv = $this$toAwtRectangle;
            boolean $i$f$getWidth = false;
            int n = this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM(this_$iv.getRight() - this_$iv.getLeft()));
            this_$iv = $this$toAwtRectangle;
            boolean $i$f$getHeight = false;
            return new Rectangle(this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getLeft())), this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getTop())), n, this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM(this_$iv.getBottom() - this_$iv.getTop())));
        }

        private final Point toAwtPoint-k-4lQ0M(long $this$toAwtPoint_u2dk_u2d4lQ0M) {
            Density $this$toAwtPoint_k_4lQ0M_u24lambda_u245 = this.getDensity();
            boolean bl = false;
            boolean bl2 = false;
            long value$iv$iv = $this$toAwtPoint_u2dk_u2d4lQ0M;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            int n = this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Float.intBitsToFloat(bits$iv$iv$iv)));
            boolean bl3 = false;
            value$iv$iv = $this$toAwtPoint_u2dk_u2d4lQ0M;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            return new Point(n, this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Float.intBitsToFloat(bits$iv$iv$iv))));
        }

        private final Dimension toAwtDimension-ozmzZPI(long $this$toAwtDimension_u2dozmzZPI) {
            Density $this$toAwtDimension_ozmzZPI_u24lambda_u246 = this.getDensity();
            boolean bl = false;
            boolean bl2 = false;
            long value$iv$iv = $this$toAwtDimension_u2dozmzZPI;
            boolean $i$f$unpackInt1 = false;
            int n = this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM((int)(value$iv$iv >> 32)));
            boolean bl3 = false;
            value$iv$iv = $this$toAwtDimension_u2dozmzZPI;
            boolean $i$f$unpackInt2 = false;
            return new Dimension(n, this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM((int)(value$iv$iv & 0xFFFFFFFFL))));
        }

        @Override
        @Nullable
        public String getAccessibleName() {
            AnnotatedString annotatedString = this.getText();
            return annotatedString != null ? annotatedString.toString() : null;
        }

        @Override
        @Nullable
        public String getAccessibleDescription() {
            return (String)ComposeAccessibleKt.access$getFirstOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getContentDescription());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @Nullable
        public Accessible getAccessibleParent() {
            Accessible accessible;
            Object object = ComposeAccessible.this.getSemanticsNode().getParent();
            if (object != null) {
                int n = ((SemanticsNode)object).getId();
                ComposeAccessible composeAccessible = ComposeAccessible.this;
                int id = n;
                boolean bl = false;
                ComposeAccessible composeAccessible2 = composeAccessible.controller.accessibleByNodeId(id);
                Intrinsics.checkNotNull((Object)composeAccessible2);
                object = composeAccessible2;
                if (composeAccessible2 != null) {
                    accessible = (Accessible)object;
                    return accessible;
                }
            }
            accessible = this.accessibleParent;
            return accessible;
        }

        @Override
        @Nullable
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        @Nullable
        public AccessibleAction getAccessibleAction() {
            List actions2 = new ArrayList();
            AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getOnClick());
            if (accessibilityAction != null) {
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                boolean bl = false;
                actions2.add(new Pair((Object)"click", SemanticsActions.INSTANCE.getOnClick()));
            }
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions2, SemanticsActions.INSTANCE.getOnLongClick());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions2, SemanticsActions.INSTANCE.getExpand());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions2, SemanticsActions.INSTANCE.getCollapse());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions2, SemanticsActions.INSTANCE.getDismiss());
            if (actions2.isEmpty()) {
                return null;
            }
            this.accessibleAction = new AccessibleAction(actions2, ComposeAccessible.this){
                final /* synthetic */ List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> $actions;
                final /* synthetic */ ComposeAccessible this$0;
                {
                    this.$actions = $actions;
                    this.this$0 = $receiver;
                }

                public int getAccessibleActionCount() {
                    return this.$actions.size();
                }

                public String getAccessibleActionDescription(int i2) {
                    String label = (String)this.$actions.get(i2).component1();
                    return label;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean doAccessibleAction(int i2) {
                    SemanticsPropertyKey actionKey = (SemanticsPropertyKey)this.$actions.get(i2).component2();
                    AccessibilityAction accessibilityAction = (AccessibilityAction)SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), actionKey);
                    Object object = accessibilityAction;
                    if (accessibilityAction == null) return false;
                    AccessibilityAction it = object;
                    boolean bl = false;
                    Function0 function0 = (Function0)it.getAction();
                    if (function0 == null) return false;
                    Boolean bl2 = (Boolean)function0.invoke();
                    object = bl2;
                    if (bl2 == null) return false;
                    boolean bl3 = (Boolean)object;
                    return bl3;
                }
            };
            return this.accessibleAction;
        }

        @Override
        @Nullable
        public AccessibleValue getAccessibleValue() {
            AccessibleValue accessibleValue;
            Role role = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            if (this.getToggleableState() != null) {
                accessibleValue = new ToggleableAccessibleValue(this);
            } else {
                int n = Role.Companion.getRadioButton-o7Vup1c();
                Role role2 = role;
                accessibleValue = (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n)) ? (AccessibleValue)new RadioButtonAccessibleValue(this) : (this.getProgressBarRangeInfo() != null ? (AccessibleValue)new ProgressBarAccessibleValue(this) : null);
            }
            return accessibleValue;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getAccessibleIndexInParent() {
            int n;
            block4: {
                List<SemanticsNode> parentChildren;
                SemanticsNode semanticsNode = ComposeAccessible.this.getSemanticsNode().getParent();
                List<SemanticsNode> list2 = parentChildren = semanticsNode != null ? semanticsNode.getReplacedChildren$ui() : null;
                if (list2 != null) {
                    void $this$indexOfFirst$iv;
                    List<SemanticsNode> list3 = list2;
                    ComposeAccessible composeAccessible = ComposeAccessible.this;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        SemanticsNode it = (SemanticsNode)item$iv;
                        boolean bl = false;
                        if (it.getId() == composeAccessible.getSemanticsNode().getId()) {
                            n = index$iv;
                            break block4;
                        }
                        ++index$iv;
                    }
                    n = -1;
                } else {
                    n = -1;
                }
            }
            return n;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return ComposeAccessible.this.getSemanticsNode().getReplacedChildren$ui().size() + this.getAuxiliaryChildren().size();
        }

        @Override
        @Nullable
        public Accessible getAccessibleChild(int i2) {
            List<SemanticsNode> replacedChildren = ComposeAccessible.this.getSemanticsNode().getReplacedChildren$ui();
            int replacedChildrenSize = replacedChildren.size();
            return i2 < replacedChildrenSize ? (Accessible)ComposeAccessible.this.controller.accessibleByNodeId(replacedChildren.get(i2).getId()) : this.getAuxiliaryChildren().get(i2 - replacedChildrenSize);
        }

        @Override
        @NotNull
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            return locale;
        }

        @Override
        @NotNull
        public Point getLocationOnScreen() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionOnScreen-F1C5BW0());
        }

        @Override
        @NotNull
        public Point getLocation() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionInRoot-F1C5BW0());
        }

        @Override
        @NotNull
        public Rectangle getBounds() {
            return this.toAwtRectangle(ComposeAccessible.this.getSemanticsNode().getBoundsInRoot());
        }

        @Override
        @NotNull
        public Dimension getSize() {
            return this.toAwtDimension-ozmzZPI(ComposeAccessible.this.getSemanticsNode().getSize-YbymL2g());
        }

        @Override
        public boolean isVisible() {
            boolean bl = false;
            return !DelegatableNodeKt.requireCoordinator-64DMado(ComposeAccessible.this.getSemanticsNode().getOuterSemanticsNode$ui(), NodeKind.constructor-impl(8)).isTransparent() && !ComposeAccessible.this.getSemanticsConfig().contains(SemanticsProperties.INSTANCE.getInvisibleToUser()) && !ComposeAccessible.this.getSemanticsConfig().contains(SemanticsProperties.INSTANCE.getHideFromAccessibility());
        }

        @Override
        public boolean isEnabled() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean contains(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.getBounds().contains(p);
        }

        @Override
        @Nullable
        public Accessible getAccessibleAt(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            int n = this.getAccessibleChildrenCount();
            for (int i2 = 0; i2 < n; ++i2) {
                AccessibleComponent child2;
                Accessible accessible = this.getAccessibleChild(i2);
                Object object = accessible != null ? accessible.getAccessibleContext() : null;
                AccessibleComponent accessibleComponent = child2 = object instanceof AccessibleComponent ? (AccessibleComponent)object : null;
                if (child2 == null || (object = child2.getAccessibleAt(p)) == null) continue;
                Object it = object;
                boolean bl = false;
                return it;
            }
            if (this.contains(p)) {
                return ComposeAccessible.this;
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return this.getFocused() != null;
        }

        @Override
        public void requestFocus() {
            Function0<Boolean> function0;
            AccessibilityAction<Function0<Boolean>> accessibilityAction;
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)false) && (accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsNode().getUnmergedConfig$ui(), SemanticsActions.INSTANCE.getRequestFocus())) != null && (function0 = accessibilityAction.getAction()) != null) {
                Boolean cfr_ignored_0 = (Boolean)function0.invoke();
            }
        }

        @Override
        public void addFocusListener(@Nullable FocusListener l) {
            System.out.println((Object)"Not implemented: addFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void removeFocusListener(@Nullable FocusListener l) {
            System.out.println((Object)"Not implemented: removeFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole;
            AccessibilityController.AccessibilityUsage.INSTANCE.notifyInUse();
            Role role = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            int n = Role.Companion.getButton-o7Vup1c();
            Role role2 = role;
            if (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n)) {
                accessibleRole = AccessibleRole.PUSH_BUTTON;
            } else {
                n = Role.Companion.getCheckbox-o7Vup1c();
                Role role3 = role;
                if (role3 == null ? false : Role.equals-impl0(role3.unbox-impl(), n)) {
                    accessibleRole = AccessibleRole.CHECK_BOX;
                } else {
                    n = Role.Companion.getRadioButton-o7Vup1c();
                    Role role4 = role;
                    if (role4 == null ? false : Role.equals-impl0(role4.unbox-impl(), n)) {
                        accessibleRole = AccessibleRole.RADIO_BUTTON;
                    } else {
                        n = Role.Companion.getTab-o7Vup1c();
                        Role role5 = role;
                        if (role5 == null ? false : Role.equals-impl0(role5.unbox-impl(), n)) {
                            accessibleRole = AccessibleRole.PAGE_TAB;
                        } else {
                            n = Role.Companion.getDropdownList-o7Vup1c();
                            Role role6 = role;
                            accessibleRole = (role6 == null ? false : Role.equals-impl0(role6.unbox-impl(), n)) ? AccessibleRole.COMBO_BOX : null;
                        }
                    }
                }
            }
            AccessibleRole fromSemanticRole = accessibleRole;
            AccessibleRole accessibleRole2 = fromSemanticRole;
            if (accessibleRole2 == null) {
                if (this.isPassword()) {
                    AccessibleRole accessibleRole3 = AccessibleRole.PASSWORD_TEXT;
                    accessibleRole2 = accessibleRole3;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole3, (String)"PASSWORD_TEXT");
                } else if (this.getScrollBy() != null) {
                    AccessibleRole accessibleRole4 = AccessibleRole.SCROLL_PANE;
                    accessibleRole2 = accessibleRole4;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole4, (String)"SCROLL_PANE");
                } else if (this.getSetText() != null) {
                    AccessibleRole accessibleRole5 = AccessibleRole.TEXT;
                    accessibleRole2 = accessibleRole5;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole5, (String)"TEXT");
                } else if (this.getText() != null) {
                    AccessibleRole accessibleRole6 = AccessibleRole.LABEL;
                    accessibleRole2 = accessibleRole6;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole6, (String)"LABEL");
                } else if (this.getProgressBarRangeInfo() != null) {
                    AccessibleRole accessibleRole7 = AccessibleRole.PROGRESS_BAR;
                    accessibleRole2 = accessibleRole7;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole7, (String)"PROGRESS_BAR");
                } else if (this.isContainer() != null) {
                    AccessibleRole accessibleRole8 = AccessibleRole.GROUP_BOX;
                    accessibleRole2 = accessibleRole8;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole8, (String)"GROUP_BOX");
                } else if (this.isTraversalGroup() != null) {
                    AccessibleRole accessibleRole9 = AccessibleRole.GROUP_BOX;
                    accessibleRole2 = accessibleRole9;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole9, (String)"GROUP_BOX");
                } else {
                    AccessibleRole accessibleRole10 = AccessibleRole.UNKNOWN;
                    accessibleRole2 = accessibleRole10;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole10, (String)"UNKNOWN");
                }
            }
            return accessibleRole2;
        }

        @Override
        @NotNull
        public AccessibleStateSet getAccessibleStateSet() {
            boolean canCollapse;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            ComposeAccessible composeAccessible = ComposeAccessible.this;
            AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u2412 = accessibleStateSet;
            boolean bl = false;
            if (this.isEnabled()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.ENABLED);
            }
            if (this.isShowing()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.VISIBLE);
            }
            if (this.isFocusTraversable()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSABLE);
            }
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)true)) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSED);
            }
            boolean canExpand = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsActions.INSTANCE.getExpand()) != null;
            boolean bl2 = canCollapse = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsActions.INSTANCE.getCollapse()) != null;
            if (canExpand || canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDABLE);
            }
            if (canExpand) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.COLLAPSED);
            }
            if (canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDED);
            }
            Role role = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            int n = Role.Companion.getCheckbox-o7Vup1c();
            Role role2 = role;
            if (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n)) {
                this.addCheckedStateForCheckbox($this$getAccessibleStateSet_u24lambda_u2412);
            } else {
                n = Role.Companion.getRadioButton-o7Vup1c();
                Role role3 = role;
                if (role3 == null ? false : Role.equals-impl0(role3.unbox-impl(), n)) {
                    this.addCheckedStateForRadioButton($this$getAccessibleStateSet_u24lambda_u2412);
                } else {
                    this.addDefaultStateForToggleableState($this$getAccessibleStateSet_u24lambda_u2412);
                    if (this.getSelected() != null) {
                        $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SELECTABLE);
                    }
                    if (Intrinsics.areEqual((Object)this.getSelected(), (Object)true)) {
                        $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SELECTED);
                    }
                }
            }
            return accessibleStateSet;
        }

        private final void addCheckedStateForCheckbox(AccessibleStateSet $this$addCheckedStateForCheckbox) {
            this.addDefaultStateForToggleableState($this$addCheckedStateForCheckbox);
        }

        private final void addCheckedStateForRadioButton(AccessibleStateSet $this$addCheckedStateForRadioButton) {
            if (Intrinsics.areEqual((Object)this.getSelected(), (Object)true)) {
                $this$addCheckedStateForRadioButton.add(AccessibleState.CHECKED);
            }
        }

        private final void addDefaultStateForToggleableState(AccessibleStateSet $this$addDefaultStateForToggleableState) {
            AccessibleState accessibleState;
            ToggleableState toggleableState = this.getToggleableState();
            switch (toggleableState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) {
                case 1: {
                    accessibleState = AccessibleState.CHECKED;
                    break;
                }
                case 2: {
                    accessibleState = AccessibleState.INDETERMINATE;
                    break;
                }
                case -1: 
                case 3: {
                    accessibleState = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            AccessibleState state2 = accessibleState;
            if (state2 != null) {
                $this$addDefaultStateForToggleableState.add(state2);
            }
        }

        @Override
        private final ComposeAccessibleText getAccessibleText() {
            Lazy lazy = this.accessibleText$delegate;
            return (ComposeAccessibleText)lazy.getValue();
        }

        @Override
        @Nullable
        public AccessibleText getAccessibleText() {
            return this.getAccessibleText();
        }

        @Override
        @Nullable
        public AccessibleEditableText getAccessibleEditableText() {
            ComposeAccessibleText accessibleText = this.getAccessibleText();
            return accessibleText instanceof AccessibleEditableText ? (AccessibleEditableText)((Object)accessibleText) : null;
        }

        @Override
        public void setBounds(@Nullable Rectangle r) {
            System.out.println((Object)"Not implemented: setBounds");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setSize(@Nullable Dimension d) {
            System.out.println((Object)"Not implemented: setSize");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setLocation(@Nullable Point p) {
            System.out.println((Object)"Not implemented: setLocation");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Color getBackground() {
            System.out.println((Object)"Not implemented: getBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setBackground(@Nullable Color c) {
            System.out.println((Object)"Not implemented: setBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Color getForeground() {
            System.out.println((Object)"Not implemented: getForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setForeground(@Nullable Color c) {
            System.out.println((Object)"Not implemented: setForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            System.out.println((Object)"Not implemented: getCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setCursor(@Nullable Cursor cursor2) {
            System.out.println((Object)"Not implemented: setCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Font getFont() {
            System.out.println((Object)"Not implemented: getFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setFont(@Nullable Font f) {
            System.out.println((Object)"Not implemented: setFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public FontMetrics getFontMetrics(@Nullable Font f) {
            System.out.println((Object)"Not implemented: getFontMetrics");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setEnabled(boolean b) {
            System.out.println((Object)"Not implemented: setEnabled");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setVisible(boolean b) {
            System.out.println((Object)"Not implemented: setVisible");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.getAccessibleActionCount() : 0;
        }

        @Override
        @NotNull
        public String getAccessibleActionDescription(int i2) {
            Object object = this.accessibleAction;
            if (object == null || (object = object.getAccessibleActionDescription(i2)) == null) {
                object = "";
            }
            return object;
        }

        @Override
        public boolean doAccessibleAction(int i2) {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.doAccessibleAction(i2) : false;
        }

        private static final void getAccessibleAction$addActionIfExist(ComposeAccessible this$0, List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> actions2, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key2) {
            block0: {
                AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this$0.getSemanticsConfig(), key2);
                if (accessibilityAction == null) break block0;
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                boolean bl = false;
                actions2.add((Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>)new Pair((Object)it.getLabel(), key2));
            }
        }

        private static final ComposeAccessibleText accessibleText_delegate$lambda$13(ComposeAccessibleComponent this$0) {
            return this$0.getSetText() != null ? (ComposeAccessibleText)this$0.new ComposeAccessibleEditableText() : (this$0.getText() != null ? this$0.new ComposeAccessibleText() : null);
        }

        @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,935:1\n1565#2:936\n1565#2:937\n1565#2:938\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n*L\n718#1:936\n733#1:937\n751#1:938\n*E\n"})
        public final class ComposeAccessibleEditableText
        extends ComposeAccessibleText
        implements AccessibleEditableText {
            @Override
            public void setTextContents(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)new AnnotatedString(s, null, 2, null));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void insertTextAtIndex(int index, @NotNull String s) {
                void $this$insertTextAtIndex_u24lambda_u240;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text2 = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$insertTextAtIndex_u24lambda_u240.append(text2.subSequence(0, index));
                $this$insertTextAtIndex_u24lambda_u240.append(s);
                $this$insertTextAtIndex_u24lambda_u240.append(text2.subSequence(index, text2.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            @NotNull
            public String getTextRange(int startIndex, int endIndex) {
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return ((Object)((CharSequence)annotatedString).subSequence(startIndex, endIndex)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void delete(int startIndex, int endIndex) {
                void $this$delete_u24lambda_u241;
                AnnotatedString.Builder builder;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text2 = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$delete_u24lambda_u241.append(text2.subSequence(0, startIndex));
                $this$delete_u24lambda_u241.append(text2.subSequence(endIndex, text2.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public void cut(int startIndex, int endIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public void paste(int startIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void replaceText(int startIndex, int endIndex, @NotNull String s) {
                void $this$replaceText_u24lambda_u242;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text2 = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$replaceText_u24lambda_u242.append(text2.subSequence(0, startIndex));
                $this$replaceText_u24lambda_u242.append(s);
                $this$replaceText_u24lambda_u242.append(text2.subSequence(endIndex, text2.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public void selectText(int startIndex, int endIndex) {
                AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetSelection();
                Intrinsics.checkNotNull(accessibilityAction);
                Function3<Integer, Integer, Boolean, Boolean> function3 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function3);
                function3.invoke((Object)startIndex, (Object)endIndex, (Object)false);
            }

            @Override
            public void setAttributes(int startIndex, int endIndex, @Nullable AttributeSet as) {
                System.out.println((Object)"Not implemented: setAttributes");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        public class ComposeAccessibleText
        implements AccessibleExtendedText,
        AccessibleText {
            @Override
            public int getIndexAtPoint(@NotNull Point p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return textLayoutResult.getOffsetForPosition-k-4lQ0M(ComposeAccessibleComponent.this.toComposeOffset-tuRUvjQ(p));
            }

            @Override
            @NotNull
            public Rectangle getCharacterBounds(int i2) {
                block3: {
                    block2: {
                        if (i2 < 0) break block2;
                        AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        if (i2 < annotatedString.length()) break block3;
                    }
                    return new Rectangle((int)((float)ComposeAccessibleComponent.this.getLocation().x / ComposeAccessibleComponent.this.getDensity().getDensity()), (int)((float)ComposeAccessibleComponent.this.getLocation().y / ComposeAccessibleComponent.this.getDensity().getDensity()), 0, 0);
                }
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return ComposeAccessibleComponent.this.toAwtRectangle(textLayoutResult.getBoundingBox(i2));
            }

            @Override
            public int getCharCount() {
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.length();
            }

            @Override
            public int getCaretPosition() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getStart-impl(textRange.unbox-impl()) : -1;
            }

            private final BreakIterator partToBreakIterator(int part) {
                BreakIterator breakIterator;
                switch (part) {
                    case 3: {
                        breakIterator = BreakIterator.Companion.makeSentenceInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 2: {
                        breakIterator = BreakIterator.Companion.makeWordInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 1: {
                        breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                BreakIterator iter = breakIterator;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                iter.setText(annotatedString.toString());
                return iter;
            }

            @Override
            @NotNull
            public String getAtIndex(int part, int index) {
                String string;
                int end = this.partToBreakIterator(part).following(index);
                if (end == -1) {
                    string = "";
                } else {
                    AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)annotatedString);
                    string = annotatedString.subSequence(index, end).toString();
                }
                return string;
            }

            @Override
            @NotNull
            public String getAfterIndex(int part, int index) {
                BreakIterator iterator2 = this.partToBreakIterator(part);
                int start2 = index;
                while (true) {
                    if ((start2 = iterator2.following(start2)) == -1) {
                        return "";
                    }
                    AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)annotatedString);
                    if (annotatedString.charAt(start2) == ' ') continue;
                    AnnotatedString annotatedString2 = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)annotatedString2);
                    if (annotatedString2.charAt(start2) != '\n') break;
                }
                int end = iterator2.next();
                int end2 = end == -1 ? iterator2.last() : end;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence(start2, end2).toString();
            }

            @Override
            @NotNull
            public String getBeforeIndex(int part, int index) {
                String string;
                int start2 = this.partToBreakIterator(part).preceding(index);
                if (start2 == -1) {
                    string = "";
                } else {
                    AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)annotatedString);
                    string = annotatedString.subSequence(start2, index).toString();
                }
                return string;
            }

            @Override
            @NotNull
            public AttributeSet getCharacterAttribute(int i2) {
                System.out.println((Object)"Not implemented: getCharacterAttribute");
                return new SimpleAttributeSet();
            }

            @Override
            public int getSelectionStart() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getStart-impl(textRange.unbox-impl()) : 0;
            }

            @Override
            public int getSelectionEnd() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getEnd-impl(textRange.unbox-impl()) : 0;
            }

            @Override
            @NotNull
            public String getSelectedText() {
                Object object;
                block3: {
                    block2: {
                        object = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                        if (object == null) break block2;
                        TextRange textRange = object;
                        ComposeAccessibleComponent composeAccessibleComponent = ComposeAccessibleComponent.this;
                        long selection = textRange.unbox-impl();
                        boolean bl = false;
                        AnnotatedString annotatedString = composeAccessibleComponent.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        String string = annotatedString.subSequence(TextRange.getStart-impl(selection), TextRange.getEnd-impl(selection)).toString();
                        object = string;
                        if (string != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            @Override
            @NotNull
            public String getTextRange(int startIndex, int endIndex) {
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence(startIndex, endIndex).toString();
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceAt(int part, int index) {
                System.out.println((Object)"Not implemented: getBeforeIndex");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceAfter(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceAfter");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceBefore(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceBefore");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            @NotNull
            public Rectangle getTextBounds(int startIndex, int endIndex) {
                System.out.println((Object)"Not implemented: getTextBounds");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        public final class ScrollBarAccessible
        implements Accessible {
            private final boolean vertical;
            @NotNull
            private final AccessibleContext context;

            public ScrollBarAccessible(boolean vertical) {
                this.vertical = vertical;
                this.context = (AccessibleContext)((Object)new AccessibleValue(this, ComposeAccessibleComponent.this, ComposeAccessible.this){
                    private final ScrollAxisRange range;
                    final /* synthetic */ ScrollBarAccessible this$0;
                    final /* synthetic */ ComposeAccessibleComponent this$1;
                    final /* synthetic */ ComposeAccessible this$2;
                    {
                        ScrollAxisRange scrollAxisRange;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.this$2 = $receiver3;
                        if ($receiver.getVertical()) {
                            ScrollAxisRange scrollAxisRange2 = $receiver2.getVerticalScroll();
                            scrollAxisRange = scrollAxisRange2;
                            Intrinsics.checkNotNull((Object)scrollAxisRange2);
                        } else {
                            ScrollAxisRange scrollAxisRange3 = $receiver2.getHorizontalScroll();
                            scrollAxisRange = scrollAxisRange3;
                            Intrinsics.checkNotNull((Object)scrollAxisRange3);
                        }
                        this.range = scrollAxisRange;
                    }

                    public AccessibleValue getAccessibleValue() {
                        return this;
                    }

                    public AccessibleRole getAccessibleRole() {
                        AccessibleRole accessibleRole = AccessibleRole.SCROLL_BAR;
                        Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"SCROLL_BAR");
                        return accessibleRole;
                    }

                    public AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                        ScrollBarAccessible scrollBarAccessible = this.this$0;
                        AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u240 = accessibleStateSet;
                        boolean bl = false;
                        $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.ENABLED);
                        boolean bl2 = scrollBarAccessible.getVertical() ? $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.VERTICAL) : $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.HORIZONTAL);
                        return accessibleStateSet;
                    }

                    public Accessible getAccessibleParent() {
                        return this.this$2;
                    }

                    public int getAccessibleIndexInParent() {
                        return this.this$1.getAuxiliaryChildren().indexOf(this.this$0);
                    }

                    public int getAccessibleChildrenCount() {
                        return 0;
                    }

                    public Accessible getAccessibleChild(int i2) {
                        return null;
                    }

                    public Locale getLocale() {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        return locale;
                    }

                    public Number getCurrentAccessibleValue() {
                        return (Number)this.range.getValue().invoke();
                    }

                    public boolean setCurrentAccessibleValue(Number n) {
                        boolean bl;
                        if (this.this$0.getVertical()) {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Float f = Float.valueOf(0.0f);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            bl = (Boolean)function2.invoke((Object)f, (Object)Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()));
                        } else {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            bl = (Boolean)function2.invoke((Object)Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()), (Object)Float.valueOf(0.0f));
                        }
                        return bl;
                    }

                    public Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    public Number getMaximumAccessibleValue() {
                        return (Number)this.range.getMaxValue().invoke();
                    }
                });
            }

            public final boolean getVertical() {
                return this.vertical;
            }

            @NotNull
            public final AccessibleContext getContext() {
                return this.context;
            }

            @Override
            @NotNull
            public AccessibleContext getAccessibleContext() {
                return this.context;
            }
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ToggleableState.values().length];
                try {
                    nArray[ToggleableState.On.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Indeterminate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Off.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

