/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.OwnerScope;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class OwnerSnapshotObserver {
    @NotNull
    private final SnapshotStateObserver observer;
    @NotNull
    private final Function1<LayoutNode, Unit> onCommitAffectingLookaheadMeasure;
    @NotNull
    private final Function1<LayoutNode, Unit> onCommitAffectingMeasure;
    @NotNull
    private final Function1<LayoutNode, Unit> onCommitAffectingSemantics;
    @NotNull
    private final Function1<LayoutNode, Unit> onCommitAffectingLayout;
    @NotNull
    private final Function1<LayoutNode, Unit> onCommitAffectingLayoutModifier;
    @NotNull
    private final Function1<LayoutNode, Unit> onCommitAffectingLayoutModifierInLookahead;
    @NotNull
    private final Function1<LayoutNode, Unit> onCommitAffectingLookahead;
    public static final int $stable = SnapshotStateObserver.$stable;

    public OwnerSnapshotObserver(@NotNull Function1<? super Function0<Unit>, Unit> onChangedExecutor) {
        Intrinsics.checkNotNullParameter(onChangedExecutor, (String)"onChangedExecutor");
        this.observer = new SnapshotStateObserver(onChangedExecutor);
        this.onCommitAffectingLookaheadMeasure = OwnerSnapshotObserver::onCommitAffectingLookaheadMeasure$lambda$0;
        this.onCommitAffectingMeasure = OwnerSnapshotObserver::onCommitAffectingMeasure$lambda$1;
        this.onCommitAffectingSemantics = OwnerSnapshotObserver::onCommitAffectingSemantics$lambda$2;
        this.onCommitAffectingLayout = OwnerSnapshotObserver::onCommitAffectingLayout$lambda$3;
        this.onCommitAffectingLayoutModifier = OwnerSnapshotObserver::onCommitAffectingLayoutModifier$lambda$4;
        this.onCommitAffectingLayoutModifierInLookahead = OwnerSnapshotObserver::onCommitAffectingLayoutModifierInLookahead$lambda$5;
        this.onCommitAffectingLookahead = OwnerSnapshotObserver::onCommitAffectingLookahead$lambda$6;
    }

    public final void observeLayoutSnapshotReads$ui(@NotNull LayoutNode node2, boolean affectsLookahead, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (affectsLookahead && node2.getLookaheadRoot$ui() != null) {
            this.observeReads$ui((OwnerScope)node2, this.onCommitAffectingLookahead, block);
        } else {
            this.observeReads$ui((OwnerScope)node2, this.onCommitAffectingLayout, block);
        }
    }

    public static /* synthetic */ void observeLayoutSnapshotReads$ui$default(OwnerSnapshotObserver ownerSnapshotObserver, LayoutNode layoutNode, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        ownerSnapshotObserver.observeLayoutSnapshotReads$ui(layoutNode, bl, (Function0<Unit>)function0);
    }

    public final void observeLayoutModifierSnapshotReads$ui(@NotNull LayoutNode node2, boolean affectsLookahead, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (affectsLookahead && node2.getLookaheadRoot$ui() != null) {
            this.observeReads$ui((OwnerScope)node2, this.onCommitAffectingLayoutModifierInLookahead, block);
        } else {
            this.observeReads$ui((OwnerScope)node2, this.onCommitAffectingLayoutModifier, block);
        }
    }

    public static /* synthetic */ void observeLayoutModifierSnapshotReads$ui$default(OwnerSnapshotObserver ownerSnapshotObserver, LayoutNode layoutNode, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        ownerSnapshotObserver.observeLayoutModifierSnapshotReads$ui(layoutNode, bl, (Function0<Unit>)function0);
    }

    public final void observeMeasureSnapshotReads$ui(@NotNull LayoutNode node2, boolean affectsLookahead, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (affectsLookahead && node2.getLookaheadRoot$ui() != null) {
            this.observeReads$ui((OwnerScope)node2, this.onCommitAffectingLookaheadMeasure, block);
        } else {
            this.observeReads$ui((OwnerScope)node2, this.onCommitAffectingMeasure, block);
        }
    }

    public static /* synthetic */ void observeMeasureSnapshotReads$ui$default(OwnerSnapshotObserver ownerSnapshotObserver, LayoutNode layoutNode, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        ownerSnapshotObserver.observeMeasureSnapshotReads$ui(layoutNode, bl, (Function0<Unit>)function0);
    }

    public final void observeSemanticsReads$ui(@NotNull LayoutNode node2, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.observeReads$ui((OwnerScope)node2, this.onCommitAffectingSemantics, block);
    }

    public final <T extends OwnerScope> void observeReads$ui(@NotNull T target, @NotNull Function1<? super T, Unit> onChanged, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(onChanged, (String)"onChanged");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.observer.observeReads(target, onChanged, block);
    }

    public final void clearInvalidObservations$ui() {
        this.observer.clearIf((Function1<Object, Boolean>)((Function1)OwnerSnapshotObserver::clearInvalidObservations$lambda$7));
    }

    public final void clear$ui(@NotNull Object target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.observer.clear(target);
    }

    public final void startObserving$ui() {
        this.observer.start();
    }

    public final void stopObserving$ui() {
        this.observer.stop();
        this.observer.clear();
    }

    private static final Unit onCommitAffectingLookaheadMeasure$lambda$0(LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isValidOwnerScope()) {
            LayoutNode.requestLookaheadRemeasure$ui$default(layoutNode, false, false, false, 7, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCommitAffectingMeasure$lambda$1(LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isValidOwnerScope()) {
            LayoutNode.requestRemeasure$ui$default(layoutNode, false, false, false, 7, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCommitAffectingSemantics$lambda$2(LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isValidOwnerScope()) {
            layoutNode.invalidateSemantics$ui();
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCommitAffectingLayout$lambda$3(LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isValidOwnerScope()) {
            LayoutNode.requestRelayout$ui$default(layoutNode, false, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCommitAffectingLayoutModifier$lambda$4(LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isValidOwnerScope()) {
            LayoutNode.requestRelayout$ui$default(layoutNode, false, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCommitAffectingLayoutModifierInLookahead$lambda$5(LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isValidOwnerScope()) {
            LayoutNode.requestLookaheadRelayout$ui$default(layoutNode, false, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCommitAffectingLookahead$lambda$6(LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isValidOwnerScope()) {
            LayoutNode.requestLookaheadRelayout$ui$default(layoutNode, false, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean clearInvalidObservations$lambda$7(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !((OwnerScope)it).isValidOwnerScope();
    }
}

