/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.node.LayoutNode;
import java.util.Comparator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nOnPositionedDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnPositionedDispatcher.kt\nandroidx/compose/ui/node/OnPositionedDispatcher\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 LayoutNode.kt\nandroidx/compose/ui/node/LayoutNode\n*L\n1#1,96:1\n1101#2:97\n1083#2,2:98\n519#3:100\n641#3,2:101\n641#3,2:103\n472#3:105\n424#3,8:107\n207#4:106\n*S KotlinDebug\n*F\n+ 1 OnPositionedDispatcher.kt\nandroidx/compose/ui/node/OnPositionedDispatcher\n*L\n26#1:97\n26#1:98,2\n29#1:100\n32#1:101,2\n42#1:103,2\n61#1:105\n79#1:107,8\n79#1:106\n*E\n"})
public final class OnPositionedDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableVector<LayoutNode> layoutNodes;
    @Nullable
    private LayoutNode[] cachedNodes;
    public static final int $stable = 8;

    public OnPositionedDispatcher() {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.layoutNodes = new MutableVector<LayoutNode>(new LayoutNode[capacity$iv$iv], 0);
    }

    public final boolean isNotEmpty() {
        MutableVector<LayoutNode> this_$iv = this.layoutNodes;
        boolean $i$f$isNotEmpty = false;
        return this_$iv.getSize() != 0;
    }

    public final void onNodePositioned(@NotNull LayoutNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        MutableVector<LayoutNode> this_$iv = this.layoutNodes;
        boolean $i$f$plusAssign = false;
        this_$iv.add(node2);
        node2.setNeedsOnPositionedDispatch$ui(true);
    }

    public final void remove(@NotNull LayoutNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        this.layoutNodes.remove(node2);
    }

    public final void onRootNodePositioned(@NotNull LayoutNode rootNode) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        this.layoutNodes.clear();
        MutableVector<LayoutNode> this_$iv = this.layoutNodes;
        boolean $i$f$plusAssign = false;
        this_$iv.add(rootNode);
        rootNode.setNeedsOnPositionedDispatch$ui(true);
    }

    public final void dispatch() {
        int i2;
        this.layoutNodes.sortWith(Companion.DepthComparator.INSTANCE);
        LayoutNode[] cache2 = null;
        int size = this.layoutNodes.getSize();
        LayoutNode[] cachedNodes = this.cachedNodes;
        cache2 = cachedNodes == null || cachedNodes.length < size ? new LayoutNode[Math.max(16, this.layoutNodes.getSize())] : cachedNodes;
        this.cachedNodes = null;
        for (i2 = 0; i2 < size; ++i2) {
            MutableVector<LayoutNode> this_$iv = this.layoutNodes;
            boolean $i$f$get = false;
            cache2[i2] = this_$iv.content[i2];
        }
        this.layoutNodes.clear();
        for (i2 = size - 1; -1 < i2; --i2) {
            LayoutNode layoutNode;
            Intrinsics.checkNotNull((Object)cache2[i2]);
            if (!layoutNode.getNeedsOnPositionedDispatch$ui()) continue;
            this.dispatchHierarchy(layoutNode);
        }
        this.cachedNodes = cache2;
    }

    private final void dispatchHierarchy(LayoutNode layoutNode) {
        layoutNode.dispatchOnPositionedCallbacks$ui();
        layoutNode.setNeedsOnPositionedDispatch$ui(false);
        LayoutNode this_$iv = layoutNode;
        boolean $i$f$forEachChild = false;
        MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
        boolean $i$f$forEach = false;
        T[] content$iv$iv = this_$iv$iv.content;
        int size$iv$iv = this_$iv$iv.getSize();
        for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
            LayoutNode child2 = (LayoutNode)content$iv$iv[i$iv$iv];
            boolean bl = false;
            this.dispatchHierarchy(child2);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static final class DepthComparator
        implements Comparator<LayoutNode> {
            @NotNull
            public static final DepthComparator INSTANCE = new DepthComparator();

            private DepthComparator() {
            }

            @Override
            public int compare(@NotNull LayoutNode a, @NotNull LayoutNode b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                int depthDiff = Intrinsics.compare((int)b.getDepth$ui(), (int)a.getDepth$ui());
                if (depthDiff != 0) {
                    return depthDiff;
                }
                return Intrinsics.compare((int)a.hashCode(), (int)b.hashCode());
            }
        }
    }
}

