/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.collection.MutableObjectIntMap;
import androidx.collection.ObjectIntMapKt;
import androidx.compose.ui.graphics.GraphicsLayerScope;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LookaheadLayoutCoordinates;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.node.AlignmentLinesOwner;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LookaheadCapablePlaceable;
import androidx.compose.ui.node.LookaheadPassDelegate;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nLookaheadDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookaheadDelegate.kt\nandroidx/compose/ui/node/LookaheadDelegate\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,521:1\n30#2:522\n30#2:525\n80#3:523\n80#3:526\n1#4:524\n*S KotlinDebug\n*F\n+ 1 LookaheadDelegate.kt\nandroidx/compose/ui/node/LookaheadDelegate\n*L\n407#1:522\n418#1:525\n407#1:523\n418#1:526\n*E\n"})
public abstract class LookaheadDelegate
extends LookaheadCapablePlaceable
implements Measurable {
    @NotNull
    private final NodeCoordinator coordinator;
    private long position;
    @Nullable
    private Map<AlignmentLine, Integer> oldAlignmentLines;
    @NotNull
    private final LookaheadLayoutCoordinates lookaheadLayoutCoordinates;
    @Nullable
    private MeasureResult _measureResult;
    @NotNull
    private final MutableObjectIntMap<AlignmentLine> cachedAlignmentLinesMap;

    public LookaheadDelegate(@NotNull NodeCoordinator coordinator) {
        Intrinsics.checkNotNullParameter((Object)coordinator, (String)"coordinator");
        this.coordinator = coordinator;
        this.position = IntOffset.Companion.getZero-nOcc-ac();
        this.lookaheadLayoutCoordinates = new LookaheadLayoutCoordinates(this);
        this.cachedAlignmentLinesMap = ObjectIntMapKt.mutableObjectIntMapOf();
    }

    @NotNull
    public final NodeCoordinator getCoordinator() {
        return this.coordinator;
    }

    @Override
    @Nullable
    public LookaheadCapablePlaceable getChild() {
        NodeCoordinator nodeCoordinator = this.coordinator.getWrapped$ui();
        return nodeCoordinator != null ? nodeCoordinator.getLookaheadDelegate() : null;
    }

    @Override
    public boolean getHasMeasureResult() {
        return this._measureResult != null;
    }

    @Override
    public long getPosition-nOcc-ac() {
        return this.position;
    }

    public void setPosition--gyyYBs(long l) {
        this.position = l;
    }

    @Override
    @NotNull
    public MeasureResult getMeasureResult$ui() {
        MeasureResult measureResult = this._measureResult;
        if (measureResult == null) {
            InlineClassHelperKt.throwIllegalStateExceptionForNullCheck("LookaheadDelegate has not been measured yet when measureResult is requested.");
            throw new KotlinNothingValueException();
        }
        return measureResult;
    }

    @Override
    public boolean isLookingAhead() {
        return true;
    }

    @Override
    @NotNull
    public LayoutDirection getLayoutDirection() {
        return this.coordinator.getLayoutDirection();
    }

    @Override
    public float getDensity() {
        return this.coordinator.getDensity();
    }

    @Override
    public float getFontScale() {
        return this.coordinator.getFontScale();
    }

    @Override
    @Nullable
    public LookaheadCapablePlaceable getParent() {
        NodeCoordinator nodeCoordinator = this.coordinator.getWrappedBy$ui();
        return nodeCoordinator != null ? nodeCoordinator.getLookaheadDelegate() : null;
    }

    @Override
    @NotNull
    public LayoutNode getLayoutNode() {
        return this.coordinator.getLayoutNode();
    }

    @Override
    @NotNull
    public LayoutCoordinates getCoordinates() {
        return this.lookaheadLayoutCoordinates;
    }

    /*
     * WARNING - void declaration
     */
    public final long getSize-YbymL2g$ui() {
        void width$iv;
        int n = this.getWidth();
        int height$iv = this.getHeight();
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        return IntSize.constructor-impl((long)width$iv << 32 | (long)height$iv & 0xFFFFFFFFL);
    }

    public final long getConstraints-msEJaDk$ui() {
        return this.getMeasurementConstraints-msEJaDk();
    }

    @NotNull
    public final LookaheadLayoutCoordinates getLookaheadLayoutCoordinates() {
        return this.lookaheadLayoutCoordinates;
    }

    @NotNull
    public AlignmentLinesOwner getAlignmentLinesOwner() {
        AlignmentLinesOwner alignmentLinesOwner = this.coordinator.getLayoutNode().getLayoutDelegate$ui().getLookaheadAlignmentLinesOwner$ui();
        Intrinsics.checkNotNull((Object)alignmentLinesOwner);
        return alignmentLinesOwner;
    }

    /*
     * WARNING - void declaration
     */
    private final void set_measureResult(MeasureResult result2) {
        Map<AlignmentLine, Integer> map2;
        MeasureResult measureResult = result2;
        if (measureResult != null) {
            void width$iv;
            MeasureResult it = measureResult;
            boolean bl = false;
            int n = it.getWidth();
            int height$iv = it.getHeight();
            boolean $i$f$IntSize = false;
            boolean $i$f$packInts = false;
            this.setMeasuredSize-ozmzZPI(IntSize.constructor-impl((long)width$iv << 32 | (long)height$iv & 0xFFFFFFFFL));
        } else {
            LookaheadDelegate $this$_set__measureResult__u24lambda_u241 = this;
            boolean bl = false;
            $this$_set__measureResult__u24lambda_u241.setMeasuredSize-ozmzZPI(IntSize.Companion.getZero-YbymL2g());
        }
        if (!(Intrinsics.areEqual((Object)this._measureResult, (Object)result2) || result2 == null || ((map2 = this.oldAlignmentLines) == null || map2.isEmpty()) && !(!result2.getAlignmentLines().isEmpty()) || Intrinsics.areEqual(result2.getAlignmentLines(), this.oldAlignmentLines))) {
            this.getAlignmentLinesOwner().getAlignmentLines().onAlignmentsChanged();
            Map map3 = this.oldAlignmentLines;
            if (map3 == null) {
                Map map4;
                Map it = map4 = (Map)new LinkedHashMap();
                boolean bl = false;
                this.oldAlignmentLines = it;
                map3 = map4;
            }
            Map oldLines = map3;
            oldLines.clear();
            oldLines.putAll(result2.getAlignmentLines());
        }
        this._measureResult = result2;
    }

    @NotNull
    protected final MutableObjectIntMap<AlignmentLine> getCachedAlignmentLinesMap() {
        return this.cachedAlignmentLinesMap;
    }

    public final int getCachedAlignmentLine$ui(@NotNull AlignmentLine alignmentLine) {
        Intrinsics.checkNotNullParameter((Object)alignmentLine, (String)"alignmentLine");
        return this.cachedAlignmentLinesMap.getOrDefault((Object)alignmentLine, Integer.MIN_VALUE);
    }

    @Override
    public void replace$ui() {
        this.placeAt-f8xVGno(this.getPosition-nOcc-ac(), 0.0f, (Function1<? super GraphicsLayerScope, Unit>)null);
    }

    @Override
    protected final void placeAt-f8xVGno(long position, float zIndex, @Nullable Function1<? super GraphicsLayerScope, Unit> layerBlock) {
        this.placeSelf--gyyYBs(position);
        if (this.isShallowPlacing$ui()) {
            return;
        }
        this.placeChildren();
    }

    private final void placeSelf--gyyYBs(long position) {
        if (!IntOffset.equals-impl0(this.getPosition-nOcc-ac(), position)) {
            this.setPosition--gyyYBs(position);
            LookaheadPassDelegate lookaheadPassDelegate = this.getLayoutNode().getLayoutDelegate$ui().getLookaheadPassDelegate$ui();
            if (lookaheadPassDelegate != null) {
                lookaheadPassDelegate.notifyChildrenUsingLookaheadCoordinatesWhilePlacing();
            }
            this.invalidateAlignmentLinesFromPositionChange(this.coordinator);
        }
        if (!this.isPlacingForAlignment$ui()) {
            this.captureRulers$ui(this.getMeasureResult$ui());
        }
    }

    public final void placeSelfApparentToRealOffset--gyyYBs$ui(long position) {
        this.placeSelf--gyyYBs(IntOffset.plus-qkQi6aY(position, this.getApparentToRealOffset-nOcc-ac()));
    }

    protected void placeChildren() {
        this.getMeasureResult$ui().placeChildren();
    }

    @Override
    @Nullable
    public Object getParentData() {
        return this.coordinator.getParentData();
    }

    @Override
    public int minIntrinsicWidth(int height) {
        NodeCoordinator nodeCoordinator = this.coordinator.getWrapped$ui();
        Intrinsics.checkNotNull((Object)nodeCoordinator);
        LookaheadDelegate lookaheadDelegate = nodeCoordinator.getLookaheadDelegate();
        Intrinsics.checkNotNull((Object)lookaheadDelegate);
        return lookaheadDelegate.minIntrinsicWidth(height);
    }

    @Override
    public int maxIntrinsicWidth(int height) {
        NodeCoordinator nodeCoordinator = this.coordinator.getWrapped$ui();
        Intrinsics.checkNotNull((Object)nodeCoordinator);
        LookaheadDelegate lookaheadDelegate = nodeCoordinator.getLookaheadDelegate();
        Intrinsics.checkNotNull((Object)lookaheadDelegate);
        return lookaheadDelegate.maxIntrinsicWidth(height);
    }

    @Override
    public int minIntrinsicHeight(int width) {
        NodeCoordinator nodeCoordinator = this.coordinator.getWrapped$ui();
        Intrinsics.checkNotNull((Object)nodeCoordinator);
        LookaheadDelegate lookaheadDelegate = nodeCoordinator.getLookaheadDelegate();
        Intrinsics.checkNotNull((Object)lookaheadDelegate);
        return lookaheadDelegate.minIntrinsicHeight(width);
    }

    @Override
    public int maxIntrinsicHeight(int width) {
        NodeCoordinator nodeCoordinator = this.coordinator.getWrapped$ui();
        Intrinsics.checkNotNull((Object)nodeCoordinator);
        LookaheadDelegate lookaheadDelegate = nodeCoordinator.getLookaheadDelegate();
        Intrinsics.checkNotNull((Object)lookaheadDelegate);
        return lookaheadDelegate.maxIntrinsicHeight(width);
    }

    public final long positionIn-iSbpLlY$ui(@NotNull LookaheadDelegate ancestor, boolean excludingAgnosticOffset) {
        Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
        long aggregatedOffset = IntOffset.Companion.getZero-nOcc-ac();
        LookaheadDelegate lookaheadDelegate = this;
        while (!Intrinsics.areEqual((Object)lookaheadDelegate, (Object)ancestor)) {
            if (!lookaheadDelegate.isPlacedUnderMotionFrameOfReference() || !excludingAgnosticOffset) {
                aggregatedOffset = IntOffset.plus-qkQi6aY(aggregatedOffset, lookaheadDelegate.getPosition-nOcc-ac());
            }
            NodeCoordinator nodeCoordinator = lookaheadDelegate.coordinator.getWrappedBy$ui();
            Intrinsics.checkNotNull((Object)nodeCoordinator);
            Intrinsics.checkNotNull((Object)nodeCoordinator.getLookaheadDelegate());
        }
        return aggregatedOffset;
    }

    public static final /* synthetic */ void access$setMeasurementConstraints-BRTryo0(LookaheadDelegate $this, long value2) {
        $this.setMeasurementConstraints-BRTryo0(value2);
    }

    public static final /* synthetic */ void access$set_measureResult(LookaheadDelegate $this, MeasureResult result2) {
        $this.set_measureResult(result2);
    }
}

