/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.MyersDiffKt;
import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nMyersDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MyersDiff.kt\nandroidx/compose/ui/node/IntStack\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n*L\n1#1,518:1\n57#2,4:519\n*S KotlinDebug\n*F\n+ 1 MyersDiff.kt\nandroidx/compose/ui/node/IntStack\n*L\n470#1:519,4\n*E\n"})
final class IntStack {
    @NotNull
    private int[] stack;
    private int lastIndex;

    public IntStack(int initialCapacity) {
        this.stack = new int[initialCapacity];
    }

    public final int get(int index) {
        return this.stack[index];
    }

    public final int getSize() {
        return this.lastIndex;
    }

    private final int[] resizeStack(int[] stack) {
        int[] nArray = Arrays.copyOf(stack, stack.length * 2);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        int[] copy2 = nArray;
        this.stack = copy2;
        return copy2;
    }

    public final void pushRange(int oldStart, int oldEnd, int newStart, int newEnd) {
        int i2 = this.lastIndex;
        int[] stack = this.stack;
        if (i2 + 4 >= stack.length) {
            stack = this.resizeStack(stack);
        }
        stack[i2 + 0] = oldStart;
        stack[i2 + 1] = oldEnd;
        stack[i2 + 2] = newStart;
        stack[i2 + 3] = newEnd;
        this.lastIndex = i2 + 4;
    }

    public final void pushDiagonal(int x, int y, int size) {
        int i2 = this.lastIndex;
        int[] stack = this.stack;
        if (i2 + 3 >= stack.length) {
            stack = this.resizeStack(stack);
        }
        stack[i2 + 0] = x + size;
        stack[i2 + 1] = y + size;
        stack[i2 + 2] = size;
        this.lastIndex = i2 + 3;
    }

    public final int pop() {
        this.lastIndex += -1;
        return this.stack[this.lastIndex];
    }

    public final boolean isNotEmpty() {
        return this.lastIndex != 0;
    }

    public final void sortDiagonals() {
        int i2 = this.lastIndex;
        boolean value$iv = i2 % 3 == 0;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("Array size not a multiple of 3");
        }
        if (i2 > 3) {
            this.quickSort(0, i2 - 3, 3);
        }
    }

    private final void quickSort(int start2, int end, int elSize) {
        if (start2 < end) {
            int i2 = this.partition(start2, end, elSize);
            this.quickSort(start2, i2 - elSize, elSize);
            this.quickSort(i2 + elSize, end, elSize);
        }
    }

    private final int partition(int start2, int end, int elSize) {
        int i2 = start2 - elSize;
        for (int j = start2; j < end; j += elSize) {
            if (!this.compareDiagonal(j, end)) continue;
            this.swapDiagonal(i2 += elSize, j);
        }
        this.swapDiagonal(i2 + elSize, end);
        return i2 + elSize;
    }

    private final void swapDiagonal(int i2, int j) {
        int[] stack = this.stack;
        MyersDiffKt.access$swap(stack, i2, j);
        MyersDiffKt.access$swap(stack, i2 + 1, j + 1);
        MyersDiffKt.access$swap(stack, i2 + 2, j + 2);
    }

    private final boolean compareDiagonal(int a, int b) {
        int[] stack = this.stack;
        int a0 = stack[a];
        int b0 = stack[b];
        return a0 < b0 || a0 == b0 && stack[a + 1] <= stack[b + 1];
    }
}

