/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.layout;

import androidx.compose.ui.layout.LayoutModifierImpl;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.unit.Constraints;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LayoutElement
extends ModifierNodeElement<LayoutModifierImpl> {
    @NotNull
    private final Function3<MeasureScope, Measurable, Constraints, MeasureResult> measure;

    public LayoutElement(@NotNull Function3<? super MeasureScope, ? super Measurable, ? super Constraints, ? extends MeasureResult> measure2) {
        Intrinsics.checkNotNullParameter(measure2, (String)"measure");
        this.measure = measure2;
    }

    @Override
    @NotNull
    public LayoutModifierImpl create() {
        return new LayoutModifierImpl(this.measure);
    }

    @Override
    public void update(@NotNull LayoutModifierImpl node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setMeasureBlock(this.measure);
    }

    @NotNull
    public String toString() {
        return "LayoutElement(measure=" + this.measure + ")";
    }

    public int hashCode() {
        return this.measure.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayoutElement)) {
            return false;
        }
        LayoutElement layoutElement = (LayoutElement)other;
        return Intrinsics.areEqual(this.measure, layoutElement.measure);
    }
}

