/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.vector.FastFloatParserKt;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathNodeKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nPathParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParser\n+ 2 FastFloatParser.kt\nandroidx/compose/ui/graphics/vector/FastFloatParserKt\n+ 3 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,546:1\n152#1,6:550\n41#2:547\n43#2:548\n22#3:549\n*S KotlinDebug\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParser\n*L\n135#1:550,6\n129#1:547\n130#1:548\n130#1:549\n*E\n"})
public final class PathParser {
    @Nullable
    private ArrayList<PathNode> nodes;
    @NotNull
    private float[] nodeData = new float[64];

    @NotNull
    public final PathParser parsePathString(@NotNull String pathData) {
        Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
        ArrayList<PathNode> dstNodes = this.nodes;
        if (dstNodes == null) {
            this.nodes = dstNodes = new ArrayList();
        } else {
            dstNodes.clear();
        }
        this.pathStringToNodes(pathData, dstNodes);
        return this;
    }

    @NotNull
    public final ArrayList<PathNode> pathStringToNodes(@NotNull String pathData, @NotNull ArrayList<PathNode> nodes) {
        int start2;
        Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int end = pathData.length();
        int dataCount = 0;
        for (start2 = 0; start2 < end && Intrinsics.compare((int)pathData.charAt(start2), (int)32) <= 0; ++start2) {
        }
        while (end > start2 && Intrinsics.compare((int)pathData.charAt(end - 1), (int)32) <= 0) {
            --end;
        }
        int index = start2;
        while (index < end) {
            char c = '\u0000';
            char command2 = '\u0000';
            do {
                int lowerChar;
                if (((lowerChar = (c = pathData.charAt(index++)) | 0x20) - 97) * (lowerChar - 122) > 0 || lowerChar == 101) continue;
                command2 = c;
                break;
            } while (index < end);
            if (command2 == '\u0000') continue;
            if ((command2 | 0x20) != 122) {
                dataCount = 0;
                while (true) {
                    long result2;
                    if (index < end && Intrinsics.compare((int)pathData.charAt(index), (int)32) <= 0) {
                        ++index;
                        continue;
                    }
                    long $this$index$iv = result2 = FastFloatParserKt.nextFloat(pathData, index, end);
                    boolean $i$f$getIndex = false;
                    index = (int)($this$index$iv >>> 32);
                    long $this$floatValue$iv = result2;
                    boolean $i$f$getFloatValue = false;
                    int bits$iv$iv = (int)($this$floatValue$iv & 0xFFFFFFFFL);
                    boolean $i$f$floatFromBits = false;
                    float value2 = Float.intBitsToFloat(bits$iv$iv);
                    if (!Float.isNaN(value2)) {
                        this.nodeData[dataCount++] = value2;
                        PathParser this_$iv = this;
                        boolean $i$f$resizeNodeData = false;
                        if (dataCount >= this_$iv.nodeData.length) {
                            float[] src$iv = this_$iv.nodeData;
                            this_$iv.nodeData = new float[dataCount * 2];
                            ArraysKt.copyInto((float[])src$iv, (float[])this_$iv.nodeData, (int)0, (int)0, (int)src$iv.length);
                        }
                    }
                    while (index < end && pathData.charAt(index) == ',') {
                        ++index;
                    }
                    if (index >= end || Float.isNaN(value2)) break;
                }
            }
            PathNodeKt.addPathNodes(command2, nodes, this.nodeData, dataCount);
        }
        return nodes;
    }

    @NotNull
    public final List<PathNode> toNodes() {
        ArrayList<PathNode> arrayList = this.nodes;
        return arrayList != null ? (List)arrayList : CollectionsKt.emptyList();
    }
}

