/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathMeasure;
import androidx.compose.ui.graphics.SkiaBackedPathMeasure_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.Stroke;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParserKt;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/PathComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,642:1\n1#2:643\n*E\n"})
public final class PathComponent
extends VNode {
    @NotNull
    private String name = "";
    @Nullable
    private Brush fill;
    private float fillAlpha = 1.0f;
    @NotNull
    private List<? extends PathNode> pathData = VectorKt.getEmptyPath();
    private int pathFillType = VectorKt.getDefaultFillType();
    private float strokeAlpha = 1.0f;
    private float strokeLineWidth;
    @Nullable
    private Brush stroke;
    private int strokeLineCap = VectorKt.getDefaultStrokeLineCap();
    private int strokeLineJoin = VectorKt.getDefaultStrokeLineJoin();
    private float strokeLineMiter = 4.0f;
    private float trimPathStart;
    private float trimPathEnd = 1.0f;
    private float trimPathOffset;
    private boolean isPathDirty = true;
    private boolean isStrokeDirty = true;
    private boolean isTrimPathDirty;
    @Nullable
    private Stroke strokeStyle;
    @NotNull
    private final Path path;
    @NotNull
    private Path renderPath = this.path = SkiaBackedPath_skikoKt.Path();
    @NotNull
    private final Lazy pathMeasure$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, PathComponent::pathMeasure_delegate$lambda$0);
    public static final int $stable = 8;

    public PathComponent() {
        super(null);
    }

    public final void setName(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.name = value2;
        this.invalidate();
    }

    @Nullable
    public final Brush getFill() {
        return this.fill;
    }

    public final void setFill(@Nullable Brush value2) {
        this.fill = value2;
        this.invalidate();
    }

    public final void setFillAlpha(float value2) {
        this.fillAlpha = value2;
        this.invalidate();
    }

    public final void setPathData(@NotNull List<? extends PathNode> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.pathData = value2;
        this.isPathDirty = true;
        this.invalidate();
    }

    public final void setPathFillType-oQ8Xj4U(int value2) {
        this.pathFillType = value2;
        this.renderPath.setFillType-oQ8Xj4U(value2);
        this.invalidate();
    }

    public final void setStrokeAlpha(float value2) {
        this.strokeAlpha = value2;
        this.invalidate();
    }

    public final void setStrokeLineWidth(float value2) {
        this.strokeLineWidth = value2;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    @Nullable
    public final Brush getStroke() {
        return this.stroke;
    }

    public final void setStroke(@Nullable Brush value2) {
        this.stroke = value2;
        this.invalidate();
    }

    public final void setStrokeLineCap-BeK7IIE(int value2) {
        this.strokeLineCap = value2;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final void setStrokeLineJoin-Ww9F2mQ(int value2) {
        this.strokeLineJoin = value2;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final void setStrokeLineMiter(float value2) {
        this.strokeLineMiter = value2;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final void setTrimPathStart(float value2) {
        this.trimPathStart = value2;
        this.isTrimPathDirty = true;
        this.invalidate();
    }

    public final void setTrimPathEnd(float value2) {
        this.trimPathEnd = value2;
        this.isTrimPathDirty = true;
        this.invalidate();
    }

    public final void setTrimPathOffset(float value2) {
        this.trimPathOffset = value2;
        this.isTrimPathDirty = true;
        this.invalidate();
    }

    private final PathMeasure getPathMeasure() {
        Lazy lazy = this.pathMeasure$delegate;
        return (PathMeasure)lazy.getValue();
    }

    private final void updatePath() {
        PathParserKt.toPath(this.pathData, this.path);
        this.updateRenderPath();
    }

    private final void updateRenderPath() {
        if (this.trimPathStart == 0.0f && this.trimPathEnd == 1.0f) {
            this.renderPath = this.path;
        } else {
            boolean bl;
            if (Intrinsics.areEqual((Object)this.renderPath, (Object)this.path)) {
                this.renderPath = SkiaBackedPath_skikoKt.Path();
            } else {
                int fillType = this.renderPath.getFillType-Rg-k1Os();
                this.renderPath.rewind();
                this.renderPath.setFillType-oQ8Xj4U(fillType);
            }
            this.getPathMeasure().setPath(this.path, false);
            float length = this.getPathMeasure().getLength();
            float start2 = (this.trimPathStart + this.trimPathOffset) % 1.0f * length;
            float end = (this.trimPathEnd + this.trimPathOffset) % 1.0f * length;
            if (start2 > end) {
                this.getPathMeasure().getSegment(start2, length, this.renderPath, true);
                bl = this.getPathMeasure().getSegment(0.0f, end, this.renderPath, true);
            } else {
                bl = this.getPathMeasure().getSegment(start2, end, this.renderPath, true);
            }
        }
    }

    @Override
    public void draw(@NotNull DrawScope $this$draw) {
        block5: {
            Brush it;
            Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
            if (this.isPathDirty) {
                this.updatePath();
            } else if (this.isTrimPathDirty) {
                this.updateRenderPath();
            }
            this.isPathDirty = false;
            this.isTrimPathDirty = false;
            Brush brush = this.fill;
            if (brush != null) {
                it = brush;
                boolean bl = false;
                DrawScope.drawPath-GBMwjPU$default($this$draw, this.renderPath, it, this.fillAlpha, null, null, 0, 56, null);
            }
            Brush brush2 = this.stroke;
            if (brush2 == null) break block5;
            it = brush2;
            boolean bl = false;
            Stroke targetStroke = this.strokeStyle;
            if (this.isStrokeDirty || targetStroke == null) {
                this.strokeStyle = targetStroke = new Stroke(this.strokeLineWidth, this.strokeLineMiter, this.strokeLineCap, this.strokeLineJoin, null, 16, null);
                this.isStrokeDirty = false;
            }
            DrawScope.drawPath-GBMwjPU$default($this$draw, this.renderPath, it, this.strokeAlpha, targetStroke, null, 0, 48, null);
        }
    }

    @NotNull
    public String toString() {
        return this.path.toString();
    }

    private static final PathMeasure pathMeasure_delegate$lambda$0() {
        return SkiaBackedPathMeasure_skikoKt.PathMeasure();
    }
}

