/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.graphics.vector.PathComponent;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParserKt;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/GroupComponent\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,642:1\n635#2:643\n640#2:644\n249#3,8:645\n257#3:654\n259#3,4:660\n1#4:653\n35#5,5:655\n35#5,5:664\n*S KotlinDebug\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/GroupComponent\n*L\n409#1:643\n410#1:644\n608#1:645,8\n608#1:654\n608#1:660,4\n615#1:655,5\n621#1:664,5\n*E\n"})
public final class GroupComponent
extends VNode {
    @Nullable
    private float[] groupMatrix;
    @NotNull
    private final List<VNode> children = new ArrayList();
    private boolean isTintable = true;
    private long tintColor = Color.Companion.getUnspecified-0d7_KjU();
    @NotNull
    private List<? extends PathNode> clipPathData = VectorKt.getEmptyPath();
    private boolean isClipPathDirty = true;
    @Nullable
    private Path clipPath;
    @Nullable
    private Function1<? super VNode, Unit> invalidateListener;
    @NotNull
    private final Function1<VNode, Unit> wrappedListener = arg_0 -> GroupComponent.wrappedListener$lambda$0(this, arg_0);
    @NotNull
    private String name = "";
    private float rotation;
    private float pivotX;
    private float pivotY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float translationX;
    private float translationY;
    private boolean isMatrixDirty = true;
    public static final int $stable = 8;

    public GroupComponent() {
        super(null);
    }

    public final boolean isTintable() {
        return this.isTintable;
    }

    public final long getTintColor-0d7_KjU() {
        return this.tintColor;
    }

    private final void markTintForBrush(Brush brush) {
        if (!this.isTintable) {
            return;
        }
        if (brush != null) {
            if (brush instanceof SolidColor) {
                this.markTintForColor-8_81llA(((SolidColor)brush).getValue-0d7_KjU());
            } else {
                this.markNotTintable();
            }
        }
    }

    private final void markTintForColor-8_81llA(long color) {
        if (!this.isTintable) {
            return;
        }
        long $this$isSpecified$iv = color;
        boolean bl = false;
        if ($this$isSpecified$iv != 16L) {
            long $this$isUnspecified$iv = this.tintColor;
            boolean bl2 = false;
            if ($this$isUnspecified$iv == 16L) {
                this.tintColor = color;
            } else if (!VectorKt.rgbEqual--OWjLjI(this.tintColor, color)) {
                this.markNotTintable();
            }
        }
    }

    private final void markTintForVNode(VNode node2) {
        if (node2 instanceof PathComponent) {
            this.markTintForBrush(((PathComponent)node2).getFill());
            this.markTintForBrush(((PathComponent)node2).getStroke());
        } else if (node2 instanceof GroupComponent) {
            if (((GroupComponent)node2).isTintable && this.isTintable) {
                this.markTintForColor-8_81llA(((GroupComponent)node2).tintColor);
            } else {
                this.markNotTintable();
            }
        }
    }

    private final void markNotTintable() {
        this.isTintable = false;
        this.tintColor = Color.Companion.getUnspecified-0d7_KjU();
    }

    public final void setClipPathData(@NotNull List<? extends PathNode> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.clipPathData = value2;
        this.isClipPathDirty = true;
        this.invalidate();
    }

    private final boolean getWillClipPath() {
        return !((Collection)this.clipPathData).isEmpty();
    }

    @Override
    @Nullable
    public Function1<VNode, Unit> getInvalidateListener$ui() {
        return this.invalidateListener;
    }

    @Override
    public void setInvalidateListener$ui(@Nullable Function1<? super VNode, Unit> function1) {
        this.invalidateListener = function1;
    }

    private final void updateClipPath() {
        if (this.getWillClipPath()) {
            Path targetClip = this.clipPath;
            if (targetClip == null) {
                this.clipPath = targetClip = SkiaBackedPath_skikoKt.Path();
            }
            PathParserKt.toPath(this.clipPathData, targetClip);
        }
    }

    public final void setName(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.name = value2;
        this.invalidate();
    }

    public final void setRotation(float value2) {
        this.rotation = value2;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final void setPivotX(float value2) {
        this.pivotX = value2;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final void setPivotY(float value2) {
        this.pivotY = value2;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final void setScaleX(float value2) {
        this.scaleX = value2;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final void setScaleY(float value2) {
        this.scaleY = value2;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final void setTranslationX(float value2) {
        this.translationX = value2;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final void setTranslationY(float value2) {
        this.translationY = value2;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final int getNumChildren() {
        return this.children.size();
    }

    private final void updateMatrix() {
        float[] matrix = null;
        float[] target = this.groupMatrix;
        if (target == null) {
            this.groupMatrix = matrix = Matrix.constructor-impl$default(null, 1, null);
        } else {
            matrix = target;
            Matrix.reset-impl(matrix);
        }
        Matrix.translate-impl$default(matrix, this.translationX + this.pivotX, this.translationY + this.pivotY, 0.0f, 4, null);
        Matrix.rotateZ-impl(matrix, this.rotation);
        Matrix.scale-impl(matrix, this.scaleX, this.scaleY, 1.0f);
        Matrix.translate-impl$default(matrix, -this.pivotX, -this.pivotY, 0.0f, 4, null);
    }

    public final void insertAt(int index, @NotNull VNode instance2) {
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        if (index < this.getNumChildren()) {
            this.children.set(index, instance2);
        } else {
            this.children.add(instance2);
        }
        this.markTintForVNode(instance2);
        instance2.setInvalidateListener$ui(this.wrappedListener);
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull DrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (this.isMatrixDirty) {
            this.updateMatrix();
            this.isMatrixDirty = false;
        }
        if (this.isClipPathDirty) {
            this.updateClipPath();
            this.isClipPathDirty = false;
        }
        DrawScope $this$withTransform$iv = $this$draw;
        boolean $i$f$withTransform = false;
        DrawContext $this$withTransform_u24lambda_u246$iv = $this$withTransform$iv.getDrawContext();
        boolean bl = false;
        long previousSize$iv = $this$withTransform_u24lambda_u246$iv.getSize-NH-jbRc();
        $this$withTransform_u24lambda_u246$iv.getCanvas().save();
        try {
            DrawTransform $this$draw_u24lambda_u245 = $this$withTransform_u24lambda_u246$iv.getTransform();
            boolean bl2 = false;
            if (this.groupMatrix != null) {
                float[] it = (this.groupMatrix != null ? Matrix.box-impl(this.groupMatrix) : null).unbox-impl();
                boolean bl3 = false;
                $this$draw_u24lambda_u245.transform-58bKbWc(it);
            }
            Path targetClip = this.clipPath;
            if (this.getWillClipPath() && targetClip != null) {
                DrawTransform.clipPath-mtrdD-E$default($this$draw_u24lambda_u245, targetClip, 0, 2, null);
            }
            DrawScope $this$draw_u24lambda_u248 = $this$withTransform$iv;
            boolean bl4 = false;
            List<VNode> $this$fastForEach$iv = this.children;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                VNode item$iv;
                VNode node2 = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl5 = false;
                VNode $this$draw_u24lambda_u248_u24lambda_u247_u24lambda_u246 = node2;
                boolean bl6 = false;
                $this$draw_u24lambda_u248_u24lambda_u247_u24lambda_u246.draw($this$draw);
            }
        }
        finally {
            $this$withTransform_u24lambda_u246$iv.getCanvas().restore();
            $this$withTransform_u24lambda_u246$iv.setSize-uvyYCjk(previousSize$iv);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder().append("VGroup: ").append(this.name);
        List<VNode> $this$fastForEach$iv = this.children;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            VNode item$iv;
            VNode node2 = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            sb.append("\t").append(node2.toString()).append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit wrappedListener$lambda$0(GroupComponent this$0, VNode node2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            this$0.markTintForVNode(node2);
            Function1<VNode, Unit> function1 = this$0.getInvalidateListener$ui();
            if (function1 == null) break block0;
            function1.invoke((Object)node2);
        }
        return Unit.INSTANCE;
    }
}

