/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.layer;

import androidx.collection.MutableScatterSet;
import androidx.collection.ScatterSet;
import androidx.collection.ScatterSetKt;
import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.BlendMode_skikoKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.RenderEffect;
import androidx.compose.ui.graphics.SkiaBackedCanvas;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.SkiaColorFilter_skikoKt;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.layer.ChildLayerDependenciesTracker;
import androidx.compose.ui.graphics.layer.CompositingStrategy;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.ImageFilter;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.RRect;
import org.jetbrains.skiko.node.RenderNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nSkiaGraphicsLayer.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaGraphicsLayer.skiko.kt\nandroidx/compose/ui/graphics/layer/GraphicsLayer\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 9 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadiusKt\n+ 10 ChildLayerDependenciesTracker.kt\nandroidx/compose/ui/graphics/layer/ChildLayerDependenciesTracker\n+ 11 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 12 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 13 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n*L\n1#1,446:1\n390#1,6:462\n396#1,3:469\n394#1,7:472\n54#2:447\n59#2:449\n54#2:451\n59#2:453\n54#2:580\n59#2:582\n85#3:448\n90#3:450\n85#3:452\n90#3:454\n60#3:457\n70#3:460\n60#3:480\n70#3:483\n60#3:486\n70#3:489\n53#3,3:492\n85#3:581\n90#3:583\n153#4:455\n153#4:468\n153#4:545\n65#5:456\n69#5:459\n65#5:479\n69#5:482\n22#6:458\n22#6:481\n22#6:484\n22#6:487\n22#6:490\n1#7:461\n1#7:501\n57#8:485\n61#8:488\n33#9:491\n44#10,6:495\n50#10,14:502\n64#10,4:541\n104#10,6:546\n110#10,3:577\n231#11,3:516\n200#11,7:519\n211#11,3:527\n214#11,9:531\n234#11:540\n231#11,3:552\n200#11,7:555\n211#11,3:563\n214#11,9:567\n234#11:576\n1399#12:526\n1270#12:530\n1399#12:562\n1270#12:566\n305#13,26:584\n*S KotlinDebug\n*F\n+ 1 SkiaGraphicsLayer.skiko.kt\nandroidx/compose/ui/graphics/layer/GraphicsLayer\n*L\n209#1:462,6\n209#1:469,3\n209#1:472,7\n87#1:447\n88#1:449\n100#1:451\n101#1:453\n421#1:580\n421#1:582\n87#1:448\n88#1:450\n100#1:452\n101#1:454\n114#1:457\n114#1:460\n210#1:480\n211#1:483\n212#1:486\n213#1:489\n217#1:492,3\n421#1:581\n421#1:583\n103#1:455\n209#1:468\n395#1:545\n114#1:456\n114#1:459\n210#1:479\n211#1:482\n114#1:458\n210#1:481\n211#1:484\n212#1:487\n213#1:490\n340#1:501\n212#1:485\n213#1:488\n217#1:491\n340#1:495,6\n340#1:502,14\n340#1:541,4\n413#1:546,6\n413#1:577,3\n340#1:516,3\n340#1:519,7\n340#1:527,3\n340#1:531,9\n340#1:540\n413#1:552,3\n413#1:555,7\n413#1:563,3\n413#1:567,9\n413#1:576\n340#1:526\n340#1:530\n413#1:562\n413#1:566\n324#1:584,26\n*E\n"})
public final class GraphicsLayer {
    @Nullable
    private RenderNode renderNode;
    @NotNull
    private final CanvasDrawScope pictureDrawScope;
    private boolean outlineDirty;
    private long roundRectOutlineTopLeft;
    private long roundRectOutlineSize;
    private float roundRectCornerRadius;
    @Nullable
    private Outline internalOutline;
    @Nullable
    private Path outlinePath;
    private int parentLayerUsages;
    @NotNull
    private final ChildLayerDependenciesTracker childDependenciesTracker;
    private int compositingStrategy;
    private long topLeft;
    private long size;
    private long pivotOffset;
    private float alpha;
    private float scaleX;
    private float scaleY;
    private float translationX;
    private float translationY;
    private float shadowElevation;
    private long ambientShadowColor;
    private long spotShadowColor;
    private int blendMode;
    @Nullable
    private ColorFilter colorFilter;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    private float cameraDistance;
    private boolean clip;
    @Nullable
    private RenderEffect renderEffect;
    private boolean isReleased;

    public GraphicsLayer(@NotNull RenderNode renderNode) {
        Intrinsics.checkNotNullParameter((Object)renderNode, (String)"renderNode");
        this.renderNode = renderNode;
        this.pictureDrawScope = new CanvasDrawScope();
        this.outlineDirty = true;
        this.roundRectOutlineTopLeft = Offset.Companion.getZero-F1C5BW0();
        this.roundRectOutlineSize = Size.Companion.getUnspecified-NH-jbRc();
        this.childDependenciesTracker = new ChildLayerDependenciesTracker();
        this.compositingStrategy = CompositingStrategy.Companion.getAuto-ke2Ky5w();
        this.topLeft = IntOffset.Companion.getZero-nOcc-ac();
        this.size = IntSize.Companion.getZero-YbymL2g();
        this.pivotOffset = Offset.Companion.getUnspecified-F1C5BW0();
        this.alpha = 1.0f;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.ambientShadowColor = Color.Companion.getBlack-0d7_KjU();
        this.spotShadowColor = Color.Companion.getBlack-0d7_KjU();
        this.blendMode = BlendMode.Companion.getSrcOver-0nO6VwU();
        this.cameraDistance = 8.0f;
    }

    public final void setCompositingStrategy-Wpw9cng(int value2) {
        if (!CompositingStrategy.equals-impl0(this.compositingStrategy, value2)) {
            this.compositingStrategy = value2;
            this.updateLayerProperties();
        }
    }

    public final long getTopLeft-nOcc-ac() {
        return this.topLeft;
    }

    public final void setTopLeft--gyyYBs(long value2) {
        block1: {
            if (IntOffset.equals-impl0(this.topLeft, value2)) break block1;
            this.topLeft = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                long arg0$iv = this.size;
                boolean bl = false;
                long value$iv$iv = arg0$iv;
                boolean $i$f$unpackInt1 = false;
                float f = (int)(value$iv$iv >> 32);
                arg0$iv = this.size;
                boolean bl2 = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackInt2 = false;
                renderNode.setBounds(org.jetbrains.skia.Rect.Companion.makeXYWH((float)IntOffset.getX-impl(value2), (float)IntOffset.getY-impl(value2), f, (float)((int)(value$iv$iv & 0xFFFFFFFFL))));
            }
        }
    }

    public final long getSize-YbymL2g() {
        return this.size;
    }

    private final void setSize-ozmzZPI(long value2) {
        if (!IntSize.equals-impl0(this.size, value2)) {
            this.size = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                boolean bl = false;
                long value$iv$iv = value2;
                boolean $i$f$unpackInt1 = false;
                float f = (int)(value$iv$iv >> 32);
                boolean bl2 = false;
                value$iv$iv = value2;
                boolean $i$f$unpackInt2 = false;
                renderNode.setBounds(org.jetbrains.skia.Rect.Companion.makeXYWH((float)IntOffset.getX-impl(this.topLeft), (float)IntOffset.getY-impl(this.topLeft), f, (float)((int)(value$iv$iv & 0xFFFFFFFFL))));
            }
            long $this$isUnspecified$iv = this.roundRectOutlineSize;
            boolean bl = false;
            if ($this$isUnspecified$iv == 9205357640488583168L) {
                this.outlineDirty = true;
                this.configureOutlineAndClip();
            }
        }
    }

    public final long getPivotOffset-F1C5BW0() {
        return this.pivotOffset;
    }

    public final void setPivotOffset-k-4lQ0M(long value2) {
        block1: {
            if (Offset.equals-impl0(this.pivotOffset, value2)) break block1;
            this.pivotOffset = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                boolean bl = false;
                long value$iv$iv = value2;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                float f = Float.intBitsToFloat(bits$iv$iv$iv);
                boolean bl2 = false;
                value$iv$iv = value2;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                renderNode.setPivot(new Point(f, Float.intBitsToFloat(bits$iv$iv$iv)));
            }
        }
    }

    public final void setAlpha(float value2) {
        if (!(this.alpha == value2)) {
            this.alpha = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setAlpha(value2);
            }
            this.updateLayerProperties();
        }
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(float value2) {
        block1: {
            if (this.scaleX == value2) break block1;
            this.scaleX = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setScaleX(value2);
            }
        }
    }

    public final float getScaleY() {
        return this.scaleY;
    }

    public final void setScaleY(float value2) {
        block1: {
            if (this.scaleY == value2) break block1;
            this.scaleY = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setScaleY(value2);
            }
        }
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final void setTranslationX(float value2) {
        block1: {
            if (this.translationX == value2) break block1;
            this.translationX = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setTranslationX(value2);
            }
        }
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final void setTranslationY(float value2) {
        block1: {
            if (this.translationY == value2) break block1;
            this.translationY = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setTranslationY(value2);
            }
        }
    }

    public final void setShadowElevation(float value2) {
        if (!(this.shadowElevation == value2)) {
            this.shadowElevation = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setShadowElevation(value2);
            }
            this.outlineDirty = true;
            this.configureOutlineAndClip();
        }
    }

    public final void setAmbientShadowColor-8_81llA(long value2) {
        block1: {
            if (Color.equals-impl0(this.ambientShadowColor, value2)) break block1;
            this.ambientShadowColor = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setAmbientShadowColor(ColorKt.toArgb-8_81llA(value2));
            }
        }
    }

    public final void setSpotShadowColor-8_81llA(long value2) {
        block1: {
            if (Color.equals-impl0(this.spotShadowColor, value2)) break block1;
            this.spotShadowColor = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setSpotShadowColor(ColorKt.toArgb-8_81llA(value2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Outline getOutline() {
        Outline outline;
        Outline tmpOutline = this.internalOutline;
        Path tmpPath = this.outlinePath;
        if (tmpOutline != null) {
            outline = tmpOutline;
        } else if (tmpPath != null) {
            Outline.Generic generic;
            Outline.Generic it = generic = new Outline.Generic(tmpPath);
            boolean bl = false;
            this.internalOutline = it;
            outline = generic;
        } else {
            Outline outline2;
            Outline outline3;
            void outlineSize;
            long outlineSize$iv;
            long rRectSize$iv;
            GraphicsLayer this_$iv = this;
            boolean $i$f$resolveOutlinePosition = false;
            long layerSize$iv = IntSizeKt.toSize-ozmzZPI(this_$iv.size);
            long rRectTopLeft$iv = this_$iv.roundRectOutlineTopLeft;
            long $this$isUnspecified$iv$iv = rRectSize$iv = this_$iv.roundRectOutlineSize;
            boolean bl = false;
            long l = outlineSize$iv = $this$isUnspecified$iv$iv == 9205357640488583168L ? layerSize$iv : rRectSize$iv;
            long outlineTopLeft = rRectTopLeft$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            long value$iv$iv = outlineTopLeft;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float left = Float.intBitsToFloat(bits$iv$iv$iv);
            boolean bl4 = false;
            long value$iv$iv2 = outlineTopLeft;
            boolean $i$f$unpackFloat2 = false;
            int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits2 = false;
            float top = Float.intBitsToFloat(bits$iv$iv$iv2);
            boolean bl5 = false;
            void value$iv$iv3 = outlineSize;
            boolean $i$f$unpackFloat12 = false;
            int bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
            boolean $i$f$floatFromBits3 = false;
            float right = left + Float.intBitsToFloat(bits$iv$iv$iv3);
            boolean bl6 = false;
            void value$iv$iv4 = outlineSize;
            boolean $i$f$unpackFloat22 = false;
            int bits$iv$iv$iv4 = (int)(value$iv$iv4 & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits4 = false;
            float bottom = top + Float.intBitsToFloat(bits$iv$iv$iv4);
            float cornerRadius = this.roundRectCornerRadius;
            if (cornerRadius > 0.0f) {
                float y$iv = cornerRadius;
                boolean $i$f$CornerRadius = false;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits(cornerRadius);
                long v2$iv$iv = Float.floatToRawIntBits(y$iv);
                outline3 = new Outline.Rounded(RoundRectKt.RoundRect-gG7oq9Y(left, top, right, bottom, CornerRadius.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)));
            } else {
                outline3 = new Outline.Rectangle(new Rect(left, top, right, bottom));
            }
            Outline it = outline2 = outline3;
            boolean bl7 = false;
            this.internalOutline = it;
            outline = outline2;
        }
        return outline;
    }

    private final void resetOutlineParams() {
        this.internalOutline = null;
        this.outlinePath = null;
        this.roundRectOutlineSize = Size.Companion.getUnspecified-NH-jbRc();
        this.roundRectOutlineTopLeft = Offset.Companion.getZero-F1C5BW0();
        this.roundRectCornerRadius = 0.0f;
        this.outlineDirty = true;
    }

    public final void setPathOutline(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.resetOutlineParams();
        this.outlinePath = path2;
        this.configureOutlineAndClip();
    }

    public final void setRoundRectOutline-TNW_H78(long topLeft, long size, float cornerRadius) {
        if (!(Offset.equals-impl0(this.roundRectOutlineTopLeft, topLeft) && Size.equals-impl0(this.roundRectOutlineSize, size) && this.roundRectCornerRadius == cornerRadius && this.outlinePath == null)) {
            this.resetOutlineParams();
            this.roundRectOutlineTopLeft = topLeft;
            this.roundRectOutlineSize = size;
            this.roundRectCornerRadius = cornerRadius;
            this.configureOutlineAndClip();
        }
    }

    public final void setRectOutline-tz77jQw(long topLeft, long size) {
        this.setRoundRectOutline-TNW_H78(topLeft, size, 0.0f);
    }

    public final float getRotationX() {
        return this.rotationX;
    }

    public final void setRotationX(float value2) {
        block1: {
            if (this.rotationX == value2) break block1;
            this.rotationX = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setRotationX(value2);
            }
        }
    }

    public final float getRotationY() {
        return this.rotationY;
    }

    public final void setRotationY(float value2) {
        block1: {
            if (this.rotationY == value2) break block1;
            this.rotationY = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setRotationY(value2);
            }
        }
    }

    public final float getRotationZ() {
        return this.rotationZ;
    }

    public final void setRotationZ(float value2) {
        block1: {
            if (this.rotationZ == value2) break block1;
            this.rotationZ = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setRotationZ(value2);
            }
        }
    }

    public final float getCameraDistance() {
        return this.cameraDistance;
    }

    public final void setCameraDistance(float value2) {
        block1: {
            if (this.cameraDistance == value2) break block1;
            this.cameraDistance = value2;
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.setCameraDistance(value2);
            }
        }
    }

    public final boolean getClip() {
        return this.clip;
    }

    public final void setClip(boolean value2) {
        if (this.clip != value2) {
            this.clip = value2;
            this.outlineDirty = true;
            this.configureOutlineAndClip();
        }
    }

    public final void setRenderEffect(@Nullable RenderEffect value2) {
        if (!Intrinsics.areEqual((Object)this.renderEffect, (Object)value2)) {
            this.renderEffect = value2;
            this.updateLayerProperties();
        }
    }

    public final void record-mL-hObY(@NotNull Density density, @NotNull LayoutDirection layoutDirection, long size, @NotNull Function1<? super DrawScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.setSize-ozmzZPI(size);
        this.recordWithTracking((Function1<? super SkiaBackedCanvas, Unit>)((Function1)arg_0 -> GraphicsLayer.record_mL_hObY$lambda$3(this, density, layoutDirection, size, block, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recordWithTracking(Function1<? super SkiaBackedCanvas, Unit> block) {
        RenderNode renderNode = this.renderNode;
        if (renderNode == null) {
            return;
        }
        RenderNode renderNode2 = renderNode;
        org.jetbrains.skia.Canvas recordingCanvas = renderNode2.beginRecording();
        try {
            boolean bl;
            Canvas canvas = SkiaBackedCanvas_skikoKt.asComposeCanvas(recordingCanvas);
            Intrinsics.checkNotNull((Object)canvas, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.SkiaBackedCanvas");
            SkiaBackedCanvas composeCanvas = (SkiaBackedCanvas)canvas;
            ChildLayerDependenciesTracker this_$iv = this.childDependenciesTracker;
            boolean $i$f$withTracking = false;
            ChildLayerDependenciesTracker.access$setOldDependency$p(this_$iv, ChildLayerDependenciesTracker.access$getDependency$p(this_$iv));
            MutableScatterSet mutableScatterSet = ChildLayerDependenciesTracker.access$getDependenciesSet$p(this_$iv);
            if (mutableScatterSet != null) {
                MutableScatterSet currentSet$iv = mutableScatterSet;
                boolean bl2 = false;
                if (currentSet$iv.isNotEmpty()) {
                    MutableScatterSet mutableScatterSet2 = ChildLayerDependenciesTracker.access$getOldDependenciesSet$p(this_$iv);
                    if (mutableScatterSet2 == null) {
                        MutableScatterSet mutableScatterSet3;
                        MutableScatterSet it$iv = mutableScatterSet3 = ScatterSetKt.mutableScatterSetOf();
                        boolean bl3 = false;
                        ChildLayerDependenciesTracker.access$setOldDependenciesSet$p(this_$iv, it$iv);
                        mutableScatterSet2 = mutableScatterSet3;
                    }
                    MutableScatterSet oldSet$iv = mutableScatterSet2;
                    oldSet$iv.addAll((ScatterSet)currentSet$iv);
                    currentSet$iv.clear();
                }
            }
            ChildLayerDependenciesTracker.access$setTrackingInProgress$p(this_$iv, true);
            boolean bl4 = false;
            block.invoke((Object)composeCanvas);
            ChildLayerDependenciesTracker.access$setTrackingInProgress$p(this_$iv, false);
            GraphicsLayer graphicsLayer = ChildLayerDependenciesTracker.access$getOldDependency$p(this_$iv);
            if (graphicsLayer != null) {
                GraphicsLayer it = graphicsLayer;
                bl = false;
                it.onRemovedFromParentLayer();
            }
            MutableScatterSet mutableScatterSet4 = ChildLayerDependenciesTracker.access$getOldDependenciesSet$p(this_$iv);
            if (mutableScatterSet4 != null) {
                MutableScatterSet oldSet$iv = mutableScatterSet4;
                boolean bl5 = false;
                if (oldSet$iv.isNotEmpty()) {
                    ScatterSet this_$iv$iv = (ScatterSet)oldSet$iv;
                    boolean $i$f$forEach = false;
                    Object[] elements$iv$iv = this_$iv$iv.elements;
                    ScatterSet this_$iv$iv$iv = this_$iv$iv;
                    boolean $i$f$forEachIndex = false;
                    int i$iv$iv$iv = 0;
                    long[] m$iv$iv$iv = this_$iv$iv$iv.metadata;
                    int lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
                    if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
                        while (true) {
                            long slot$iv$iv$iv;
                            long $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                            boolean $i$f$maskEmptyOrDeleted = false;
                            if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                                int bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                                for (int j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                                    long value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                                    boolean $i$f$isFull = false;
                                    if (value$iv$iv$iv$iv < 128L) {
                                        int index$iv$iv$iv;
                                        int index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                                        boolean bl6 = false;
                                        GraphicsLayer it = (GraphicsLayer)elements$iv$iv[index$iv$iv];
                                        bl = false;
                                        it.onRemovedFromParentLayer();
                                    }
                                    slot$iv$iv$iv >>= 8;
                                }
                                if (bitCount$iv$iv$iv != 8) break;
                            }
                            if (i$iv$iv$iv == lastIndex$iv$iv$iv) break;
                            ++i$iv$iv$iv;
                        }
                    }
                    oldSet$iv.clear();
                }
            }
        }
        finally {
            renderNode2.endRecording();
        }
    }

    private final void addSubLayer(GraphicsLayer graphicsLayer) {
        if (this.childDependenciesTracker.onDependencyAdded(graphicsLayer)) {
            graphicsLayer.onAddedToParentLayer();
        }
    }

    public final void draw$ui_graphics(@NotNull Canvas canvas, @Nullable GraphicsLayer parentLayer) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (this.isReleased) {
                return;
            }
            this.configureOutlineAndClip();
            GraphicsLayer graphicsLayer = parentLayer;
            if (graphicsLayer != null) {
                graphicsLayer.addSubLayer(this);
            }
            RenderNode renderNode = this.renderNode;
            if (renderNode == null) break block2;
            renderNode.drawInto(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas));
        }
    }

    private final void onAddedToParentLayer() {
        int n = this.parentLayerUsages;
        this.parentLayerUsages = n + 1;
    }

    private final void onRemovedFromParentLayer() {
        int n = this.parentLayerUsages;
        this.parentLayerUsages = n + -1;
        this.discardContentIfReleasedAndHaveNoParentLayerUsages();
    }

    private final void configureOutlineAndClip() {
        boolean outlineIsNeeded;
        if (!this.outlineDirty) {
            return;
        }
        RenderNode renderNode = this.renderNode;
        if (renderNode == null) {
            return;
        }
        RenderNode renderNode2 = renderNode;
        boolean bl = outlineIsNeeded = this.clip || this.shadowElevation > 0.0f;
        if (!outlineIsNeeded) {
            renderNode2.setClip(false);
            RenderNode.setClipPath$default((RenderNode)renderNode2, null, null, (boolean)false, (int)6, null);
        } else {
            Outline tmpOutline;
            renderNode2.setClip(this.clip);
            Outline outline = tmpOutline = this.getOutline();
            if (outline instanceof Outline.Rectangle) {
                RenderNode.setClipRect$default((RenderNode)renderNode2, (org.jetbrains.skia.Rect)Rects_skikoKt.toSkiaRect(((Outline.Rectangle)tmpOutline).getRect()), null, (boolean)true, (int)2, null);
            } else if (outline instanceof Outline.Rounded) {
                RenderNode.setClipRRect$default((RenderNode)renderNode2, (RRect)Rects_skikoKt.toSkiaRRect(((Outline.Rounded)tmpOutline).getRoundRect()), null, (boolean)true, (int)2, null);
            } else if (outline instanceof Outline.Generic) {
                RenderNode.setClipPath$default((RenderNode)renderNode2, (org.jetbrains.skia.Path)SkiaBackedPath_skikoKt.asSkiaPath(((Outline.Generic)tmpOutline).getPath()), null, (boolean)true, (int)2, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.outlineDirty = false;
    }

    public final void release$ui_graphics() {
        if (!this.isReleased) {
            this.isReleased = true;
            this.discardContentIfReleasedAndHaveNoParentLayerUsages();
        }
    }

    private final void discardContentIfReleasedAndHaveNoParentLayerUsages() {
        if (this.isReleased && this.parentLayerUsages == 0) {
            boolean bl;
            GraphicsLayer it;
            GraphicsLayer it$iv;
            ChildLayerDependenciesTracker this_$iv = this.childDependenciesTracker;
            boolean $i$f$removeDependencies = false;
            GraphicsLayer graphicsLayer = ChildLayerDependenciesTracker.access$getDependency$p(this_$iv);
            if (graphicsLayer != null) {
                it$iv = graphicsLayer;
                boolean bl2 = false;
                it = it$iv;
                bl = false;
                it.onRemovedFromParentLayer();
                ChildLayerDependenciesTracker.access$setDependency$p(this_$iv, null);
            }
            MutableScatterSet mutableScatterSet = ChildLayerDependenciesTracker.access$getDependenciesSet$p(this_$iv);
            if (mutableScatterSet != null) {
                it$iv = mutableScatterSet;
                boolean bl3 = false;
                ScatterSet this_$iv$iv = (ScatterSet)it$iv;
                boolean $i$f$forEach = false;
                Object[] elements$iv$iv = this_$iv$iv.elements;
                ScatterSet this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$forEachIndex = false;
                int i$iv$iv$iv = 0;
                long[] m$iv$iv$iv = this_$iv$iv$iv.metadata;
                int lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
                if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
                    while (true) {
                        long slot$iv$iv$iv;
                        long $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                        boolean $i$f$maskEmptyOrDeleted = false;
                        if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                            int bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                            for (int j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                                long value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                                boolean $i$f$isFull = false;
                                if (value$iv$iv$iv$iv < 128L) {
                                    int index$iv$iv$iv;
                                    int index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                                    boolean bl4 = false;
                                    it = (GraphicsLayer)elements$iv$iv[index$iv$iv];
                                    bl = false;
                                    it.onRemovedFromParentLayer();
                                }
                                slot$iv$iv$iv >>= 8;
                            }
                            if (bitCount$iv$iv$iv != 8) break;
                        }
                        if (i$iv$iv$iv == lastIndex$iv$iv$iv) break;
                        ++i$iv$iv$iv;
                    }
                }
                it$iv.clear();
            }
            RenderNode renderNode = this.renderNode;
            if (renderNode != null) {
                renderNode.close();
            }
            this.renderNode = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLayerProperties() {
        block2: {
            Paint paint;
            RenderNode renderNode = this.renderNode;
            if (renderNode == null) break block2;
            if (this.requiresLayer()) {
                void it;
                Paint paint2;
                Paint paint3 = paint2 = new Paint();
                RenderNode renderNode2 = renderNode;
                boolean bl = false;
                it.setAlphaf(this.alpha);
                RenderEffect renderEffect = this.renderEffect;
                it.setImageFilter((ImageFilter)(renderEffect != null ? renderEffect.asSkiaImageFilter() : null));
                ColorFilter colorFilter = this.colorFilter;
                it.setColorFilter((org.jetbrains.skia.ColorFilter)(colorFilter != null ? SkiaColorFilter_skikoKt.asSkiaColorFilter(colorFilter) : null));
                it.setBlendMode(BlendMode_skikoKt.toSkia-s9anfk8(this.blendMode));
                renderNode = renderNode2;
                paint = paint2;
            } else {
                paint = null;
            }
            renderNode.setLayerPaint(paint);
        }
    }

    private final boolean requiresLayer() {
        boolean alphaNeedsLayer = this.alpha < 1.0f && !CompositingStrategy.equals-impl0(this.compositingStrategy, CompositingStrategy.Companion.getModulateAlpha-ke2Ky5w());
        boolean hasColorFilter = this.colorFilter != null;
        boolean hasBlendMode = !BlendMode.equals-impl0(this.blendMode, BlendMode.Companion.getSrcOver-0nO6VwU());
        boolean hasRenderEffect = this.renderEffect != null;
        boolean offscreenBufferRequested = CompositingStrategy.equals-impl0(this.compositingStrategy, CompositingStrategy.Companion.getOffscreen-ke2Ky5w());
        return alphaNeedsLayer || hasColorFilter || hasBlendMode || hasRenderEffect || offscreenBufferRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit record_mL_hObY$lambda$3(GraphicsLayer this$0, Density $density, LayoutDirection $layoutDirection, long $size, Function1 $block, SkiaBackedCanvas canvas) {
        void size$iv;
        DrawContext drawContext2;
        void $this$draw_u2dymL40Pk$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.setAlphaMultiplier$ui_graphics(CompositingStrategy.equals-impl0(this$0.compositingStrategy, CompositingStrategy.Companion.getModulateAlpha-ke2Ky5w()) ? this$0.alpha : 1.0f);
        DrawScope drawScope = this$0.pictureDrawScope;
        long l = IntSizeKt.toSize-ozmzZPI($size);
        boolean bl = false;
        Density prevDensity$iv = $this$draw_u2dymL40Pk$iv.getDrawContext().getDensity();
        LayoutDirection prevLayoutDirection$iv = $this$draw_u2dymL40Pk$iv.getDrawContext().getLayoutDirection();
        Canvas prevCanvas$iv = $this$draw_u2dymL40Pk$iv.getDrawContext().getCanvas();
        long prevSize$iv = $this$draw_u2dymL40Pk$iv.getDrawContext().getSize-NH-jbRc();
        GraphicsLayer prevLayer$iv = $this$draw_u2dymL40Pk$iv.getDrawContext().getGraphicsLayer();
        DrawContext $this$draw_ymL40Pk_u24lambda_u247$iv = drawContext2 = $this$draw_u2dymL40Pk$iv.getDrawContext();
        boolean bl2 = false;
        $this$draw_ymL40Pk_u24lambda_u247$iv.setDensity($density);
        $this$draw_ymL40Pk_u24lambda_u247$iv.setLayoutDirection($layoutDirection);
        $this$draw_ymL40Pk_u24lambda_u247$iv.setCanvas(canvas);
        $this$draw_ymL40Pk_u24lambda_u247$iv.setSize-uvyYCjk((long)size$iv);
        $this$draw_ymL40Pk_u24lambda_u247$iv.setGraphicsLayer(this$0);
        ((Canvas)canvas).save();
        try {
            $block.invoke((Object)$this$draw_u2dymL40Pk$iv);
        }
        finally {
            ((Canvas)canvas).restore();
            DrawContext $this$draw_ymL40Pk_u24lambda_u248$iv = drawContext2 = $this$draw_u2dymL40Pk$iv.getDrawContext();
            boolean bl3 = false;
            $this$draw_ymL40Pk_u24lambda_u248$iv.setDensity(prevDensity$iv);
            $this$draw_ymL40Pk_u24lambda_u248$iv.setLayoutDirection(prevLayoutDirection$iv);
            $this$draw_ymL40Pk_u24lambda_u248$iv.setCanvas(prevCanvas$iv);
            $this$draw_ymL40Pk_u24lambda_u248$iv.setSize-uvyYCjk(prevSize$iv);
            $this$draw_ymL40Pk_u24lambda_u248$iv.setGraphicsLayer(prevLayer$iv);
        }
        return Unit.INSTANCE;
    }
}

