/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.Lab;
import androidx.compose.ui.graphics.colorspace.Oklab;
import androidx.compose.ui.graphics.colorspace.Rgb;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import androidx.compose.ui.graphics.colorspace.Xyz;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

public final class ColorSpaces {
    @NotNull
    public static final ColorSpaces INSTANCE = new ColorSpaces();
    @NotNull
    private static final float[] SrgbPrimaries;
    @NotNull
    private static final float[] Ntsc1953Primaries;
    @NotNull
    private static final float[] Bt2020Primaries;
    @NotNull
    private static final TransferParameters SrgbTransferParameters;
    @NotNull
    private static final TransferParameters NoneTransferParameters;
    @NotNull
    private static final TransferParameters Bt2020HlgTransferParameters;
    @NotNull
    private static final TransferParameters Bt2020PqTransferParameters;
    @NotNull
    private static final Rgb Srgb;
    @NotNull
    private static final Rgb LinearSrgb;
    @NotNull
    private static final Rgb ExtendedSrgb;
    @NotNull
    private static final Rgb LinearExtendedSrgb;
    @NotNull
    private static final Rgb Bt709;
    @NotNull
    private static final Rgb Bt2020;
    @NotNull
    private static final Rgb DciP3;
    @NotNull
    private static final Rgb DisplayP3;
    @NotNull
    private static final Rgb Ntsc1953;
    @NotNull
    private static final Rgb SmpteC;
    @NotNull
    private static final Rgb AdobeRgb;
    @NotNull
    private static final Rgb ProPhotoRgb;
    @NotNull
    private static final Rgb Aces;
    @NotNull
    private static final Rgb Acescg;
    @NotNull
    private static final ColorSpace CieXyz;
    @NotNull
    private static final ColorSpace CieLab;
    @NotNull
    private static final Rgb Unspecified;
    @NotNull
    private static final Rgb Bt2020Hlg;
    @NotNull
    private static final Rgb Bt2020Pq;
    @NotNull
    private static final ColorSpace Oklab;
    @NotNull
    private static final ColorSpace[] ColorSpacesArray;

    private ColorSpaces() {
    }

    @NotNull
    public final float[] getSrgbPrimaries$ui_graphics() {
        return SrgbPrimaries;
    }

    @NotNull
    public final float[] getNtsc1953Primaries$ui_graphics() {
        return Ntsc1953Primaries;
    }

    @NotNull
    public final Rgb getSrgb() {
        return Srgb;
    }

    @NotNull
    public final Rgb getLinearSrgb() {
        return LinearSrgb;
    }

    @NotNull
    public final Rgb getDisplayP3() {
        return DisplayP3;
    }

    @NotNull
    public final Rgb getUnspecified$ui_graphics() {
        return Unspecified;
    }

    @NotNull
    public final ColorSpace getOklab() {
        return Oklab;
    }

    @NotNull
    public final ColorSpace[] getColorSpacesArray$ui_graphics() {
        return ColorSpacesArray;
    }

    public final double transferHlgOetf$ui_graphics(@NotNull TransferParameters params2, double x) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        double sign = x < 0.0 ? -1.0 : 1.0;
        double absX = x * sign;
        double R = 1.0 / params2.getA();
        double G = 1.0 / params2.getB();
        double a = 1.0 / params2.getC();
        double b = params2.getD();
        double c = params2.getE();
        double K = params2.getF() + 1.0;
        double result2 = absX <= 1.0 ? R * Math.pow(absX, G) : a * Math.log((absX /= K) - b) + c;
        return sign * result2;
    }

    public final double transferHlgEotf$ui_graphics(@NotNull TransferParameters params2, double x) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        double sign = x < 0.0 ? -1.0 : 1.0;
        double absX = x * sign;
        double R = params2.getA();
        double G = params2.getB();
        double a = params2.getC();
        double b = params2.getD();
        double c = params2.getE();
        double K = params2.getF() + 1.0;
        double result2 = absX * R <= 1.0 ? Math.pow(absX * R, G) : Math.exp((absX - c) * a) + b;
        return K * sign * result2;
    }

    public final double transferSt2048Oetf$ui_graphics(@NotNull TransferParameters params2, double x) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        double sign = x < 0.0 ? -1.0 : 1.0;
        double absX = x * sign;
        double a = -params2.getA();
        double b = params2.getD();
        double c = 1.0 / params2.getF();
        double d = params2.getB();
        double e = -params2.getE();
        double f = 1.0 / params2.getC();
        double tmp = Math.max(a + b * Math.pow(absX, c), 0.0);
        return sign * Math.pow(tmp / (d + e * Math.pow(absX, c)), f);
    }

    public final double transferSt2048Eotf$ui_graphics(@NotNull TransferParameters pq, double x) {
        Intrinsics.checkNotNullParameter((Object)pq, (String)"pq");
        double sign = x < 0.0 ? -1.0 : 1.0;
        double absX = x * sign;
        double tmp = RangesKt.coerceAtLeast((double)(pq.getA() + pq.getB() * Math.pow(absX, pq.getC())), (double)0.0);
        return sign * Math.pow(tmp / (pq.getD() + pq.getE() * Math.pow(absX, pq.getC())), pq.getF());
    }

    private static final double ExtendedSrgb$lambda$0(double x) {
        return ColorSpaceKt.absRcpResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4);
    }

    private static final double ExtendedSrgb$lambda$1(double x) {
        return ColorSpaceKt.absResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4);
    }

    private static final double Bt2020Hlg$lambda$2(double x) {
        return INSTANCE.transferHlgOetf$ui_graphics(Bt2020HlgTransferParameters, x);
    }

    private static final double Bt2020Hlg$lambda$3(double x) {
        return INSTANCE.transferHlgEotf$ui_graphics(Bt2020HlgTransferParameters, x);
    }

    private static final double Bt2020Pq$lambda$4(double x) {
        return INSTANCE.transferSt2048Oetf$ui_graphics(Bt2020PqTransferParameters, x);
    }

    private static final double Bt2020Pq$lambda$5(double x) {
        return INSTANCE.transferSt2048Eotf$ui_graphics(Bt2020PqTransferParameters, x);
    }

    static {
        Object[] objectArray = new float[]{0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
        SrgbPrimaries = objectArray;
        objectArray = new float[]{0.67f, 0.33f, 0.21f, 0.71f, 0.14f, 0.08f};
        Ntsc1953Primaries = objectArray;
        objectArray = new float[]{0.708f, 0.292f, 0.17f, 0.797f, 0.131f, 0.046f};
        Bt2020Primaries = objectArray;
        SrgbTransferParameters = new TransferParameters(2.4, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 0.0, 0.0, 96, null);
        NoneTransferParameters = new TransferParameters(2.2, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 0.0, 0.0, 96, null);
        Bt2020HlgTransferParameters = new TransferParameters(-3.0, 2.0, 2.0, 5.591816309728916, 0.28466892, 0.55991073, -0.685490157);
        Bt2020PqTransferParameters = new TransferParameters(-2.0, -1.555223, 1.860454, 0.012683313515655966, 18.8515625, -18.6875, 6.277394636015326);
        Srgb = new Rgb("sRGB IEC61966-2.1", SrgbPrimaries, Illuminant.INSTANCE.getD65(), SrgbTransferParameters, 0);
        LinearSrgb = new Rgb("sRGB IEC61966-2.1 (Linear)", SrgbPrimaries, Illuminant.INSTANCE.getD65(), 1.0, 0.0f, 1.0f, 1);
        ExtendedSrgb = new Rgb("scRGB-nl IEC 61966-2-2:2003", SrgbPrimaries, Illuminant.INSTANCE.getD65(), null, ColorSpaces::ExtendedSrgb$lambda$0, ColorSpaces::ExtendedSrgb$lambda$1, -0.799f, 2.399f, SrgbTransferParameters, 2);
        LinearExtendedSrgb = new Rgb("scRGB IEC 61966-2-2:2003", SrgbPrimaries, Illuminant.INSTANCE.getD65(), 1.0, -0.5f, 7.499f, 3);
        objectArray = new float[]{0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
        Bt709 = new Rgb("Rec. ITU-R BT.709-5", (float[])objectArray, Illuminant.INSTANCE.getD65(), new TransferParameters(2.2222222222222223, 0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 0.0, 0.0, 96, null), 4);
        objectArray = new float[]{0.708f, 0.292f, 0.17f, 0.797f, 0.131f, 0.046f};
        Bt2020 = new Rgb("Rec. ITU-R BT.2020-1", (float[])objectArray, Illuminant.INSTANCE.getD65(), new TransferParameters(2.2222222222222223, 0.9096697898662786, 0.09033021013372146, 0.2222222222222222, 0.08145, 0.0, 0.0, 96, null), 5);
        objectArray = new float[]{0.68f, 0.32f, 0.265f, 0.69f, 0.15f, 0.06f};
        DciP3 = new Rgb("SMPTE RP 431-2-2007 DCI (P3)", (float[])objectArray, new WhitePoint(0.314f, 0.351f), 2.6, 0.0f, 1.0f, 6);
        objectArray = new float[]{0.68f, 0.32f, 0.265f, 0.69f, 0.15f, 0.06f};
        DisplayP3 = new Rgb("Display P3", (float[])objectArray, Illuminant.INSTANCE.getD65(), SrgbTransferParameters, 7);
        Ntsc1953 = new Rgb("NTSC (1953)", Ntsc1953Primaries, Illuminant.INSTANCE.getC(), new TransferParameters(2.2222222222222223, 0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 0.0, 0.0, 96, null), 8);
        objectArray = new float[]{0.63f, 0.34f, 0.31f, 0.595f, 0.155f, 0.07f};
        SmpteC = new Rgb("SMPTE-C RGB", (float[])objectArray, Illuminant.INSTANCE.getD65(), new TransferParameters(2.2222222222222223, 0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 0.0, 0.0, 96, null), 9);
        objectArray = new float[]{0.64f, 0.33f, 0.21f, 0.71f, 0.15f, 0.06f};
        AdobeRgb = new Rgb("Adobe RGB (1998)", (float[])objectArray, Illuminant.INSTANCE.getD65(), 2.2, 0.0f, 1.0f, 10);
        objectArray = new float[]{0.7347f, 0.2653f, 0.1596f, 0.8404f, 0.0366f, 1.0E-4f};
        ProPhotoRgb = new Rgb("ROMM RGB ISO 22028-2:2013", (float[])objectArray, Illuminant.INSTANCE.getD50(), new TransferParameters(1.8, 1.0, 0.0, 0.0625, 0.031248, 0.0, 0.0, 96, null), 11);
        objectArray = new float[]{0.7347f, 0.2653f, 0.0f, 1.0f, 1.0E-4f, -0.077f};
        Aces = new Rgb("SMPTE ST 2065-1:2012 ACES", (float[])objectArray, Illuminant.INSTANCE.getD60(), 1.0, -65504.0f, 65504.0f, 12);
        objectArray = new float[]{0.713f, 0.293f, 0.165f, 0.83f, 0.128f, 0.044f};
        Acescg = new Rgb("Academy S-2014-004 ACEScg", (float[])objectArray, Illuminant.INSTANCE.getD60(), 1.0, -65504.0f, 65504.0f, 13);
        CieXyz = new Xyz("Generic XYZ", 14);
        CieLab = new Lab("Generic L*a*b*", 15);
        Unspecified = new Rgb("None", SrgbPrimaries, Illuminant.INSTANCE.getD65(), NoneTransferParameters, 16);
        Bt2020Hlg = new Rgb("Hybrid Log Gamma encoding", Bt2020Primaries, Illuminant.INSTANCE.getD65(), null, ColorSpaces::Bt2020Hlg$lambda$2, ColorSpaces::Bt2020Hlg$lambda$3, 0.0f, 1.0f, Bt2020HlgTransferParameters, 17);
        Bt2020Pq = new Rgb("Perceptual Quantizer encoding", Bt2020Primaries, Illuminant.INSTANCE.getD65(), null, ColorSpaces::Bt2020Pq$lambda$4, ColorSpaces::Bt2020Pq$lambda$5, 0.0f, 1.0f, Bt2020PqTransferParameters, 18);
        Oklab = new Oklab("Oklab", 19);
        objectArray = new ColorSpace[20];
        objectArray[0] = (float)Srgb;
        objectArray[1] = (float)LinearSrgb;
        objectArray[2] = (float)ExtendedSrgb;
        objectArray[3] = (float)LinearExtendedSrgb;
        objectArray[4] = (float)Bt709;
        objectArray[5] = (float)Bt2020;
        objectArray[6] = (float)DciP3;
        objectArray[7] = (float)DisplayP3;
        objectArray[8] = (float)Ntsc1953;
        objectArray[9] = (float)SmpteC;
        objectArray[10] = (float)AdobeRgb;
        objectArray[11] = (float)ProPhotoRgb;
        objectArray[12] = (float)Aces;
        objectArray[13] = (float)Acescg;
        objectArray[14] = (float)CieXyz;
        objectArray[15] = (float)CieLab;
        objectArray[16] = (float)Unspecified;
        objectArray[17] = (float)Bt2020Hlg;
        objectArray[18] = (float)Bt2020Pq;
        objectArray[19] = (float)Oklab;
        ColorSpacesArray = (ColorSpace[])objectArray;
    }
}

