/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.annotation.IntRange;
import androidx.annotation.Size;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nColorSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpace\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,717:1\n53#2,3:718\n*S KotlinDebug\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpace\n*L\n246#1:718,3\n*E\n"})
public abstract class ColorSpace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final long model;
    private final int id;

    private ColorSpace(String name2, long model2, int id) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.model = model2;
        this.id = id;
        if (((CharSequence)this.name).length() == 0) {
            throw new IllegalArgumentException("The name of a color space cannot be null and must contain at least 1 character");
        }
        if (this.id < -1 || this.id > 63) {
            throw new IllegalArgumentException("The id must be between -1 and 63");
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getModel-xdoWZVw() {
        return this.model;
    }

    public final int getId$ui_graphics() {
        return this.id;
    }

    @IntRange(from=1L, to=4L)
    public final int getComponentCount() {
        return ColorModel.getComponentCount-impl(this.model);
    }

    public boolean isSrgb() {
        return false;
    }

    public abstract float getMinValue(@IntRange(from=0L, to=3L) int var1);

    public abstract float getMaxValue(@IntRange(from=0L, to=3L) int var1);

    @Size(value=3L)
    @NotNull
    public final float[] toXyz(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.toXyz(fArray);
    }

    @Size(min=3L)
    @NotNull
    public abstract float[] toXyz(@Size(min=3L) @NotNull float[] var1);

    /*
     * WARNING - void declaration
     */
    public long toXy$ui_graphics(float v0, float v1, float v2) {
        void val1$iv;
        float[] xyz = this.toXyz(v0, v1, v2);
        float f = xyz[0];
        float val2$iv = xyz[1];
        boolean $i$f$packFloats = false;
        long v1$iv = Float.floatToRawIntBits((float)val1$iv);
        long v2$iv = Float.floatToRawIntBits(val2$iv);
        return v1$iv << 32 | v2$iv & 0xFFFFFFFFL;
    }

    public float toZ$ui_graphics(float v0, float v1, float v2) {
        float[] xyz = this.toXyz(v0, v1, v2);
        return xyz[2];
    }

    public long xyzaToColor-JlNiLsg$ui_graphics(float x, float y, float z, float a, @NotNull ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        float[] colors = this.fromXyz(x, y, z);
        return ColorKt.Color(colors[0], colors[1], colors[2], a, colorSpace);
    }

    @Size(min=3L)
    @NotNull
    public final float[] fromXyz(float x, float y, float z) {
        float[] xyz = new float[ColorModel.getComponentCount-impl(this.model)];
        xyz[0] = x;
        xyz[1] = y;
        xyz[2] = z;
        return this.fromXyz(xyz);
    }

    @Size(min=3L)
    @NotNull
    public abstract float[] fromXyz(@Size(min=3L) @NotNull float[] var1);

    @NotNull
    public String toString() {
        return this.name + " (id=" + this.id + ", model=" + ColorModel.toString-impl(this.model) + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ColorSpace that = (ColorSpace)other;
        if (this.id != that.id) {
            return false;
        }
        return !Intrinsics.areEqual((Object)this.name, (Object)that.name) ? false : ColorModel.equals-impl0(this.model, that.model);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + ColorModel.hashCode-impl(this.model);
        result2 = 31 * result2 + this.id;
        return result2;
    }

    public /* synthetic */ ColorSpace(String name2, long model2, int id, DefaultConstructorMarker $constructor_marker) {
        this(name2, model2, id);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

