/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.CompositingStrategy;
import androidx.compose.ui.graphics.RenderEffect;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.graphics.SimpleGraphicsLayerModifier;
import androidx.compose.ui.graphics.TransformOrigin;
import androidx.compose.ui.node.ModifierNodeElement;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GraphicsLayerElement
extends ModifierNodeElement<SimpleGraphicsLayerModifier> {
    private final float scaleX;
    private final float scaleY;
    private final float alpha;
    private final float translationX;
    private final float translationY;
    private final float shadowElevation;
    private final float rotationX;
    private final float rotationY;
    private final float rotationZ;
    private final float cameraDistance;
    private final long transformOrigin;
    @NotNull
    private final Shape shape;
    private final boolean clip;
    @Nullable
    private final RenderEffect renderEffect;
    private final long ambientShadowColor;
    private final long spotShadowColor;
    private final int compositingStrategy;

    private GraphicsLayerElement(float scaleX, float scaleY, float alpha2, float translationX, float translationY, float shadowElevation, float rotationX, float rotationY, float rotationZ, float cameraDistance, long transformOrigin, Shape shape, boolean clip, RenderEffect renderEffect, long ambientShadowColor, long spotShadowColor, int compositingStrategy) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.alpha = alpha2;
        this.translationX = translationX;
        this.translationY = translationY;
        this.shadowElevation = shadowElevation;
        this.rotationX = rotationX;
        this.rotationY = rotationY;
        this.rotationZ = rotationZ;
        this.cameraDistance = cameraDistance;
        this.transformOrigin = transformOrigin;
        this.shape = shape;
        this.clip = clip;
        this.renderEffect = renderEffect;
        this.ambientShadowColor = ambientShadowColor;
        this.spotShadowColor = spotShadowColor;
        this.compositingStrategy = compositingStrategy;
    }

    @Override
    @NotNull
    public SimpleGraphicsLayerModifier create() {
        return new SimpleGraphicsLayerModifier(this.scaleX, this.scaleY, this.alpha, this.translationX, this.translationY, this.shadowElevation, this.rotationX, this.rotationY, this.rotationZ, this.cameraDistance, this.transformOrigin, this.shape, this.clip, this.renderEffect, this.ambientShadowColor, this.spotShadowColor, this.compositingStrategy, null);
    }

    @Override
    public void update(@NotNull SimpleGraphicsLayerModifier node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setScaleX(this.scaleX);
        node2.setScaleY(this.scaleY);
        node2.setAlpha(this.alpha);
        node2.setTranslationX(this.translationX);
        node2.setTranslationY(this.translationY);
        node2.setShadowElevation(this.shadowElevation);
        node2.setRotationX(this.rotationX);
        node2.setRotationY(this.rotationY);
        node2.setRotationZ(this.rotationZ);
        node2.setCameraDistance(this.cameraDistance);
        node2.setTransformOrigin-__ExYCQ(this.transformOrigin);
        node2.setShape(this.shape);
        node2.setClip(this.clip);
        node2.setRenderEffect(this.renderEffect);
        node2.setAmbientShadowColor-8_81llA(this.ambientShadowColor);
        node2.setSpotShadowColor-8_81llA(this.spotShadowColor);
        node2.setCompositingStrategy-aDBOjCE(this.compositingStrategy);
        node2.invalidateLayerBlock();
    }

    @NotNull
    public String toString() {
        return "GraphicsLayerElement(scaleX=" + this.scaleX + ", scaleY=" + this.scaleY + ", alpha=" + this.alpha + ", translationX=" + this.translationX + ", translationY=" + this.translationY + ", shadowElevation=" + this.shadowElevation + ", rotationX=" + this.rotationX + ", rotationY=" + this.rotationY + ", rotationZ=" + this.rotationZ + ", cameraDistance=" + this.cameraDistance + ", transformOrigin=" + TransformOrigin.toString-impl(this.transformOrigin) + ", shape=" + this.shape + ", clip=" + this.clip + ", renderEffect=" + this.renderEffect + ", ambientShadowColor=" + Color.toString-impl(this.ambientShadowColor) + ", spotShadowColor=" + Color.toString-impl(this.spotShadowColor) + ", compositingStrategy=" + CompositingStrategy.toString-impl(this.compositingStrategy) + ")";
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.scaleX);
        result2 = result2 * 31 + Float.hashCode(this.scaleY);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        result2 = result2 * 31 + Float.hashCode(this.translationX);
        result2 = result2 * 31 + Float.hashCode(this.translationY);
        result2 = result2 * 31 + Float.hashCode(this.shadowElevation);
        result2 = result2 * 31 + Float.hashCode(this.rotationX);
        result2 = result2 * 31 + Float.hashCode(this.rotationY);
        result2 = result2 * 31 + Float.hashCode(this.rotationZ);
        result2 = result2 * 31 + Float.hashCode(this.cameraDistance);
        result2 = result2 * 31 + TransformOrigin.hashCode-impl(this.transformOrigin);
        result2 = result2 * 31 + this.shape.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.clip);
        result2 = result2 * 31 + (this.renderEffect == null ? 0 : this.renderEffect.hashCode());
        result2 = result2 * 31 + Color.hashCode-impl(this.ambientShadowColor);
        result2 = result2 * 31 + Color.hashCode-impl(this.spotShadowColor);
        result2 = result2 * 31 + CompositingStrategy.hashCode-impl(this.compositingStrategy);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphicsLayerElement)) {
            return false;
        }
        GraphicsLayerElement graphicsLayerElement = (GraphicsLayerElement)other;
        if (Float.compare(this.scaleX, graphicsLayerElement.scaleX) != 0) {
            return false;
        }
        if (Float.compare(this.scaleY, graphicsLayerElement.scaleY) != 0) {
            return false;
        }
        if (Float.compare(this.alpha, graphicsLayerElement.alpha) != 0) {
            return false;
        }
        if (Float.compare(this.translationX, graphicsLayerElement.translationX) != 0) {
            return false;
        }
        if (Float.compare(this.translationY, graphicsLayerElement.translationY) != 0) {
            return false;
        }
        if (Float.compare(this.shadowElevation, graphicsLayerElement.shadowElevation) != 0) {
            return false;
        }
        if (Float.compare(this.rotationX, graphicsLayerElement.rotationX) != 0) {
            return false;
        }
        if (Float.compare(this.rotationY, graphicsLayerElement.rotationY) != 0) {
            return false;
        }
        if (Float.compare(this.rotationZ, graphicsLayerElement.rotationZ) != 0) {
            return false;
        }
        if (Float.compare(this.cameraDistance, graphicsLayerElement.cameraDistance) != 0) {
            return false;
        }
        if (!TransformOrigin.equals-impl0(this.transformOrigin, graphicsLayerElement.transformOrigin)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shape, (Object)graphicsLayerElement.shape)) {
            return false;
        }
        if (this.clip != graphicsLayerElement.clip) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.renderEffect, (Object)graphicsLayerElement.renderEffect)) {
            return false;
        }
        if (!Color.equals-impl0(this.ambientShadowColor, graphicsLayerElement.ambientShadowColor)) {
            return false;
        }
        if (!Color.equals-impl0(this.spotShadowColor, graphicsLayerElement.spotShadowColor)) {
            return false;
        }
        return CompositingStrategy.equals-impl0(this.compositingStrategy, graphicsLayerElement.compositingStrategy);
    }

    public /* synthetic */ GraphicsLayerElement(float scaleX, float scaleY, float alpha2, float translationX, float translationY, float shadowElevation, float rotationX, float rotationY, float rotationZ, float cameraDistance, long transformOrigin, Shape shape, boolean clip, RenderEffect renderEffect, long ambientShadowColor, long spotShadowColor, int compositingStrategy, DefaultConstructorMarker $constructor_marker) {
        this(scaleX, scaleY, alpha2, translationX, translationY, shadowElevation, rotationX, rotationY, rotationZ, cameraDistance, transformOrigin, shape, clip, renderEffect, ambientShadowColor, spotShadowColor, compositingStrategy);
    }
}

