/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.annotation.RestrictTo;
import androidx.collection.FloatFloatPair;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nBezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,1010:1\n154#1:1011\n472#1:1012\n473#1:1023\n472#1:1024\n473#1:1035\n472#1:1036\n473#1:1047\n472#1:1048\n473#1:1059\n472#1:1060\n473#1:1071\n454#1:1072\n454#1:1073\n454#1:1074\n472#1:1075\n473#1:1086\n472#1:1087\n473#1:1098\n472#1:1099\n473#1:1110\n472#1:1121\n473#1:1132\n472#1:1133\n473#1:1144\n472#1:1145\n473#1:1156\n472#1:1157\n473#1:1168\n472#1:1169\n473#1:1180\n472#1:1181\n473#1:1192\n273#1:1193\n273#1:1194\n984#1:1195\n984#1:1196\n998#1:1197\n998#1:1198\n273#1:1199\n472#1:1210\n473#1:1221\n456#1:1222\n456#1:1225\n65#2,10:1013\n65#2,10:1025\n65#2,10:1037\n65#2,10:1049\n65#2,10:1061\n65#2,10:1076\n65#2,10:1088\n65#2,10:1100\n83#2,10:1111\n65#2,10:1122\n65#2,10:1134\n65#2,10:1146\n65#2,10:1158\n65#2,10:1170\n65#2,10:1182\n65#2,10:1200\n65#2,10:1211\n46#2:1223\n56#2:1224\n65#2,10:1226\n*S KotlinDebug\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n*L\n131#1:1011\n131#1:1012\n131#1:1023\n154#1:1024\n154#1:1035\n174#1:1036\n174#1:1047\n177#1:1048\n177#1:1059\n179#1:1060\n179#1:1071\n208#1:1072\n210#1:1073\n212#1:1074\n215#1:1075\n215#1:1086\n220#1:1087\n220#1:1098\n223#1:1099\n223#1:1110\n244#1:1121\n244#1:1132\n247#1:1133\n247#1:1144\n250#1:1145\n250#1:1156\n254#1:1157\n254#1:1168\n257#1:1169\n257#1:1180\n264#1:1181\n264#1:1192\n347#1:1193\n362#1:1194\n381#1:1195\n382#1:1196\n406#1:1197\n407#1:1198\n439#1:1199\n483#1:1210\n483#1:1221\n618#1:1222\n805#1:1225\n131#1:1013,10\n154#1:1025,10\n174#1:1037,10\n177#1:1049,10\n179#1:1061,10\n215#1:1076,10\n220#1:1088,10\n223#1:1100,10\n240#1:1111,10\n244#1:1122,10\n247#1:1134,10\n250#1:1146,10\n254#1:1158,10\n257#1:1170,10\n264#1:1182,10\n472#1:1200,10\n483#1:1211,10\n783#1:1223\n786#1:1224\n845#1:1226,10\n*E\n"})
public final class BezierKt {
    private static final float evaluateCubic(float p0, float p1, float p2, float p3, float t2) {
        float a = p3 + 3.0f * (p1 - p2) - p0;
        float b = 3.0f * (p2 - 2.0f * p1 + p0);
        float c = 3.0f * (p1 - p0);
        return ((a * t2 + b) * t2 + c) * t2 + p0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float evaluateCubic(float p1, float p2, float t2) {
        float a = 0.33333334f + (p1 - p2);
        float b = p2 - 2.0f * p1;
        float c = p1;
        return 3.0f * ((a * t2 + b) * t2 + c) * t2;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float findFirstCubicRoot(float p0, float p1, float p2, float p3) {
        void $this$fastCoerceAtMost$iv$iv$iv;
        void minimumValue$iv$iv;
        void $this$fastCoerceIn$iv$iv;
        double $this$closeTo$iv;
        double d;
        double a = 3.0 * ((double)p0 - 2.0 * (double)p1 + (double)p2);
        double b = 3.0 * (double)(p1 - p0);
        double c = p0;
        double d2 = d = (double)(-p0) + 3.0 * (double)(p1 - p2) + (double)p3;
        double b$iv = 0.0;
        boolean $i$f$closeTo = false;
        if (Math.abs((double)($this$closeTo$iv - b$iv)) < 1.0E-7) {
            float root;
            void $this$fastCoerceAtMost$iv$iv$iv2;
            float minimumValue$iv$iv2;
            float $this$fastCoerceIn$iv$iv2;
            $this$closeTo$iv = a;
            b$iv = 0.0;
            $i$f$closeTo = false;
            if (Math.abs($this$closeTo$iv - b$iv) < 1.0E-7) {
                void $this$fastCoerceAtMost$iv$iv$iv3;
                void minimumValue$iv$iv3;
                void $this$fastCoerceIn$iv$iv3;
                $this$closeTo$iv = b;
                b$iv = 0.0;
                $i$f$closeTo = false;
                if (Math.abs($this$closeTo$iv - b$iv) < 1.0E-7) {
                    return Float.NaN;
                }
                float r$iv = (float)(-c / b);
                boolean $i$f$clampValidRootInUnitRange = false;
                float b$iv2 = r$iv;
                float f = 0.0f;
                float maximumValue$iv$iv = 1.0f;
                boolean $i$f$fastCoerceIn = false;
                void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv3;
                boolean $i$f$fastCoerceAtLeast = false;
                $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv3 ? minimumValue$iv$iv3 : $this$fastCoerceAtLeast$iv$iv$iv;
                boolean $i$f$fastCoerceAtMost = false;
                float s$iv = $this$fastCoerceAtMost$iv$iv$iv3 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv3;
                return Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
            }
            double q = Math.sqrt(b * b - 4.0 * a * c);
            double a2 = 2.0 * a;
            float r$iv = (float)((q - b) / a2);
            boolean $i$f$clampValidRootInUnitRange = false;
            float $i$f$fastCoerceAtMost = r$iv;
            float s$iv = 0.0f;
            float maximumValue$iv$iv = 1.0f;
            boolean $i$f$fastCoerceIn = false;
            float $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv2;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv2 ? minimumValue$iv$iv2 : $this$fastCoerceAtLeast$iv$iv$iv;
            boolean $i$f$fastCoerceAtMost2 = false;
            float s$iv2 = $this$fastCoerceAtMost$iv$iv$iv2 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv2;
            float f = root = Math.abs(s$iv2 - r$iv) > 1.05E-6f ? Float.NaN : s$iv2;
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((-b - q) / a2);
            $i$f$clampValidRootInUnitRange = false;
            $this$fastCoerceIn$iv$iv2 = r$iv;
            minimumValue$iv$iv2 = 0.0f;
            maximumValue$iv$iv = 1.0f;
            $i$f$fastCoerceIn = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv2;
            $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv2 ? minimumValue$iv$iv2 : $this$fastCoerceAtLeast$iv$iv$iv;
            $i$f$fastCoerceAtMost2 = false;
            s$iv2 = $this$fastCoerceAtMost$iv$iv$iv2 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv2;
            return Math.abs(s$iv2 - r$iv) > 1.05E-6f ? Float.NaN : s$iv2;
        }
        double o3 = (3.0 * (b /= d) - (a /= d) * a) / 9.0;
        double q2 = (2.0 * a * a * a - 9.0 * a * b + 27.0 * (c /= d)) / 54.0;
        double discriminant = q2 * q2 + o3 * o3 * o3;
        double a3 = a / 3.0;
        if (discriminant < 0.0) {
            float root;
            void $this$fastCoerceAtMost$iv$iv$iv4;
            float minimumValue$iv$iv4;
            float $this$fastCoerceIn$iv$iv4;
            void $this$fastCoerceAtMost$iv$iv22;
            void minimumValue$iv;
            void $this$fastCoerceIn$iv;
            double t2;
            double mp33 = -(o3 * o3 * o3);
            double r = Math.sqrt(mp33);
            double d3 = t2 = -q2 / r;
            double d4 = -1.0;
            double maximumValue$iv = 1.0;
            boolean $i$f$fastCoerceIn22 = false;
            void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
            boolean $i$f$fastCoerceAtMost = false;
            double cosPhi = $this$fastCoerceAtMost$iv$iv22 > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv22;
            double phi = Math.acos(cosPhi);
            float t1 = 2.0f * MathHelpersKt.fastCbrt((float)r);
            float r$iv = (float)((double)t1 * Math.cos(phi / 3.0) - a3);
            boolean $i$f$clampValidRootInUnitRange = false;
            float $i$f$fastCoerceIn22 = r$iv;
            float $this$fastCoerceAtMost$iv$iv22 = 0.0f;
            float maximumValue$iv$iv = 1.0f;
            boolean $i$f$fastCoerceIn = false;
            float $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv4;
            boolean $i$f$fastCoerceAtLeast2 = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv4 ? minimumValue$iv$iv4 : $this$fastCoerceAtLeast$iv$iv$iv;
            boolean $i$f$fastCoerceAtMost3 = false;
            float s$iv = $this$fastCoerceAtMost$iv$iv$iv4 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv4;
            float f = root = Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((double)t1 * Math.cos((phi + Math.PI * 2) / 3.0) - a3);
            $i$f$clampValidRootInUnitRange = false;
            $this$fastCoerceIn$iv$iv4 = r$iv;
            minimumValue$iv$iv4 = 0.0f;
            maximumValue$iv$iv = 1.0f;
            $i$f$fastCoerceIn = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv4;
            $i$f$fastCoerceAtLeast2 = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv4 ? minimumValue$iv$iv4 : $this$fastCoerceAtLeast$iv$iv$iv;
            $i$f$fastCoerceAtMost3 = false;
            s$iv = $this$fastCoerceAtMost$iv$iv$iv4 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv4;
            float f2 = root = Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((double)t1 * Math.cos((phi + Math.PI * 4) / 3.0) - a3);
            $i$f$clampValidRootInUnitRange = false;
            $this$fastCoerceIn$iv$iv4 = r$iv;
            minimumValue$iv$iv4 = 0.0f;
            maximumValue$iv$iv = 1.0f;
            $i$f$fastCoerceIn = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv4;
            $i$f$fastCoerceAtLeast2 = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv4 ? minimumValue$iv$iv4 : $this$fastCoerceAtLeast$iv$iv$iv;
            $i$f$fastCoerceAtMost3 = false;
            s$iv = $this$fastCoerceAtMost$iv$iv$iv4 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv4;
            return Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
        }
        if (discriminant == 0.0) {
            float root;
            void $this$fastCoerceAtMost$iv$iv$iv5;
            float minimumValue$iv$iv5;
            float $this$fastCoerceIn$iv$iv5;
            float u1 = -MathHelpersKt.fastCbrt((float)q2);
            float r$iv = 2.0f * u1 - (float)a3;
            boolean $i$f$clampValidRootInUnitRange = false;
            float t2 = r$iv;
            float s$iv = 0.0f;
            float maximumValue$iv$iv = 1.0f;
            boolean $i$f$fastCoerceIn = false;
            float $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv5;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv5 ? minimumValue$iv$iv5 : $this$fastCoerceAtLeast$iv$iv$iv;
            boolean $i$f$fastCoerceAtMost = false;
            float s$iv3 = $this$fastCoerceAtMost$iv$iv$iv5 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv5;
            float f = root = Math.abs(s$iv3 - r$iv) > 1.05E-6f ? Float.NaN : s$iv3;
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = -u1 - (float)a3;
            $i$f$clampValidRootInUnitRange = false;
            $this$fastCoerceIn$iv$iv5 = r$iv;
            minimumValue$iv$iv5 = 0.0f;
            maximumValue$iv$iv = 1.0f;
            $i$f$fastCoerceIn = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv5;
            $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv5 ? minimumValue$iv$iv5 : $this$fastCoerceAtLeast$iv$iv$iv;
            $i$f$fastCoerceAtMost = false;
            s$iv3 = $this$fastCoerceAtMost$iv$iv$iv5 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv5;
            return Math.abs(s$iv3 - r$iv) > 1.05E-6f ? Float.NaN : s$iv3;
        }
        double sd = Math.sqrt(discriminant);
        float u1 = MathHelpersKt.fastCbrt((float)(-q2 + sd));
        float v1 = MathHelpersKt.fastCbrt((float)(q2 + sd));
        float r$iv = (float)((double)(u1 - v1) - a3);
        boolean $i$f$clampValidRootInUnitRange = false;
        float maximumValue$iv$iv = r$iv;
        float $i$f$fastCoerceIn = 0.0f;
        float maximumValue$iv$iv2 = 1.0f;
        boolean $i$f$fastCoerceIn2 = false;
        void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float s$iv = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv2 ? maximumValue$iv$iv2 : $this$fastCoerceAtMost$iv$iv$iv;
        return Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
    }

    private static final int findQuadraticRoots(float p0, float p1, float p2, float[] roots, int index) {
        double a = p0;
        double b = p1;
        double c = p2;
        double d = a - 2.0 * b + c;
        int rootCount = 0;
        if (!(d == 0.0)) {
            double v1 = -Math.sqrt(b * b - a * c);
            double v2 = -a + b;
            rootCount += BezierKt.writeValidRootInUnitRange((float)(-(v1 + v2) / d), roots, index);
            if ((rootCount += BezierKt.writeValidRootInUnitRange((float)((v1 - v2) / d), roots, index + rootCount)) > 1) {
                float s = roots[index];
                float t2 = roots[index + 1];
                if (s > t2) {
                    roots[index] = t2;
                    roots[index + 1] = s;
                } else if (s == t2) {
                    --rootCount;
                }
            }
        } else if (!(b == c)) {
            rootCount += BezierKt.writeValidRootInUnitRange((float)((2.0 * b - c) / (2.0 * b - 2.0 * c)), roots, index);
        }
        return rootCount;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final long computeCubicVerticalBounds(float p0y, float p1y, float p2y, float p3y, @NotNull float[] roots, int index) {
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        float d0 = 3.0f * (p1y - p0y);
        float d1 = 3.0f * (p2y - p1y);
        float d2 = 3.0f * (p3y - p2y);
        int count = BezierKt.findQuadraticRoots(d0, d1, d2, roots, index);
        float dd0 = 2.0f * (d1 - d0);
        float dd1 = 2.0f * (d2 - d1);
        int index$iv = index + count;
        boolean $i$f$findLineRoot = false;
        float minY = Math.min(p0y, p3y);
        float maxY = Math.max(p0y, p3y);
        int n = count += BezierKt.writeValidRootInUnitRange(-dd0 / (dd1 - dd0), roots, index$iv);
        for (int i2 = 0; i2 < n; ++i2) {
            float t2 = roots[i2];
            float y = BezierKt.evaluateCubic(p0y, p1y, p2y, p3y, t2);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return FloatFloatPair.constructor-impl((float)minY, (float)maxY);
    }

    /*
     * WARNING - void declaration
     */
    private static final int writeValidRootInUnitRange(float r, float[] roots, int index) {
        float v;
        void $this$fastCoerceAtMost$iv$iv$iv;
        void minimumValue$iv$iv;
        void $this$fastCoerceIn$iv$iv;
        boolean $i$f$clampValidRootInUnitRange = false;
        float f = r;
        float f2 = 0.0f;
        float maximumValue$iv$iv = 1.0f;
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float s$iv = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
        roots[index] = v = Math.abs(s$iv - r) > 1.05E-6f ? Float.NaN : s$iv;
        return Float.isNaN(v) ? 0 : 1;
    }
}

