/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.collection.MutableScatterMap;
import androidx.collection.ScatterMap;
import androidx.collection.ScatterMapKt;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.ComposeUiFlags;
import androidx.compose.ui.focus.FocusStateImpl;
import androidx.compose.ui.focus.FocusTargetNode;
import androidx.compose.ui.internal.InlineClassHelperKt;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nFocusTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FocusTransactionManager.kt\nandroidx/compose/ui/focus/FocusTransactionManager\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 6 ScatterMap.kt\nandroidx/collection/ScatterMap\n+ 7 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n*L\n1#1,122:1\n1101#2:123\n1083#2,2:124\n1#3:126\n641#4,2:127\n641#4,2:129\n424#4,8:160\n78#5,5:131\n365#6,3:136\n329#6,6:139\n339#6,3:146\n342#6,9:150\n368#6:159\n1399#7:145\n1270#7:149\n*S KotlinDebug\n*F\n+ 1 FocusTransactionManager.kt\nandroidx/compose/ui/focus/FocusTransactionManager\n*L\n32#1:123\n32#1:124,2\n55#1:127,2\n72#1:129,2\n118#1:160,8\n100#1:131,5\n109#1:136,3\n109#1:139,6\n109#1:146,3\n109#1:150,9\n109#1:159\n109#1:145\n109#1:149\n*E\n"})
public final class FocusTransactionManager {
    @NotNull
    private final MutableScatterMap<FocusTargetNode, FocusStateImpl> states = ScatterMapKt.mutableScatterMapOf();
    @NotNull
    private final MutableVector<Function0<Unit>> cancellationListener;
    private boolean ongoingTransaction;
    private int generation;
    public static final int $stable = 8;

    public FocusTransactionManager() {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.cancellationListener = new MutableVector<Function0>(new Function0[capacity$iv$iv], 0);
    }

    public final boolean getOngoingTransaction() {
        return this.ongoingTransaction;
    }

    public final int getGeneration() {
        return this.generation;
    }

    @Nullable
    public final FocusStateImpl getUncommittedFocusState(@NotNull FocusTargetNode $this$uncommittedFocusState) {
        Intrinsics.checkNotNullParameter((Object)$this$uncommittedFocusState, (String)"<this>");
        if (ComposeUiFlags.isTrackFocusEnabled) {
            throw new IllegalStateException("uncommittedFocusState must not be accessed when isTrackFocusEnabled is on".toString());
        }
        return (FocusStateImpl)this.states.get((Object)$this$uncommittedFocusState);
    }

    public final void setUncommittedFocusState(@NotNull FocusTargetNode $this$uncommittedFocusState, @Nullable FocusStateImpl value2) {
        Intrinsics.checkNotNullParameter((Object)$this$uncommittedFocusState, (String)"<this>");
        if (!ComposeUiFlags.isTrackFocusEnabled) {
            FocusStateImpl currentFocusState;
            FocusStateImpl focusStateImpl = (FocusStateImpl)this.states.get((Object)$this$uncommittedFocusState);
            if (focusStateImpl == null) {
                focusStateImpl = FocusStateImpl.Inactive;
            }
            if ((currentFocusState = focusStateImpl) != value2) {
                int n = this.generation;
                this.generation = n + 1;
            }
            MutableScatterMap<FocusTargetNode, FocusStateImpl> mutableScatterMap = this.states;
            FocusTargetNode focusTargetNode2 = $this$uncommittedFocusState;
            boolean $i$f$checkPreconditionNotNull = false;
            if (value2 == null) {
                FocusTargetNode focusTargetNode3 = focusTargetNode2;
                MutableScatterMap<FocusTargetNode, FocusStateImpl> mutableScatterMap2 = mutableScatterMap;
                boolean bl = false;
                String string = "requires a non-null focus state";
                MutableScatterMap<FocusTargetNode, FocusStateImpl> mutableScatterMap3 = mutableScatterMap2;
                FocusTargetNode focusTargetNode4 = focusTargetNode3;
                InlineClassHelperKt.throwIllegalStateExceptionForNullCheck(string);
                throw new KotlinNothingValueException();
            }
            mutableScatterMap.set((Object)focusTargetNode2, (Object)value2);
        }
    }

    private final void beginTransaction() {
        this.ongoingTransaction = true;
    }

    private final void commitTransaction() {
        ScatterMap this_$iv = (ScatterMap)this.states;
        boolean $i$f$forEachKey = false;
        Object[] k$iv = this_$iv.keys;
        ScatterMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            FocusTargetNode focusTargetNode2 = (FocusTargetNode)k$iv[index$iv];
                            boolean bl2 = false;
                            focusTargetNode2.commitFocusState$ui();
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this.states.clear();
        this.ongoingTransaction = false;
        this.cancellationListener.clear();
    }

    private final void cancelTransaction() {
        this.states.clear();
        this.ongoingTransaction = false;
        MutableVector<Function0<Unit>> this_$iv = this.cancellationListener;
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            Function0 it = (Function0)content$iv[i$iv];
            boolean bl = false;
            it.invoke();
        }
        this.cancellationListener.clear();
    }

    public static final /* synthetic */ void access$cancelTransaction(FocusTransactionManager $this) {
        $this.cancelTransaction();
    }

    public static final /* synthetic */ void access$beginTransaction(FocusTransactionManager $this) {
        $this.beginTransaction();
    }

    public static final /* synthetic */ void access$commitTransaction(FocusTransactionManager $this) {
        $this.commitTransaction();
    }

    public static final /* synthetic */ MutableVector access$getCancellationListener$p(FocusTransactionManager $this) {
        return $this.cancellationListener;
    }
}

