/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots.tooling;

import androidx.collection.ScatterSet;
import androidx.compose.runtime.collection.ScatterSetWrapperKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentList;
import androidx.compose.runtime.snapshots.Snapshot;
import androidx.compose.runtime.snapshots.StateObject;
import androidx.compose.runtime.snapshots.tooling.SnapshotInstanceObservers;
import androidx.compose.runtime.snapshots.tooling.SnapshotObserver;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSnapshotObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotObserver.kt\nandroidx/compose/runtime/snapshots/tooling/SnapshotObserverKt\n+ 2 Snapshot.kt\nandroidx/compose/runtime/snapshots/SnapshotKt\n+ 3 Synchronization.desktop.kt\nandroidx/compose/runtime/platform/Synchronization_desktopKt\n+ 4 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n2031#2:270\n2031#2:292\n26#3:271\n26#3:293\n34#4,5:272\n34#4,5:277\n34#4,5:282\n34#4,5:287\n1#5:294\n*S KotlinDebug\n*F\n+ 1 SnapshotObserver.kt\nandroidx/compose/runtime/snapshots/tooling/SnapshotObserverKt\n*L\n174#1:270\n176#1:292\n174#1:271\n176#1:293\n219#1:272,5\n250#1:277,5\n258#1:282,5\n266#1:287,5\n*E\n"})
public final class SnapshotObserverKt {
    @Nullable
    private static PersistentList<? extends SnapshotObserver> observers;

    @NotNull
    public static final Pair<SnapshotInstanceObservers, Map<SnapshotObserver, SnapshotInstanceObservers>> mergeObservers(@NotNull PersistentList<? extends SnapshotObserver> $this$mergeObservers, @Nullable Snapshot parent, boolean readonly, @Nullable Function1<Object, Unit> readObserver, @Nullable Function1<Object, Unit> writeObserver) {
        Intrinsics.checkNotNullParameter($this$mergeObservers, (String)"<this>");
        Function1<Object, Unit> currentReadObserver = null;
        currentReadObserver = readObserver;
        Function1<Object, Unit> currentWriteObserver = null;
        currentWriteObserver = writeObserver;
        Map observerMap = null;
        List $this$fastForEach$iv = $this$mergeObservers;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            SnapshotObserver observer = (SnapshotObserver)item$iv;
            boolean bl = false;
            SnapshotInstanceObservers instance2 = observer.onPreCreate(parent, readonly);
            if (instance2 == null) continue;
            currentReadObserver = SnapshotObserverKt.mergeObservers(instance2.getReadObserver(), currentReadObserver);
            currentWriteObserver = SnapshotObserverKt.mergeObservers(instance2.getWriteObserver(), currentWriteObserver);
            Map map2 = observerMap;
            if (map2 == null) {
                Map newMap;
                PersistentList<? extends SnapshotObserver> $this$mergeObservers_u24lambda_u245_u24lambda_u244 = $this$mergeObservers;
                boolean bl2 = false;
                observerMap = newMap = (Map)new LinkedHashMap();
                map2 = newMap;
            }
            map2.put(observer, instance2);
        }
        return TuplesKt.to((Object)new SnapshotInstanceObservers(currentReadObserver, currentWriteObserver), observerMap);
    }

    private static final Function1<Object, Unit> mergeObservers(Function1<Object, Unit> a, Function1<Object, Unit> b) {
        Function1<Object, Unit> function1;
        if (a != null && b != null) {
            function1 = arg_0 -> SnapshotObserverKt.mergeObservers$lambda$6(a, b, arg_0);
        } else {
            function1 = a;
            if (function1 == null) {
                function1 = b;
            }
        }
        return function1;
    }

    public static final void dispatchCreatedObservers(@NotNull PersistentList<? extends SnapshotObserver> $this$dispatchCreatedObservers, @Nullable Snapshot parent, @NotNull Snapshot result2, @Nullable Map<SnapshotObserver, SnapshotInstanceObservers> observerMap) {
        Intrinsics.checkNotNullParameter($this$dispatchCreatedObservers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        List $this$fastForEach$iv = $this$dispatchCreatedObservers;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            SnapshotObserver observer = (SnapshotObserver)item$iv;
            boolean bl = false;
            Map<SnapshotObserver, SnapshotInstanceObservers> map2 = observerMap;
            SnapshotInstanceObservers instance2 = map2 != null ? map2.get(observer) : null;
            observer.onCreated(result2, parent, instance2);
        }
    }

    public static final void dispatchObserverOnPreDispose(@NotNull Snapshot snapshot2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
            PersistentList<? extends SnapshotObserver> persistentList = observers;
            if (persistentList == null) break block1;
            List $this$fastForEach$iv = persistentList;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                SnapshotObserver observer = (SnapshotObserver)item$iv;
                boolean bl = false;
                observer.onPreDispose(snapshot2);
            }
        }
    }

    public static final void dispatchObserverOnApplied(@NotNull Snapshot snapshot2, @Nullable ScatterSet<StateObject> changes) {
        Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
        PersistentList<? extends SnapshotObserver> observers = SnapshotObserverKt.observers;
        Collection collection = observers;
        if (!(collection == null || collection.isEmpty())) {
            Object object = changes;
            if (object == null || (object = ScatterSetWrapperKt.wrapIntoSet(object)) == null) {
                object = SetsKt.emptySet();
            }
            Object wrappedChanges = object;
            List $this$fastForEach$iv = observers;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                SnapshotObserver observer = (SnapshotObserver)item$iv;
                boolean bl = false;
                observer.onApplied(snapshot2, (Set<? extends Object>)wrappedChanges);
            }
        }
    }

    private static final Unit mergeObservers$lambda$6(Function1 $a, Function1 $b, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $a.invoke(it);
        $b.invoke(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ PersistentList access$getObservers$p() {
        return observers;
    }
}

