/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.internal.Utils_jvmKt;
import androidx.compose.runtime.internal.WeakReference;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSnapshotWeakSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotWeakSet.kt\nandroidx/compose/runtime/snapshots/SnapshotWeakSet\n+ 2 ArrayUtils.nonAndroid.kt\nandroidx/compose/runtime/collection/ArrayUtils_nonAndroidKt\n*L\n1#1,243:1\n23#2:244\n23#2:245\n23#2:246\n*S KotlinDebug\n*F\n+ 1 SnapshotWeakSet.kt\nandroidx/compose/runtime/snapshots/SnapshotWeakSet\n*L\n74#1:244\n80#1:245\n96#1:246\n*E\n"})
public final class SnapshotWeakSet<T> {
    private int size;
    @NotNull
    private int[] hashes = new int[16];
    @NotNull
    private WeakReference<T>[] values = new WeakReference[16];
    public static final int $stable = 8;

    public final int getSize$runtime() {
        return this.size;
    }

    public final void setSize$runtime(int n) {
        this.size = n;
    }

    @NotNull
    public final int[] getHashes$runtime() {
        return this.hashes;
    }

    @NotNull
    public final WeakReference<T>[] getValues$runtime() {
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        int index = 0;
        int size = this.size;
        int hash = Utils_jvmKt.identityHashCode(value2);
        if (size > 0) {
            index = this.find(value2, hash);
            if (index >= 0) {
                return false;
            }
        } else {
            index = -1;
        }
        int insertIndex = -(index + 1);
        int capacity = this.values.length;
        if (size == capacity) {
            void startIndex$iv;
            int destinationOffset$iv;
            Object[] $this$fastCopyInto$iv;
            int newCapacity = capacity * 2;
            Object[] newValues = new WeakReference[newCapacity];
            int[] newHashes = new int[newCapacity];
            WeakReference<T>[] weakReferenceArray = this.values;
            int n = insertIndex + 1;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])newValues, (int)destinationOffset$iv, (int)insertIndex, (int)size);
            $this$fastCopyInto$iv = this.values;
            destinationOffset$iv = 0;
            $i$f$fastCopyInto = false;
            boolean $i$f$fastCopyInto2 = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])newValues, (int)destinationOffset$iv, (int)startIndex$iv, (int)insertIndex);
            ArraysKt.copyInto((int[])this.hashes, (int[])newHashes, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto$default((int[])this.hashes, (int[])newHashes, (int)0, (int)0, (int)insertIndex, (int)6, null);
            this.values = newValues;
            this.hashes = newHashes;
        } else {
            void destinationOffset$iv;
            void destination$iv;
            void $this$fastCopyInto$iv;
            WeakReference<T>[] newCapacity = this.values;
            WeakReference<T>[] newValues = this.values;
            int newHashes = insertIndex + 1;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])destination$iv, (int)destinationOffset$iv, (int)insertIndex, (int)size);
            ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)(insertIndex + 1), (int)insertIndex, (int)size);
        }
        this.values[insertIndex] = new WeakReference<T>(value2);
        this.hashes[insertIndex] = hash;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    private final int find(T value2, int hash) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            Object midVal;
            int mid = low + high >>> 1;
            int midHash = this.hashes[mid];
            if (midHash < hash) {
                low = mid + 1;
                continue;
            }
            if (midHash > hash) {
                high = mid - 1;
                continue;
            }
            WeakReference<T> weakReference = this.values[mid];
            Object object = midVal = weakReference != null ? weakReference.get() : null;
            if (value2 == midVal) {
                return mid;
            }
            return this.findExactIndex(mid, value2, hash);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, T value2, int valueHash) {
        int i2;
        for (i2 = midIndex - 1; -1 < i2 && this.hashes[i2] == valueHash; --i2) {
            Object v;
            WeakReference<T> weakReference = this.values[i2];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value2) continue;
            return i2;
        }
        int n = this.size;
        for (i2 = midIndex + 1; i2 < n; ++i2) {
            Object v;
            if (this.hashes[i2] != valueHash) {
                return -(i2 + 1);
            }
            WeakReference<T> weakReference = this.values[i2];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value2) continue;
            return i2;
        }
        return -(this.size + 1);
    }
}

