/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.saveable;

import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.SaveableStateRegistry;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import java.util.Arrays;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRememberSaveable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RememberSaveable.kt\nandroidx/compose/runtime/saveable/SaveableHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
final class SaveableHolder<T>
implements RememberObserver,
SaverScope {
    @NotNull
    private Saver<T, Object> saver;
    @Nullable
    private SaveableStateRegistry registry;
    @NotNull
    private String key;
    private T value;
    @NotNull
    private Object[] inputs;
    @Nullable
    private SaveableStateRegistry.Entry entry;
    @NotNull
    private final Function0<Object> valueProvider;

    public SaveableHolder(@NotNull Saver<T, Object> saver, @Nullable SaveableStateRegistry registry, @NotNull String key2, T value2, @NotNull Object[] inputs) {
        Intrinsics.checkNotNullParameter(saver, (String)"saver");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        this.saver = saver;
        this.registry = registry;
        this.key = key2;
        this.value = value2;
        this.inputs = inputs;
        this.valueProvider = () -> SaveableHolder.valueProvider$lambda$2(this);
    }

    public final void update(@NotNull Saver<T, Object> saver, @Nullable SaveableStateRegistry registry, @NotNull String key2, T value2, @NotNull Object[] inputs) {
        Intrinsics.checkNotNullParameter(saver, (String)"saver");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        boolean entryIsOutdated = false;
        if (this.registry != registry) {
            this.registry = registry;
            entryIsOutdated = true;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)key2)) {
            this.key = key2;
            entryIsOutdated = true;
        }
        this.saver = saver;
        this.value = value2;
        this.inputs = inputs;
        if (this.entry != null && entryIsOutdated) {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry != null) {
                entry.unregister();
            }
            this.entry = null;
            this.register();
        }
    }

    private final void register() {
        SaveableStateRegistry registry = this.registry;
        if (!(this.entry == null)) {
            boolean bl = false;
            String string = "entry(" + this.entry + ") is not null";
            throw new IllegalArgumentException(string.toString());
        }
        if (registry != null) {
            RememberSaveableKt.access$requireCanBeSaved(registry, this.valueProvider.invoke());
            this.entry = registry.registerProvider(this.key, this.valueProvider);
        }
    }

    @Override
    public boolean canBeSaved(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        SaveableStateRegistry registry = this.registry;
        return registry == null || registry.canBeSaved(value2);
    }

    @Override
    public void onRemembered() {
        this.register();
    }

    @Override
    public void onForgotten() {
        block0: {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry == null) break block0;
            entry.unregister();
        }
    }

    @Override
    public void onAbandoned() {
        block0: {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry == null) break block0;
            entry.unregister();
        }
    }

    @Nullable
    public final T getValueIfInputsDidntChange(@NotNull Object[] inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        return Arrays.equals(inputs, this.inputs) ? (T)this.value : null;
    }

    private static final Object valueProvider$lambda$2(SaveableHolder this$0) {
        Saver $this$valueProvider_u24lambda_u242_u24lambda_u241 = this$0.saver;
        boolean bl = false;
        Saver saver = $this$valueProvider_u24lambda_u242_u24lambda_u241;
        SaverScope saverScope = this$0;
        Object t2 = this$0.value;
        if (t2 == null) {
            SaverScope saverScope2 = saverScope;
            Saver saver2 = saver;
            boolean bl2 = false;
            String string = "Value should be initialized";
            Saver saver3 = saver2;
            SaverScope saverScope3 = saverScope2;
            String string2 = string;
            throw new IllegalArgumentException(string2.toString());
        }
        return saver.save(saverScope, t2);
    }
}

