/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.internal;

import androidx.collection.IntList;
import androidx.collection.MutableIntList;
import androidx.collection.MutableScatterMap;
import androidx.collection.MutableScatterSet;
import androidx.collection.ScatterMapKt;
import androidx.collection.ScatterSetKt;
import androidx.compose.runtime.ComposeNodeLifecycleCallback;
import androidx.compose.runtime.RecomposeScopeImpl;
import androidx.compose.runtime.RememberManager;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.RememberObserverHolder;
import androidx.compose.runtime.Stack;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.PausedCompositionRemembers;
import androidx.compose.runtime.internal.RememberEventDispatcherKt;
import androidx.compose.runtime.internal.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRememberEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RememberEventDispatcher.kt\nandroidx/compose/runtime/internal/RememberEventDispatcher\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Trace.kt\nandroidx/compose/runtime/internal/TraceKt\n+ 6 IntList.kt\nandroidx/collection/IntList\n*L\n1#1,309:1\n1101#2:310\n1083#2,2:311\n1101#2:313\n1083#2,2:314\n1101#2:316\n1083#2,2:317\n641#3,2:319\n519#3:322\n472#3:326\n519#3:328\n424#3,8:334\n519#3:342\n424#3,8:346\n136#3:361\n1#4:321\n45#5,3:323\n49#5:327\n45#5,5:329\n45#5,3:343\n49#5:354\n45#5,5:355\n65#6:360\n*S KotlinDebug\n*F\n+ 1 RememberEventDispatcher.kt\nandroidx/compose/runtime/internal/RememberEventDispatcher\n*L\n61#1:310\n61#1:311,2\n63#1:313\n63#1:314,2\n64#1:316\n64#1:317,2\n88#1:319,2\n150#1:322\n154#1:326\n173#1:328\n179#1:334,8\n187#1:342\n189#1:346,8\n292#1:361\n151#1:323,3\n151#1:327\n174#1:329,5\n188#1:343,3\n188#1:354\n197#1:355,5\n232#1:360\n*E\n"})
public final class RememberEventDispatcher
implements RememberManager {
    @NotNull
    private final Set<RememberObserver> abandoning;
    @NotNull
    private final MutableVector<RememberObserverHolder> remembering;
    @NotNull
    private MutableVector<RememberObserverHolder> currentRememberingList;
    @NotNull
    private final MutableVector<Object> leaving;
    @NotNull
    private final MutableVector<Function0<Unit>> sideEffects;
    @Nullable
    private MutableScatterSet<ComposeNodeLifecycleCallback> releasing;
    @Nullable
    private MutableScatterMap<RecomposeScopeImpl, PausedCompositionRemembers> pausedPlaceholders;
    @NotNull
    private final List<Object> pending;
    @NotNull
    private final MutableIntList priorities;
    @NotNull
    private final MutableIntList afters;
    @Nullable
    private ArrayList<T> nestedRemembersLists;
    public static final int $stable = 8;

    public RememberEventDispatcher(@NotNull Set<RememberObserver> abandoning) {
        Intrinsics.checkNotNullParameter(abandoning, (String)"abandoning");
        this.abandoning = abandoning;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.remembering = new MutableVector<RememberObserverHolder>(new RememberObserverHolder[capacity$iv$iv], 0);
        this.currentRememberingList = this.remembering;
        $i$f$mutableVectorOf = false;
        capacity$iv$iv = 16;
        $i$f$MutableVector = false;
        this.leaving = new MutableVector<Object>(new Object[capacity$iv$iv], 0);
        $i$f$mutableVectorOf = false;
        capacity$iv$iv = 16;
        $i$f$MutableVector = false;
        this.sideEffects = new MutableVector<Function0>(new Function0[capacity$iv$iv], 0);
        this.pending = new ArrayList();
        this.priorities = new MutableIntList(0, 1, null);
        this.afters = new MutableIntList(0, 1, null);
    }

    @Override
    public void remembering(@NotNull RememberObserverHolder instance2) {
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        this.currentRememberingList.add(instance2);
    }

    @Override
    public void forgetting(@NotNull RememberObserverHolder instance2, int endRelativeOrder, int priority, int endRelativeAfter) {
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        this.recordLeaving(instance2, endRelativeOrder, priority, endRelativeAfter);
    }

    @Override
    public void sideEffect(@NotNull Function0<Unit> effect2) {
        Intrinsics.checkNotNullParameter(effect2, (String)"effect");
        MutableVector<Function0<Unit>> this_$iv = this.sideEffects;
        boolean $i$f$plusAssign = false;
        this_$iv.add(effect2);
    }

    @Override
    public void deactivating(@NotNull ComposeNodeLifecycleCallback instance2, int endRelativeOrder, int priority, int endRelativeAfter) {
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        this.recordLeaving(instance2, endRelativeOrder, priority, endRelativeAfter);
    }

    @Override
    public void releasing(@NotNull ComposeNodeLifecycleCallback instance2, int endRelativeOrder, int priority, int endRelativeAfter) {
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        MutableScatterSet mutableScatterSet = this.releasing;
        if (mutableScatterSet == null) {
            MutableScatterSet mutableScatterSet2;
            MutableScatterSet it = mutableScatterSet2 = ScatterSetKt.mutableScatterSetOf();
            boolean bl = false;
            this.releasing = it;
            mutableScatterSet = mutableScatterSet2;
        }
        MutableScatterSet releasing = mutableScatterSet;
        releasing.plusAssign((Object)instance2);
        this.recordLeaving(instance2, endRelativeOrder, priority, endRelativeAfter);
    }

    @Override
    public void rememberPausingScope(@NotNull RecomposeScopeImpl scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        PausedCompositionRemembers pausedPlaceholder = new PausedCompositionRemembers(this.abandoning);
        MutableScatterMap mutableScatterMap = this.pausedPlaceholders;
        if (mutableScatterMap == null) {
            MutableScatterMap mutableScatterMap2;
            MutableScatterMap it = mutableScatterMap2 = ScatterMapKt.mutableScatterMapOf();
            boolean bl = false;
            this.pausedPlaceholders = it;
            mutableScatterMap = mutableScatterMap2;
        }
        mutableScatterMap.set((Object)scope2, (Object)pausedPlaceholder);
        this.currentRememberingList.add(new RememberObserverHolder(pausedPlaceholder, null));
    }

    @Override
    public void startResumingScope(@NotNull RecomposeScopeImpl scope2) {
        PausedCompositionRemembers placeholder;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        MutableScatterMap<RecomposeScopeImpl, PausedCompositionRemembers> mutableScatterMap = this.pausedPlaceholders;
        PausedCompositionRemembers pausedCompositionRemembers = placeholder = mutableScatterMap != null ? (PausedCompositionRemembers)mutableScatterMap.get((Object)scope2) : null;
        if (placeholder != null) {
            ArrayList arrayList = this.nestedRemembersLists;
            if (arrayList == null) {
                ArrayList arrayList2;
                ArrayList it = arrayList2 = Stack.constructor-impl$default(null, 1, null);
                boolean bl = false;
                this.nestedRemembersLists = it;
                arrayList = arrayList2;
            }
            Stack.push-impl(arrayList, this.currentRememberingList);
            this.currentRememberingList = placeholder.getPausedRemembers();
        }
    }

    @Override
    public void endResumingScope(@NotNull RecomposeScopeImpl scope2) {
        PausedCompositionRemembers placeholder;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        MutableScatterMap<RecomposeScopeImpl, PausedCompositionRemembers> pausedPlaceholders = this.pausedPlaceholders;
        if (pausedPlaceholders != null && (placeholder = (PausedCompositionRemembers)pausedPlaceholders.get((Object)scope2)) != null) {
            RandomAccess randomAccess = this.nestedRemembersLists;
            if (randomAccess != null && (randomAccess = (MutableVector)Stack.pop-impl(randomAccess)) != null) {
                RandomAccess it = randomAccess;
                boolean bl = false;
                this.currentRememberingList = it;
            }
            pausedPlaceholders.remove((Object)scope2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatchRememberObservers() {
        Object token$iv;
        boolean $i$f$trace;
        String sectionName$iv;
        this.processPendingLeaving(Integer.MIN_VALUE);
        MutableVector<Object> this_$iv = this.leaving;
        boolean $i$f$isNotEmpty = false;
        if (this_$iv.getSize() != 0) {
            sectionName$iv = "Compose:onForgotten";
            $i$f$trace = false;
            token$iv = Trace.INSTANCE.beginSection(sectionName$iv);
            try {
                boolean $i$a$-trace-RememberEventDispatcher$dispatchRememberObservers$32 = false;
                MutableScatterSet<ComposeNodeLifecycleCallback> releasing = this.releasing;
                for (int i2 = this.leaving.getSize() - 1; -1 < i2; --i2) {
                    MutableVector<Object> this_$iv2 = this.leaving;
                    boolean $i$f$get = false;
                    Object instance2 = this_$iv2.content[i2];
                    if (instance2 instanceof RememberObserverHolder) {
                        RememberObserver wrapped = ((RememberObserverHolder)instance2).getWrapped();
                        this.abandoning.remove(wrapped);
                        wrapped.onForgotten();
                    }
                    if (!(instance2 instanceof ComposeNodeLifecycleCallback)) continue;
                    if (releasing != null && releasing.contains(instance2)) {
                        ((ComposeNodeLifecycleCallback)instance2).onRelease();
                        continue;
                    }
                    ((ComposeNodeLifecycleCallback)instance2).onDeactivate();
                }
                Unit $i$a$-trace-RememberEventDispatcher$dispatchRememberObservers$32 = Unit.INSTANCE;
            }
            finally {
                Trace.INSTANCE.endSection(token$iv);
            }
        }
        this_$iv = this.remembering;
        $i$f$isNotEmpty = false;
        if (this_$iv.getSize() != 0) {
            sectionName$iv = "Compose:onRemembered";
            $i$f$trace = false;
            token$iv = Trace.INSTANCE.beginSection(sectionName$iv);
            try {
                boolean bl = false;
                this.dispatchRememberList(this.remembering);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                Trace.INSTANCE.endSection(token$iv);
            }
        }
    }

    private final void dispatchRememberList(MutableVector<RememberObserverHolder> list2) {
        MutableVector<RememberObserverHolder> this_$iv = list2;
        boolean $i$f$forEach = false;
        T[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            RememberObserverHolder instance2 = (RememberObserverHolder)content$iv[i$iv];
            boolean bl = false;
            RememberObserver wrapped = instance2.getWrapped();
            this.abandoning.remove(wrapped);
            wrapped.onRemembered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatchSideEffects() {
        MutableVector<Function0<Unit>> this_$iv = this.sideEffects;
        boolean $i$f$isNotEmpty = false;
        if (this_$iv.getSize() != 0) {
            String sectionName$iv = "Compose:sideeffects";
            boolean $i$f$trace = false;
            Object token$iv = Trace.INSTANCE.beginSection(sectionName$iv);
            try {
                boolean bl = false;
                MutableVector<Function0<Unit>> this_$iv2 = this.sideEffects;
                boolean $i$f$forEach = false;
                T[] content$iv = this_$iv2.content;
                int size$iv = this_$iv2.getSize();
                for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                    Function0 sideEffect = (Function0)content$iv[i$iv];
                    boolean bl2 = false;
                    sideEffect.invoke();
                }
                this.sideEffects.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                Trace.INSTANCE.endSection(token$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatchAbandons() {
        if (!((Collection)this.abandoning).isEmpty()) {
            String sectionName$iv = "Compose:abandons";
            boolean $i$f$trace = false;
            Object token$iv = Trace.INSTANCE.beginSection(sectionName$iv);
            try {
                boolean bl = false;
                Iterator<RememberObserver> iterator2 = this.abandoning.iterator();
                while (iterator2.hasNext()) {
                    RememberObserver instance2 = iterator2.next();
                    iterator2.remove();
                    instance2.onAbandoned();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                Trace.INSTANCE.endSection(token$iv);
            }
        }
    }

    private final void recordLeaving(Object instance2, int endRelativeOrder, int priority, int endRelativeAfter) {
        boolean bl;
        this.processPendingLeaving(endRelativeOrder);
        boolean bl2 = 0 <= endRelativeAfter ? endRelativeAfter < endRelativeOrder : false;
        if (bl2) {
            this.pending.add(instance2);
            this.priorities.add(priority);
            bl = this.afters.add(endRelativeAfter);
        } else {
            bl = this.leaving.add(instance2);
        }
    }

    private final void processPendingLeaving(int endRelativeOrder) {
        if (!((Collection)this.pending).isEmpty()) {
            int endRelativeAfter;
            int index = 0;
            List toAdd = null;
            Object[] toAddAfter = null;
            Object[] toAddPriority = null;
            while (true) {
                IntList this_$iv = (IntList)this.afters;
                boolean $i$f$getSize = false;
                if (index >= this_$iv._size) break;
                if (endRelativeOrder <= this.afters.get(index)) {
                    Object instance2 = this.pending.remove(index);
                    endRelativeAfter = this.afters.removeAt(index);
                    int priority = this.priorities.removeAt(index);
                    if (toAdd == null) {
                        Object[] objectArray = new Object[]{instance2};
                        toAdd = CollectionsKt.mutableListOf((Object[])objectArray);
                        Object[] it = objectArray = new MutableIntList(0, 1, null);
                        boolean bl = false;
                        it.add(endRelativeAfter);
                        toAddAfter = objectArray;
                        it = objectArray = new MutableIntList(0, 1, null);
                        boolean bl2 = false;
                        it.add(priority);
                        toAddPriority = objectArray;
                        continue;
                    }
                    Intrinsics.checkNotNull(toAddPriority, (String)"null cannot be cast to non-null type androidx.collection.MutableIntList");
                    Intrinsics.checkNotNull(toAddAfter, (String)"null cannot be cast to non-null type androidx.collection.MutableIntList");
                    toAdd.add(instance2);
                    toAddAfter.add(endRelativeAfter);
                    toAddPriority.add(priority);
                    continue;
                }
                ++index;
            }
            if (toAdd != null) {
                Intrinsics.checkNotNull(toAddPriority, (String)"null cannot be cast to non-null type androidx.collection.MutableIntList");
                Intrinsics.checkNotNull(toAddAfter, (String)"null cannot be cast to non-null type androidx.collection.MutableIntList");
                endRelativeAfter = toAdd.size() - 1;
                for (int i2 = 0; i2 < endRelativeAfter; ++i2) {
                    int n = toAdd.size();
                    for (int j = i2 + 1; j < n; ++j) {
                        int jAfter;
                        int iAfter = toAddAfter.get(i2);
                        if (iAfter >= (jAfter = toAddAfter.get(j)) && (jAfter != iAfter || toAddPriority.get(i2) >= toAddPriority.get(j))) continue;
                        RememberEventDispatcherKt.access$swap(toAdd, i2, j);
                        RememberEventDispatcherKt.access$swap(toAddPriority, i2, j);
                        RememberEventDispatcherKt.access$swap((MutableIntList)toAddAfter, i2, j);
                    }
                }
                MutableVector<Object> this_$iv = this.leaving;
                boolean $i$f$addAll = false;
                this_$iv.addAll(this_$iv.getSize(), toAdd);
            }
        }
    }
}

