/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.persistentOrderedSet;

import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.persistentOrderedSet.Links;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentOrderedSetIterator<E>
implements Iterator<E>,
KMappedMarker {
    @Nullable
    private Object nextElement;
    @NotNull
    private final Map<E, Links> map;
    private int index;
    public static final int $stable = 8;

    public PersistentOrderedSetIterator(@Nullable Object nextElement, @NotNull Map<E, Links> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.nextElement = nextElement;
        this.map = map2;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.map.size();
    }

    @Override
    public E next() {
        this.checkHasNext();
        Object result2 = this.nextElement;
        int n = this.index;
        this.index = n + 1;
        Links links = this.map.get(result2);
        if (links == null) {
            boolean bl = false;
            throw new ConcurrentModificationException("Hash code of an element (" + result2 + ") has changed after it was added to the persistent set.");
        }
        this.nextElement = links.getNext();
        return (E)result2;
    }

    private final void checkHasNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

