/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap;

import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBaseIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNode;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNodeBaseIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNodeKt;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMapBuilderBaseIterator<K, V, T>
extends PersistentHashMapBaseIterator<K, V, T>
implements Iterator<T>,
KMutableIterator {
    @NotNull
    private final PersistentHashMapBuilder<K, V> builder;
    @Nullable
    private K lastIteratedKey;
    private boolean nextWasInvoked;
    private int expectedModCount;
    public static final int $stable = 8;

    public PersistentHashMapBuilderBaseIterator(@NotNull PersistentHashMapBuilder<K, V> builder, @NotNull TrieNodeBaseIterator<K, V, T>[] path2) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        super(builder.getNode$runtime(), path2);
        this.builder = builder;
        this.expectedModCount = this.builder.getModCount$runtime();
    }

    @Override
    public T next() {
        this.checkForComodification();
        this.lastIteratedKey = this.currentKey();
        this.nextWasInvoked = true;
        return super.next();
    }

    @Override
    public void remove() {
        this.checkNextWasInvoked();
        if (this.hasNext()) {
            Object currentKey = this.currentKey();
            Map map2 = this.builder;
            K k = this.lastIteratedKey;
            TypeIntrinsics.asMutableMap((Object)map2).remove(k);
            Object k2 = currentKey;
            this.resetPath(k2 != null ? k2.hashCode() : 0, this.builder.getNode$runtime(), currentKey, 0);
        } else {
            Map map3 = this.builder;
            K k = this.lastIteratedKey;
            TypeIntrinsics.asMutableMap((Object)map3).remove(k);
        }
        this.lastIteratedKey = null;
        this.nextWasInvoked = false;
        this.expectedModCount = this.builder.getModCount$runtime();
    }

    public final void setValue(K key2, V newValue) {
        if (!this.builder.containsKey(key2)) {
            return;
        }
        if (this.hasNext()) {
            Object currentKey = this.currentKey();
            ((Map)this.builder).put(key2, newValue);
            Object k = currentKey;
            this.resetPath(k != null ? k.hashCode() : 0, this.builder.getNode$runtime(), currentKey, 0);
        } else {
            ((Map)this.builder).put(key2, newValue);
        }
        this.expectedModCount = this.builder.getModCount$runtime();
    }

    private final void resetPath(int keyHash, TrieNode<?, ?> node2, K key2, int pathIndex) {
        int shift = pathIndex * 5;
        if (shift > 30) {
            this.getPath()[pathIndex].reset(node2.getBuffer$runtime(), node2.getBuffer$runtime().length, 0);
            while (!Intrinsics.areEqual(this.getPath()[pathIndex].currentKey(), key2)) {
                this.getPath()[pathIndex].moveToNextKey();
            }
            this.setPathLastIndex(pathIndex);
            return;
        }
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (node2.hasEntryAt$runtime(keyPositionMask)) {
            int keyIndex = node2.entryKeyIndex$runtime(keyPositionMask);
            this.getPath()[pathIndex].reset(node2.getBuffer$runtime(), 2 * node2.entryCount$runtime(), keyIndex);
            this.setPathLastIndex(pathIndex);
            return;
        }
        int nodeIndex = node2.nodeIndex$runtime(keyPositionMask);
        TrieNode<?, ?> targetNode = node2.nodeAtIndex$runtime(nodeIndex);
        this.getPath()[pathIndex].reset(node2.getBuffer$runtime(), 2 * node2.entryCount$runtime(), nodeIndex);
        this.resetPath(keyHash, targetNode, key2, pathIndex + 1);
    }

    private final void checkNextWasInvoked() {
        if (!this.nextWasInvoked) {
            throw new IllegalStateException();
        }
    }

    private final void checkForComodification() {
        if (this.builder.getModCount$runtime() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

